// Explicit instantiation file.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882:
//

#include <bits/std_string.h>
#include <bits/std_algorithm.h>
#include <bits/std_locale.h>
#include <bits/std_vector.h>
#include <bits/std_iterator.h>
#include <bits/std_streambuf.h>
#include <bits/std_sstream.h>
#include <bits/std_fstream.h>
#include <bits/std_ios.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>


namespace std {

  //
  // string
  //
#if 0
  template class basic_string<char>;
#ifdef _G_USE_WCHAR_T
  template class basic_string<wchar_t>;
#endif
#else
  template 
    string::basic_string(string::iterator, string::iterator, allocator<char> const&);

  template 
    wstring::basic_string(wstring::iterator, wstring::iterator, allocator<wchar_t> const&);

  template 
    char* 
    string::_S_construct<char *>(char *, char *, allocator<char> const &, forward_iterator_tag);

  template 
    char* 
    string::_S_construct<const char *>(const char *, const char *, allocator<char> const &, forward_iterator_tag);
  
  template wchar_t* wstring::_S_construct<wchar_t *>(wchar_t *, wchar_t *, allocator<wchar_t> const &, forward_iterator_tag);
  
  template wchar_t* wstring::_S_construct<const wchar_t *>(const wchar_t *, const wchar_t *, allocator<wchar_t> const &, forward_iterator_tag);

  template 
    string& 
    string::_M_replace<char *>(string::iterator, string::iterator, char *, char *, forward_iterator_tag);
  
 template string& string::_M_replace<const char *>(string::iterator, string::iterator, const char *, const char *, forward_iterator_tag);
  
 template string& string::_M_replace<string::iterator>(string::iterator, string::iterator, string::iterator, string::iterator, forward_iterator_tag);
  
 template string& string::_M_replace<string::const_iterator>(string::iterator, string::iterator, string::const_iterator, string::const_iterator, forward_iterator_tag);
 
 template wstring& wstring::_M_replace<wchar_t *>(wstring::iterator, wstring::iterator, wchar_t *, wchar_t *, forward_iterator_tag);
 
 template wstring& wstring::_M_replace<const wchar_t *>(wstring::iterator, wstring::iterator, const wchar_t *, const wchar_t *, forward_iterator_tag);
 
 template wstring& wstring::_M_replace<wstring::iterator>(wstring::iterator, wstring::iterator, wstring::iterator, wstring::iterator, forward_iterator_tag);
 
    template wstring& wstring::_M_replace<wstring::const_iterator>(wstring::iterator, wstring::iterator, wstring::const_iterator, wstring::const_iterator, forward_iterator_tag);
  
  
#endif



  //
  // streambuf
  // 
  template class basic_streambuf<char>;
#ifdef _G_USE_WCHAR_T
  template class basic_streambuf<wchar_t>;
#endif


  //
  // stringstream
  //
  template class basic_stringbuf<char>;
#ifdef _G_USE_WCHAR_T
  //template class basic_stringbuf<wchar_t>;
#endif


  //
  // fstream
  //
  template class basic_filebuf<char, char_traits<char> >;
#ifdef _G_USE_WCHAR_T
  template class basic_filebuf<wchar_t, char_traits<wchar_t> >;
#endif


  //
  // basic_ios
  //
  template class basic_ios<char>;
#ifdef _G_USE_WCHAR_T
  template class basic_ios<wchar_t>;
#endif


  //
  // istream
  //
  template class basic_istream<char>;
#ifdef _G_USE_WCHAR_T
  template class basic_istream<wchar_t>;
#endif


  //
  // ostream
  //
  template class basic_ostream<char>;
#ifdef _G_USE_WCHAR_T
  template class basic_ostream<wchar_t>; 
#endif


  //
  // algorithm
  //
  typedef  _Char_traits_match<char, char_traits<char> > char_match;

  template 
    const char*  
    find_if<const char *, char_match>
    (const char *, const char *, char_match, random_access_iterator_tag);

#ifdef _G_USE_WCHAR_T
  typedef  _Char_traits_match<wchar_t, char_traits<wchar_t> > wchar_match;

  template const wchar_t*  
    find_if<const wchar_t*, wchar_match>
    (const wchar_t*, const wchar_t*, wchar_match, random_access_iterator_tag);
#endif
  
  template 
    string* 
    __uninitialized_fill_n_aux<string*, unsigned int, string>
    (string*, unsigned int, string const &, _Bool<false>);

  template 
    string* 
    __uninitialized_copy_aux<vector<string>::const_iterator, string *>
    (vector<string>::const_iterator, vector<string>::const_iterator, 
     string*, _Bool<false>);

} //std










