/* Parameters for hosting on an IA64 machine running HPUX, for GDB.
   Copyright 1991, 1992 Free Software Foundation, Inc. 

   This started out as a copy of config/pa/xm-hppah.h.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* Host is big-endian. */
#define	HOST_BYTE_ORDER	BIG_ENDIAN

#include "ia64/xm-ia64.h"

#define USG

#ifndef __STDC__
/* This define is discussed in decode_line_1 in symtab.c  */
#define HPPA_COMPILER_BUG
#endif

#define HAVE_TERMIOS

/* HP defines malloc and realloc as returning void *, even for non-ANSI
   compilations (such as with the native compiler). */

#define MALLOC_INCOMPATIBLE

#define U_REGS_OFFSET 0

/* Avoid "INT_MIN redefined" warnings -- by defining it here, exactly
   the same as in the system <machine/machtypes.h> file.  */
#undef  INT_MIN
#define INT_MIN         (-0x7FFFFFFF - 1)


extern void *
  malloc PARAMS ((size_t));

extern void *
  realloc PARAMS ((void *, size_t));

extern void
free PARAMS ((void *));

/* CC_HAS_LONG_LONG is defined so gdb will know what to do with long long's.  */

#ifndef CC_HAS_LONG_LONG
#define CC_HAS_LONG_LONG
#endif

/* PRINTF_HAS_LONG_LONG lets gdb know that printf can handle LONG LONG */

#define PRINTF_HAS_LONG_LONG	1
