/* Target specific file to be compiled along with infrtc.c to generate
 * librtc.sl.
 * This file has to define the functions:
 *      int get_frame_pc_list (void** pc_list)
 * Target: hp-ia64
 *
 * We use uwx routines to do the unwinding.
 * See man uwx or uwx.h and uwx_self.h header files for more info.
 * Result from the uwx routines if < UWX_OK means an error.
 */


#include <uwx.h> /* Unwind express */
#include <uwx_self.h> /* For self unwinding */
#include "defs.h"
#include "rtc.h"

/* Globals to hold the uwx data structures, unw enviornment and
   callback enviornment. */
__thread struct uwx_env *uenv;
__thread struct uwx_self_info *cbinfo;

extern int __rtc_frame_count;
extern void *rp_val;
__thread int uenv_initted = 0;


/* Returns __rtc_frame_count number of frame pc's by doing a stack trace. */
int
get_frame_pc_list (void ** pc_list)
{
  int result;
  uint64_t pc_val;
  int slot_no;
  int level = 0, j;

  if (__rtc_frame_count == 1)
    {
      /* If frame-count is 1, do the simple backtrace. Just get the rp. */
      pc_list[level++] = rp_val;
      return level;
    }

  /* Initialize the uwx data structures. */
  if (!uenv_initted)
    {
      uenv = uwx_init();
      cbinfo = uwx_self_init_info( uenv);
      /* Register the standard callbacks provided by libunwind. */
      result = uwx_register_callbacks(
                        uenv,
                        (intptr_t) cbinfo,
                        uwx_self_copyin,
                        uwx_self_lookupip);
      if (result < UWX_OK)
        {
          return level;
        }
      /* Set uenv_initted so that we don't have to do these
         initialization again. */
      uenv_initted = 1;
    }

  /* Initialize the current context */
  result = uwx_self_init_context (uenv);
  if (result < UWX_OK)
    {
      return level;
    }

  /* Skip 3 frames. These are the librtc frames. */
  for (j=0; ((j < 3) && (result == UWX_OK)); j++)
    {
      result = uwx_step (uenv);
    }
  if ((j != 2) && (result != UWX_OK))
    {
      return level;
    }
  
  /* Now get the stack trace and collect the PCs. */
  do
    {
      /* Get the PC for this frame. */
      result = uwx_get_reg (uenv, UWX_REG_IP, &pc_val);
      if (result < UWX_OK)
        {
	  return level;
        }

      /* Get the pc that's just before return_pc. */
      slot_no = pc_val & 0xF;
      pc_val = pc_val & ~0xFLL;
      switch (slot_no)
      {
      case 0:
	pc_val = pc_val - 14;
	break;
      case 1:
	pc_val = pc_val;
	break;
      case 2:
	pc_val = pc_val + 1;
	break;
      default:
	return level;
      }

      pc_list[level++] = (void *) (unsigned long) pc_val;
       
      /* Get the previous frame. */
      if ((result = uwx_step (uenv)) < UWX_OK)
        {
	  return level;
	}
    } while ((level < __rtc_frame_count) && (result != UWX_BOTTOM));
  
  return level;
}
