#include <sys/mman.h>
#include <sys/shm.h>
#include <stdlib.h>
#include <dl.h>

void main_allocate ();
void heap_report ();
void main_free ();
void other_file_free ();
void shl_first_file_allocate ();
void shl_first_file_free ();
void shl_next_file_allocate ();
void shl_next_file_free ();
void main_iallocate ();
void main_ifree ();
void other_file_iallocate ();
void other_file_ifree ();
void shl_first_file_iallocate ();
void shl_first_file_ifree ();
void shl_next_file_iallocate ();
void shl_next_file_ifree ();

int main()
{
    shl_t dll = 0;
    void (*dll_first_file_allocate)() = 0;
    void (*dll_first_file_free)() = 0;
    void (*dll_next_file_allocate)() = 0;
    void (*dll_next_file_free)() = 0;
    void (*dll_first_file_iallocate)() = 0;
    void (*dll_first_file_ifree)() = 0;
    void (*dll_next_file_iallocate)() = 0;
    void (*dll_next_file_ifree)() = 0;

    main_allocate ();
    heap_report (); 
    main_free ();
    heap_report (); 

    other_file_allocate ();
    heap_report ();
    other_file_free ();
    heap_report ();

    /* See if we intercept calls from a shared library ... */ 
    shl_first_file_allocate ();
    heap_report ();
    shl_first_file_free ();
    heap_report ();

    /* Call another module from the same shared library ... */
    shl_next_file_allocate ();
    heap_report ();
    shl_next_file_free ();
    heap_report ();

    /* See if we intercept indirect calls ... */
    main_iallocate ();
    heap_report ();
    main_ifree ();
    heap_report ();

    other_file_iallocate ();
    heap_report ();
    other_file_ifree ();
    heap_report ();
    
    /* See if we intercept indirect calls from a shared library ... */ 
    shl_first_file_iallocate ();
    heap_report ();
    shl_first_file_ifree ();
    heap_report ();

    /* Call another module from the same shared library ... */
    shl_next_file_iallocate ();
    heap_report ();
    shl_next_file_ifree ();
    heap_report ();

    /* Test shl_loaded library ... */

    dll = shl_load ("gdb.hp/gdb.defects/libintercept2.sl", BIND_DEFERRED, 0);

    shl_findsym(&dll,
           "dll_first_file_allocate",
           TYPE_PROCEDURE,
           &dll_first_file_allocate
      );
    shl_findsym(&dll,
           "dll_next_file_allocate",
           TYPE_PROCEDURE,
           &dll_next_file_allocate
      );
    shl_findsym(&dll,
           "dll_first_file_free",
           TYPE_PROCEDURE,
           &dll_first_file_free
      );
    shl_findsym(&dll,
           "dll_next_file_free",
           TYPE_PROCEDURE,
           &dll_next_file_free
      );
    shl_findsym(&dll,
           "dll_first_file_iallocate",
           TYPE_PROCEDURE,
           &dll_first_file_iallocate
      );
    shl_findsym(&dll,
           "dll_first_file_ifree",
           TYPE_PROCEDURE,
           &dll_first_file_ifree
      );
    shl_findsym(&dll,
           "dll_next_file_iallocate",
           TYPE_PROCEDURE,
           &dll_next_file_iallocate
      );
    shl_findsym(&dll,
           "dll_next_file_ifree",
           TYPE_PROCEDURE,
           &dll_next_file_ifree
      );
    /* See if we intercept calls from a shared library ... */ 
    dll_first_file_allocate ();
    heap_report ();
    dll_first_file_free ();
    heap_report ();

    /* Call another module from the same shared library ... */
    dll_next_file_allocate ();
    heap_report ();
    dll_next_file_free ();
    heap_report ();

    /* See if we intercept indirect calls from a shared library ... */ 
    dll_first_file_iallocate ();
    heap_report ();
    dll_first_file_ifree ();
    heap_report ();

    /* Call another module from the same shared library ... */
    dll_next_file_iallocate ();
    heap_report ();
    dll_next_file_ifree ();
    heap_report ();

    shl_unload (dll);
    
    /* Test shl_loaded library ... */

    dll = shl_load ("gdb.hp/gdb.defects/libintercept3.sl", BIND_IMMEDIATE, 0);

    /* See if we intercept calls from a shared library ... */ 

    shl_findsym(&dll,
           "dll_first_file_allocate",
           TYPE_PROCEDURE,
           &dll_first_file_allocate
      );
    shl_findsym(&dll,
           "dll_next_file_allocate",
           TYPE_PROCEDURE,
           &dll_next_file_allocate
      );
    shl_findsym(&dll,
           "dll_first_file_free",
           TYPE_PROCEDURE,
           &dll_first_file_free
      );
    shl_findsym(&dll,
           "dll_next_file_free",
           TYPE_PROCEDURE,
           &dll_next_file_free
      );
    shl_findsym(&dll,
           "dll_first_file_iallocate",
           TYPE_PROCEDURE,
           &dll_first_file_iallocate
      );
    shl_findsym(&dll,
           "dll_first_file_ifree",
           TYPE_PROCEDURE,
           &dll_first_file_ifree
      );
    shl_findsym(&dll,
           "dll_next_file_iallocate",
           TYPE_PROCEDURE,
           &dll_next_file_iallocate
      );
    shl_findsym(&dll,
           "dll_next_file_ifree",
           TYPE_PROCEDURE,
           &dll_next_file_ifree
      );
    dll_first_file_allocate ();
    heap_report ();
    dll_first_file_free ();
    heap_report ();

    /* Call another module from the same shared library ... */
    dll_next_file_allocate ();
    heap_report ();
    dll_next_file_free ();
    heap_report ();

    /* See if we intercept indirect calls from a shared library ... */ 
    dll_first_file_iallocate ();
    heap_report ();
    dll_first_file_ifree ();
    heap_report ();

    /* Call another module from the same shared library ... */
    dll_next_file_iallocate ();
    heap_report ();
    dll_next_file_ifree ();
    heap_report ();
    return 0;
}

void heap_report ()
{

}

static int shmid;

char * cp[10];
void main_allocate ()
{

    cp[0] = malloc (10);
    cp[1] = calloc (10, 2);
    cp[2] = realloc (0, 30);
    cp[3] = valloc (40);
    cp[4] = malloc (100);
    cp[4] = realloc (cp[4], 50);
    cp[5] = mmap (0, 60, PROT_READ | PROT_WRITE,
		MAP_ANONYMOUS | MAP_PRIVATE,
                -1, 
                0);
    if ((shmid = shmget (IPC_PRIVATE, 70, 0600)) == -1)
        perror("Boot machine. Tests have left behing shared memory segment");
    if ((cp[6] = shmat (shmid, 0, 0)) == SHM_FAILED)
        perror("shmat failed. Aborting test.");;
}

void main_free ()
{
    free (cp[0]);
    free (cp[1]);
    realloc (cp[2], 0);
    free (cp[3]);
    free (cp[4]);
    munmap(cp[5], 60);
    if (shmdt (cp[6]) == -1)
       perror("shmdt failed. Aborting test");
    if (shmctl (shmid, IPC_RMID, 0) == -1)
       perror("shmctl failed. Aborting test");
}

static void * (*imalloc)  (size_t size) = malloc;
static void   (*ifree)    (void * pointer) = free;
static void * (*icalloc)  (size_t nelem, size_t size) = calloc;
static void * (*irealloc) (void *pointer, size_t size) = realloc;
static void * (*ivalloc)  (size_t size) = valloc;

static void * (*immap)  (void *, size_t, int, int, int, off_t) = mmap;
static int (*imunmap) (void *, size_t) = munmap;

static void * (*ishmat) (int, const void *, int) = shmat;
static int (*ishmdt) (const void *) = shmdt;

void main_iallocate ()
{

    cp[0] = imalloc (10);
    cp[1] = icalloc (10, 2);
    cp[2] = irealloc (0, 30);
    cp[3] = ivalloc (40);
    cp[4] = imalloc (100);
    cp[4] = irealloc (cp[4], 50);
    cp[5] = immap (0, 60, PROT_READ | PROT_WRITE,
		MAP_ANONYMOUS | MAP_PRIVATE,
                -1, 
                0);
    if ((shmid = shmget (IPC_PRIVATE, 70, 0600)) == -1)
        perror("Boot machine. Tests have left behing shared memory segment");
    if ((cp[6] = ishmat (shmid, 0, 0)) == SHM_FAILED)
        perror("ishmat failed. Aborting test.");;
}

void main_ifree ()
{
    ifree (cp[0]);
    ifree (cp[1]);
    irealloc (cp[2], 0);
    ifree (cp[3]);
    ifree (cp[4]);
    imunmap(cp[5], 60);
    if (ishmdt (cp[6]) == -1)
       perror("ishmdt failed. Aborting test");
    if (shmctl (shmid, IPC_RMID, 0) == -1)
       perror("shmctl failed. Aborting test");
}

#if 0
#ifndef __LP64__
#pragma HP_LONG_RETURN __rtc_d_trap
#pragma HP_NO_RELOCATION __rtc_d_trap

static void
__rtc_d_trap (first, second, third, fourth, fifth)
int first, second, third, fourth, fifth;
{
 sigset_t oset;

 /* We are here due to a bind-on-reference notification from dld.
    We need to jump to the real debugger hook, if it is safe to
    do so. It is not safe if SIGTRAPs are disabled for the current
    thread, because the breakpoint will not trigger if SIGTRAPs are
    masked. The program cannot proceed meaningfully having it a
    breakpoint and bad things happen afterward. Fortunately signal
    masks are thread private on HP-UX -- srikanth, 000313.
 */

 sigprocmask(
            SIG_SETMASK,   /* Will be ignored since ...   */
            0,             /* ... this is a NULL pointer  */
            &oset);
 if (sigismember (&oset, SIGTRAP))
   return;

 /* Safe to jump to the real debugger hook ..., The original debugger
    hook gets passed variable number of arguments. But currently we
    treat only BOR events specially, everything else gets treated as
    a SHL_LOAD
 */

 __d_trap (first, second, third, fourth, fifth);
}
#endif
#endif
