/*
 *  @(#) dlfcn.h 1.0
 *
 *  (c) Copyright 1996 Hewlett-Packard Co., All Rights Reserved.
 */

#ifndef _DLFCN_INCLUDED
#define _DLFCN_INCLUDED
#include <sys/types.h>
#ifdef __cplusplus
extern "C" {
#endif

// Standard Interface 

/* dlopen flags */
#define RTLD_NOW        0x00000001  /* bind immediately */
#define RTLD_LAZY       0x00000002  /* bind deferred */
#define RTLD_GLOBAL     0x00000004  /* symbols are globally visible */
#define RTLD_LOCAL      0x00000008  /* symbols only visible to this load */

/* dlsym special handles */
#define RTLD_NEXT	((void*) -1L)  /* start symbol search from the dll
					  next to the caller of dlsym() */

#pragma HP_DEFINED_EXTERNAL	dlopen
#pragma HP_DEFINED_EXTERNAL	dlsym 
#pragma HP_DEFINED_EXTERNAL	dlclose
#pragma HP_DEFINED_EXTERNAL	dlerror

#ifdef __ia64
#pragma extern	dlopen
#pragma extern	dlsym 
#pragma extern	dlclose
#pragma extern	dlerror
#endif

#if defined(__STDC__) || defined(__cplusplus)
extern void*	dlopen(const char* filename,
                       int mode);

/* backward compatibility for Unix2003 API*/
#if !defined(__restrict)
#   define __restrict	/* nothing */
#endif
extern void*	dlsym(void* __restrict handle,
	              const char* __restrict name);

extern int	dlclose(void* handle);
extern char*	dlerror(void);

#else /* not __STDC__ || __cplusplus */
extern void*	dlopen();
extern void*	dlsym();
extern int	dlclose();
extern char*	dlerror();

#endif /* not __STDC__ || __cplusplus */

//  HPUX Interface
#ifdef _INCLUDE_HPUX_SOURCE

#ifdef __LP64__
typedef unsigned long		UINT64;
#else
typedef unsigned long long	UINT64;
#endif

/* Current libdl.sl version */
#define DL_CURRENT_VERSION	3

/* A Load module descriptor structure */
#ifndef _LOAD_MODULE_DESC_T
#define _LOAD_MODULE_DESC_T
struct load_module_desc {
   UINT64       text_base;
   UINT64       text_size;
   UINT64       data_base;
   UINT64       data_size;
   UINT64       unwind_base;
   UINT64       linkage_ptr;
   UINT64       phdr_base;
   UINT64       tls_size;
   UINT64       tls_start_addr;
   /* added in version 2 */
   UINT64       unwind_size;
   UINT64       tls_index;
#ifdef _LOAD_MODULE_DESC_EXT
   /* added in version 3 */
   UINT64       inode;
   UINT64       device;
   UINT64       checksum;
   UINT64       time_stamp;
   unsigned int version;
#endif /* _LOAD_MODULE_DESC_EXT */
};
#endif /* ! _LOAD_MODULE_DESC_T */

struct dld_hook_param {
   unsigned int version;
   char* filename; 
   union {
      struct { 
         unsigned int startup_load; 
         struct load_module_desc* desc; 
         size_t desc_size; 
      } load_event_desc; 
      struct { 
         struct load_module_desc* desc; 
         size_t desc_size; 
      } unload_event_desc; 
      struct { 
	 char*  sym_name;
         struct load_module_desc* desc; 
         size_t desc_size; 
      } bor_event_desc; 
      struct {
	 char* sym_name;
	 struct load_module_desc* desc;
	 size_t desc_size;
	 UINT64 opd_ptr;
      } opd_event_desc;
   } event_desc;
};

#define load_event 	event_desc.load_event_desc
#define unload_event 	event_desc.unload_event_desc
#define bor_event 	event_desc.bor_event_desc
#define opd_event       event_desc.opd_event_desc


#pragma HP_DEFINED_EXTERNAL	dlget
#pragma HP_DEFINED_EXTERNAL	dlmodinfo
#pragma HP_DEFINED_EXTERNAL	dlgetmodinfo
#pragma HP_DEFINED_EXTERNAL	dlgetname
#pragma HP_DEFINED_EXTERNAL	dlhook
#pragma HP_DEFINED_EXTERNAL	dlmodadd
#pragma HP_DEFINED_EXTERNAL	dlmodremove

#ifdef __ia64
#pragma extern	dlget
#pragma extern	dlmodinfo
#pragma extern	dlgetmodinfo
#pragma extern	dlgetname
#pragma extern	dlhook
#pragma extern	dlmodadd
#pragma extern	dlmodremove
#endif

#if defined(__STDC__) || defined(__cplusplus)
extern void*	dlget(int index, 
                      struct load_module_desc* desc,
                      unsigned int desc_size);
extern UINT64	dlmodinfo(UINT64 ip_value,
                          struct load_module_desc* desc,
                          size_t desc_size,
                          void* (*read_tgt_mem)(void* buffer,
                                                UINT64 ptr,
                                                size_t bufsiz,
                                                int ident),
                          int ident_parm,
                          UINT64 load_map_parm);
extern UINT64	dlgetmodinfo(int index,
			     struct load_module_desc* desc,
			     size_t desc_size,
			     void* (*read_tgt_mem)(void* buffer,
						   UINT64 ptr,
						   size_t bufsiz,
						   int ident),
			     int ident_parm,
			     UINT64 load_map_parm);
extern char*	dlgetname(struct load_module_desc* desc,
                          size_t desc_size,
                          void* (*read_tgt_mem)(void* buffer,
                                                UINT64 ptr,
                                                size_t bufsiz,
                                                int ident),
                          int ident_parm,
                          UINT64 load_map_parm);
extern int	dlhook(unsigned int flags, 
		       void (*dld_hook)(unsigned int type,
					struct dld_hook_param* arg));
extern void*    dlmodadd(void* associate_handle,
                         void *func_start,
                         size_t func_size,
                         void *linkage_ptr,
                         void *unwind_info);
extern int      dlmodremove(void* handle);
typedef struct {
   const char *dli_fname;
   void *dli_fbase;
   const char *dli_sname;
   void *dli_saddr;
#if defined(__LP64__) || defined(__ia64)
   size_t dli_size;
   int dli_bind;
#endif
   int dli_type;
} Dl_info;
extern int dladdr(void *address, Dl_info *dlip);
#else /* not __STDC__ || __cplusplus */
extern void*	dlget();
extern UINT64	dlmodinfo();
extern UINT64	dlgetmodinfo();
extern char*	dlgetname();
extern int	dlhook();
extern void*	dlmodadd();
extern int dlmodremove();
typedef struct {
   char *dli_fname;
   void *dli_fbase;
   char *dli_sname;
   void *dli_saddr;
#if defined(__LP64__) || defined(__ia64)
   size_t dli_size;
   int dli_bind;
#endif
   int dli_type;
} Dl_info;
extern int dladdr();
#endif /* not __STDC__ || __cplusplus */

/* additional dlopen flags */
#define RTLD_NOLOAD     0x00000010  /* don't load; see if already present */
#define RTLD_NODELETE   0x00000020  /* never unload */
#if defined(__LP64__) || defined(__ia64)  /* not yet supported by SOM dld */
#define RTLD_GROUP      0x00000040  /* bind unsats only to the same group */
#define RTLD_PARENT     0x00000080  /* bind unsats to caller also */
#define RTLD_WORLD      0x00000100  /* bind unsats to only global dlls */
#endif

/* dlsym special handles */
#define RTLD_DEFAULT	((void*) -2L)  /* lookup symbol from caller's scope */
#define RTLD_SELF	((void*) -3L)  /* start symbol search from the
                                          caller of dlsym() */

/* dlhook event flags */
#define DL_LOAD_PRE_INIT	0x00000001  /* load event before initializers */
#define DL_LOAD_POST_INIT	0x00000002  /* load event after initializers */
#define DL_LOAD_COMPLETE	0x00000004  /* load event complete */
#define DL_UNLOAD_PRE_FINI	0x00000008  /* unload event before terminators*/
#define DL_UNLOAD_POST_FINI	0x00000010  /* unload event after terminators */
#define DL_UNLOAD_COMPLETE	0x00000020  /* unload event complete */
#define DL_BOR			0x00000040  /* bind-on-reference event */
#define DL_DYN_OPD_POST_INIT    0x00000080  /* dynamic opd generation event 
					       after initializers */
#define DL_TERMINATE_START      0x00000100  /* begin program termination */

#endif	/* _INCLUDE_HPUX_SOURCE */

#ifdef __cplusplus
}
#endif
#endif /* _DLFCN_INCLUDED */
