/* Definitions to make GDB run on an Alpha box under OSF 1.
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (HOST_BYTE_ORDER)
#define HOST_BYTE_ORDER LITTLE_ENDIAN
#endif

/* Get rid of any system-imposed stack limit if possible */

#define	SET_STACK_LIMIT_HUGE

#define	MEM_FNS_DECLARED

#if ! defined (__STDC__) && ! defined (offsetof)
# define offsetof(TYPE, MEMBER) ((unsigned long) &((TYPE *)0)->MEMBER)
#endif

/*#define MALLOC_INCOMPATIBLE*/

extern void free PARAMS ((void *));

#define NO_SIGINTERRUPT

#define KERNEL_U_ADDR 0


#define MAKEVA_END(list)  		\
{ 					\
  va_list ret;				\
  ret.a0 = (char *)(list)->aligner.arg_bytes;	\
  ret.offset = (list)->argindex;	\
  return ret;				\
}
