/*	Copyright (C) 1994 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * Tom Lord
 * Cygnus Support
 */

%{
#include "ctax.h"
#include "ctax-parse.h"
extern int parse_line_no;
%}

DIGIT [0-9]
NUMBER {DIGIT}+("."{DIGIT}*)?
%%
[\n]		++parse_line_no;
[ \t]*
\/\/.*
{NUMBER}	{
		  show("ctax_number_lx");
		  yylval = parse_number(yytext);
		  return ctax_number_lx;
		}
scm		show("ctax_SCM_lx"); return ctax_SCM_lx;
if		show("ctax_if_lx"); return ctax_if_lx;
else		show("ctax_else_lx"); return ctax_else_lx;
for		show("ctax_for_lx"); return ctax_for_lx;
while		show("ctax_while_lx"); return ctax_while_lx;
return		show("return"); return ctax_return_lx;
do		show("ctax_do_lx"); return ctax_do_lx;
break		show("ctax_break_lx"); return ctax_break_lx;
continue	show("ctax_continue_lx"); return ctax_continue_lx;
interactive	show("ctax_interactive_lx"); return ctax_interactive_lx;
struct		show("ctax_struct_lx"); return ctax_struct_lx;
new		show("ctax_new_lx"); return ctax_new_lx;
\@bit		show("'@b'"); return ctax_bit_array_lx;
\@uint		show("'@u'"); return ctax_uint_array_lx;
\@int		show("'@i'"); return ctax_int_array_lx;
\@float		show("'@f'"); return ctax_float_array_lx;
\@double	show("'@d'"); return ctax_double_array_lx;
\@complex	show("'@c'"); return ctax_complex_array_lx;
\@		show("'@'"); return '@';
[a-z][a-z?!<>=0-9_]*	{
			  show("ctax_id_lx");
			  yylval = parse_intern (yytext);
		          return ctax_id_lx;
		        }
\.		show("'.'"); return ctax_field_ref_lx;
-\>		show("'->'"); return ctax_field_ref_lx;
\[		show("'['"); return '[';
\]		show("']'"); return ']';
\\		show("'\\'"); return '\\';
=		show("'='"); return '=';
\+		show("'+'"); return '+';
-		show("'-'"); return '-';
\*		show("'*'"); return '*';
\/		show("'/'"); return '/';
&		show("'&'"); return '&';
\|		show("'|'"); return '|';
~		show("'~'"); return '~';
!		show("'!'"); return '!';
\^		show("'^'"); return '^';
%		show("'%'"); return '%';
;		show("';'"); return ';';
\<		show("'<'"); return '<';
>		show("'>'"); return '>';
,		show("','"); return ',';
\?		show("'?'"); return '?';
:		show("':'"); return ':';
\(		show("'('"); return '(';
\)		show("')'"); return ')';
==		show("ctax_eq_lx"); return ctax_eq_lx;
!=		show("ctax_ne_lx"); return ctax_ne_lx;
>=		show("ctax_ge_lx"); return ctax_ge_lx;
\<=		show("ctax_le_lx"); return ctax_le_lx;
\<\<		show("ctax_lshift_lx"); return ctax_lshift_lx;
\>\>		show("ctax_rshift_lx"); return ctax_rshift_lx;
&&		show("ctax_and_lx"); return ctax_and_lx;
\|\|		show("ctax_or_lx"); return ctax_or_lx;
\.:		show("'.:'"); return ctax_field_ref_col_lx;
->:		show("'->:'"); return ctax_field_ref_col_lx;
\[:		show("'[:'"); return ctax_subs_left_col_lx;
\]:		show("']:'"); return ctax_subs_right_col_lx;
=:		show("'=:'"); return ctax_assign_col_lx;
\+:		show("'+:'"); return ctax_add_col_lx;
-:		show("'-:'"); return ctax_subtract_col_lx;
\*:		show("'*:'"); return ctax_multiply_col_lx;
\/:		show("'/:'"); return ctax_divide_col_lx;
&:		show("'&:'"); return ctax_bitand_col_lx;
\|:		show("'|:'"); return ctax_bitor_col_lx;
~:		show("'~:'"); return ctax_bitnot_col_lx;
!:		show("'!:'"); return ctax_lognot_col_lx;
\^:		show("'^:'"); return ctax_bitxor_col_lx;
%:		show("'%:'"); return ctax_modulo_col_lx;
\<:		show("'<:'"); return ctax_less_col_lx;
>:		show("'>:'"); return ctax_greater_col_lx;
==:		show("ctax_eq_l:x"); return ctax_eq_col_lx;
!=:		show("ctax_ne_l:x"); return ctax_ne_col_lx;
>=:		show("ctax_ge_l:x"); return ctax_ge_col_lx;
\<=:		show("ctax_le_l:x"); return ctax_le_col_lx;
\<\<:		show("ctax_lshift_l:x"); return ctax_lshift_col_lx;
\>\>:		show("ctax_rshift_l:x"); return ctax_rshift_col_lx;
&&:		show("ctax_and_l:x"); return ctax_and_col_lx;
\|\|:		show("ctax_or_l:x"); return ctax_or_col_lx;
\"([^\"\\]*(\\\")?)*\"    {
			    show("ctax_string_lx");
			    yylval = parse_make_string (yytext);
			    return ctax_string_lx;
			  }

'.'			  {
			    show("ctax_char_lx");
			    yylval = parse_make_char (yytext);
			    return ctax_char_lx;
			  }
\{			  show("{"); return '{';
\}			  show("}"); return '}';
%%

show (s)
  char * s;
{
#if 0
  printf ("lex: %s %s\n", s, yytext);
#endif
}

yyerror (msg)
  char * msg;
{
  printf ("%s\n", msg);
}
