/*	Copyright (C) 1994 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * Tom Lord
 * Cygnus Support
 */

%{
#include "ctax.h"
extern int parse_line_no;
extern YYSTYPE parse_answer;

extern YYSTYPE parse_cons ();
extern YYSTYPE parse_2list ();
extern YYSTYPE parse_append ();
extern YYSTYPE parse_append_optcons ();
extern YYSTYPE parse_eol;
extern YYSTYPE parse_false;
extern YYSTYPE parse_define_sym;
extern YYSTYPE parse_SCM_sym;
extern YYSTYPE parse_if_sym;
extern YYSTYPE parse_while_sym;
extern YYSTYPE parse_for_sym;
extern YYSTYPE parse_return_sym;
extern YYSTYPE parse_break_sym;
extern YYSTYPE parse_continue_sym;
extern YYSTYPE parse_comma_sym;
extern YYSTYPE parse_begin_sym;
extern YYSTYPE parse_do_sym;
extern YYSTYPE parse_scheme_val_sym;
extern YYSTYPE parse_scheme_kw_sym;
extern YYSTYPE parse_neg_sym;
extern YYSTYPE parse_log_neg_sym;
extern YYSTYPE parse_pos_sym;
extern YYSTYPE parse_bit_neg_sym;
extern YYSTYPE parse_bit_and_sym;
extern YYSTYPE parse_times_sym;
extern YYSTYPE parse_div_sym;
extern YYSTYPE parse_mod_sym;
extern YYSTYPE parse_plus_sym;
extern YYSTYPE parse_minus_sym;
extern YYSTYPE parse_lshift_sym;
extern YYSTYPE parse_rshift_sym;
extern YYSTYPE parse_eq_sym;
extern YYSTYPE parse_ne_sym;
extern YYSTYPE parse_le_sym;
extern YYSTYPE parse_ge_sym;
extern YYSTYPE parse_lt_sym;
extern YYSTYPE parse_gt_sym;
extern YYSTYPE parse_bit_and_sym;
extern YYSTYPE parse_bit_xor_sym;
extern YYSTYPE parse_bit_or_sym;
extern YYSTYPE parse_log_and_sym;
extern YYSTYPE parse_log_or_sym;
extern YYSTYPE parse_assign_sym;
extern YYSTYPE parse_aref_sym;
extern YYSTYPE parse_if_exp_sym;
extern YYSTYPE parse_apply_sym;
extern YYSTYPE parse_lambda_sym;
extern YYSTYPE parse_list_sym;
extern YYSTYPE parse_array_sym;
extern YYSTYPE parse_bit_array_sym;
extern YYSTYPE parse_uint_array_sym;
extern YYSTYPE parse_int_array_sym;
extern YYSTYPE parse_float_array_sym;
extern YYSTYPE parse_double_array_sym;
extern YYSTYPE parse_complex_array_sym;
extern YYSTYPE parse_struct_sym;
extern YYSTYPE parse_struct_type_sym;
extern YYSTYPE parse_make_struct_sym;
extern YYSTYPE parse_field_ref_sym;
extern YYSTYPE parse_field_ref_col_sym;
extern YYSTYPE parse_aref_col_sym;
extern YYSTYPE parse_assign_col_sym;
extern YYSTYPE parse_times_col_sym;
extern YYSTYPE parse_mod_col_sym;
extern YYSTYPE parse_plus_col_sym;
extern YYSTYPE parse_minus_col_sym;
extern YYSTYPE parse_lshift_col_sym;
extern YYSTYPE parse_rshift_col_sym;
extern YYSTYPE parse_eq_col_sym;
extern YYSTYPE parse_ne_col_sym;
extern YYSTYPE parse_le_col_sym;
extern YYSTYPE parse_ge_col_sym;
extern YYSTYPE parse_lt_col_sym;
extern YYSTYPE parse_gt_col_sym;
extern YYSTYPE parse_bit_and_col_sym;
extern YYSTYPE parse_bit_or_col_sym;
extern YYSTYPE parse_log_and_col_sym;
extern YYSTYPE parse_log_or_col_sym;
extern YYSTYPE parse_bit_neg_col_sym;
extern YYSTYPE parse_log_neg_col_sym;
%}

%right '?' ':'
%left ','
%left '='
%left ctax_or_lx
%left ctax_and_lx
%left '|'
%left '^'
%left '&'
%left ctax_eq_lx ctax_ne_lx
%left '<' '>' ctax_le_lx ctax_ge_lx
%left ctax_lshift_lx ctax_rshift_lx
%left '+' '-'
%left '*' '/' '%'
%right UNARY

%token ctax_number_lx
%token ctax_id_lx
%token ctax_SCM_lx
%token ctax_if_lx
%token ctax_else_lx
%token ctax_for_lx
%token ctax_while_lx
%token ctax_return_lx
%token ctax_do_lx
%token ctax_break_lx
%token ctax_continue_lx
%token ctax_interactive_lx
%token ctax_string_lx
%token ctax_char_lx
%token ctax_bit_array_lx
%token ctax_uint_array_lx
%token ctax_int_array_lx
%token ctax_float_array_lx
%token ctax_double_array_lx
%token ctax_complex_array_lx
%token ctax_struct_lx
%token ctax_field_ref_lx
%token ctax_new_lx
%token ctax_field_ref_col_lx
%token ctax_field_ref_col_lx
%token ctax_subs_left_col_lx
%token ctax_subs_right_col_lx
%token ctax_assign_col_lx
%token ctax_add_col_lx
%token ctax_subtract_col_lx
%token ctax_multiply_col_lx
%token ctax_divide_col_lx
%token ctax_bitand_col_lx
%token ctax_bitor_col_lx
%token ctax_bitnot_col_lx
%token ctax_lognot_col_lx
%token ctax_bitxor_col_lx
%token ctax_modulo_col_lx
%token ctax_less_col_lx
%token ctax_greater_col_lx
%token ctax_eq_col_lx
%token ctax_ne_col_lx
%token ctax_ge_col_lx
%token ctax_le_col_lx
%token ctax_lshift_col_lx
%token ctax_rshift_col_lx
%token ctax_and_col_lx
%token ctax_or_col_lx



%%
command:		definition
			  	     { parse_answer = $1; YYACCEPT; }
			| statement
			  	     { parse_answer = $1; YYACCEPT; }
			;

definition:		ctax_SCM_lx ctax_id_lx '=' initializer ';'
				     {
				       $$ = 
				       parse_cons
					 (parse_SCM_sym,
					  parse_2list
					  (parse_cons ($2, parse_eol), $4));
				     }

			| ctax_struct_lx ctax_id_lx opt_superclass '{' field_list '}' ';'
				     {
				       $$ =
					 parse_cons (parse_SCM_sym,
						     parse_2list
						     (parse_cons ($2, parse_eol)),
						     (parse_cons
						      (parse_struct_sym,
						       (parse_cons ($2,
								    parse_2list ($5, $3))))));
				     }

			| ctax_SCM_lx symbol_list ';'
				     {
				       $$ = 
				       parse_cons
					 (parse_SCM_sym,
					  parse_2list
					  ($2, parse_number ("0")));
				     }
			

			| ctax_SCM_lx ctax_id_lx definition_form
				     {
				       $$ =
				       parse_cons
				       (parse_define_sym,
				        parse_cons
				        ($2, $3));
				     }
			;

symbol_list:		ctax_id_lx
				     { $$ = parse_cons ($1, parse_eol); }
			| symbol_list ',' ctax_id_lx
				     { $$ = parse_append ($1, $3); }
			;

initializer:		expression
			    	     { $$ = $1; }
			;


opt_superclass:		':' ctax_id_lx
				     { $$ = $2; }
			|
				     { $$ = parse_false; }

field_list:		ctax_id_lx ';'
				     { $$ = parse_cons ($1, parse_eol); }
			| ctax_SCM_lx ctax_id_lx ';'
				     { $$ = parse_cons ($2, parse_eol); }
			| field_list ctax_id_lx ';'
				     { $$ = parse_append ($1, $3); }
			| field_list ctax_SCM_lx ctax_id_lx ';'
				     { $$ = parse_append ($1, $4); }
			|
				     { $$ = parse_eol; }
			;

definition_form:	'(' parameter_list ')' opt_doc opt_interaction body
				     {
				       $$ =
					 parse_cons
					   ($2,
					    parse_cons
					    ($4, parse_2list ($5, $6)));
				     }
			;

parameter_list:		ctax_id_lx
				     { $$ = parse_cons ($1, parse_eol); }
			| ctax_SCM_lx ctax_id_lx
				     { $$ = parse_cons ($2, parse_eol); }
			| parameter_list ',' ctax_id_lx
				     { $$ = parse_append ($1, $3); }
			| parameter_list ',' ctax_SCM_lx ctax_id_lx
				     { $$ = parse_append ($1, $4); }
			|
				     { $$ = parse_eol; }
			;

opt_doc:		ctax_string_lx
				     { $$ = $1; }
			|
				     { $$ = parse_false; }
			;

opt_interaction:	ctax_interactive_lx expression
				     { $$ = $2; }
			|
				     { $$ = parse_false; }
			;

body:			'{' local_definition_list statement_list '}'
				     {
				       $$
				       = parse_cons
				         (parse_begin_sym,
					  parse_cons ($2, $3));
				      }
			;

local_definition_list:	definition
				     { $$ = parse_cons ($1, parse_eol); }
			| local_definition_list definition
				     { $$ = parse_append ($1, $2); }
			|
				     { $$ = parse_eol; }
			;

statement_list:		statement
				     { $$ = parse_cons ($1, parse_eol); }
			| statement_list statement
				     { $$ = parse_append ($1, $2); }
			;

statement:		expression ';'
				     { $$ = $1; }
			| ctax_if_lx '(' expression ')' statement opt_else
				     {
				       $$
				       = parse_cons (parse_if_sym,
						     parse_cons
						     ($3,
						      parse_2list ($5, $6)));
				      }
			| ctax_while_lx '(' expression ')' statement
				     {
				       $$
				       = parse_cons (parse_while_sym,
						     parse_2list ($3, $5));
				      }
			| ctax_for_lx '(' exp1 ';' exp1 ';' exp1  ')'
			    statement
				     {
				       $$
				       = parse_cons
				         (parse_for_sym,
					  parse_cons
					  ($3,
					   parse_cons ($5,
						       parse_2list ($7, $9))));
				      }
			| ctax_do_lx
			     statement
			  ctax_while_lx '(' expression ')' ';'
				     {
				       $$
				       = parse_cons (parse_do_sym,
						     parse_2list ($5, $2));
				      }
			| '{' local_definition_list statement_list '}'
				     {
				       $$
				       = parse_cons
				         (parse_begin_sym,
					  parse_cons ($2, $3));
				      }
			| ctax_return_lx opt_expression ';'
				     {
				       $$
				       = parse_2list (parse_return_sym, $2);
				      }
			| ctax_break_lx ';'
				     { $$ = parse_break_sym; }

			| ctax_continue_lx ';'
				     { $$ = parse_continue_sym; }
			;

opt_expression:		expression
				     { $$ = $1; }
			|
				     { $$ = parse_false; }
			;

opt_else:		ctax_else_lx statement
				     { $$ = $2; }
			|
				     { $$ = parse_false; }
			;


expression:		exp1
			   { $$ = $1; }

exp1	:	exp
			   { $$ = $1; }
	|	exp1 ',' exp
			   {
			     $$ = parse_cons (parse_comma_sym,
					      parse_2list ($1, $3));
			   }
	;

/* Expressions, not including the comma operator.  */
exp	:	'-' exp    %prec UNARY
			   {
			     $$ = parse_2list (parse_neg_sym, $2);
			   }
	|	'!' exp    %prec UNARY
			   {
			     $$ = parse_2list (parse_log_neg_sym, $2);
			   }
	|	ctax_lognot_col_lx exp    %prec UNARY
			   {
			     $$ = parse_2list (parse_log_neg_col_sym, $2);
			   }
	|	'~' exp    %prec UNARY
			   {
			     $$ = parse_2list (parse_bit_neg_sym, $2);
			   }
	|	ctax_bitnot_col_lx exp    %prec UNARY
			   {
			     $$ = parse_2list (parse_bit_neg_col_sym, $2);
			   }
	|	'(' exp1 ')'
			   {
			     $$ = $2;
			   }
	|	exp '(' arg_list ')'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list ($1, $3)); }

	| 	'@' '(' arg_list ')'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_list_sym, $3)); }
	| 	'@' '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_array_sym, $3)); }

	| 	ctax_bit_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_bit_array_sym, $3)); }

	| 	ctax_uint_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_uint_array_sym, $3)); }

	| 	ctax_int_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_int_array_sym, $3)); }

	| 	ctax_float_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_float_array_sym, $3)); }

	| 	ctax_double_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_double_array_sym, $3)); }

	| 	ctax_complex_array_lx '[' arg_list ']'
			   { $$ = parse_cons (parse_apply_sym,
					       parse_2list (parse_complex_array_sym, $3)); }



	|       '@' '\\' definition_form
			   { $$ = parse_cons (parse_lambda_sym, $3); }

	| ctax_new_lx ctax_struct_lx ctax_id_lx opt_params
		           {
			     $$ = parse_cons (parse_make_struct_sym,
					      parse_cons ($3, $4));
			   }
	| '(' ctax_struct_lx ctax_id_lx ')' '{' arg_list '}' 
		           {
			     $$ = parse_cons (parse_make_struct_sym,
					      parse_cons ($3, $6));
			   }
	| '(' ctax_struct_lx ctax_id_lx ')' 
		           {
			     $$ = parse_2list (parse_struct_type_sym, $3);
			   }
	| '(' ctax_struct_lx ctax_id_lx opt_superclass '{' field_list '}' ')'
		           {
			     $$ = parse_cons (parse_struct_sym,
					      (parse_cons ($2,
							   parse_2list ($5, $3))));
			   }



	;

opt_params:	'(' arg_list ')'
			   {
			     $$ = $2;
			   }
        |
			   {
			     $$ = parse_eol;
			   }

/* Binary operators in order of decreasing precedence.  */
exp	:	exp ctax_field_ref_lx ctax_id_lx
			   {
			     $$ =
			     parse_cons (parse_field_ref_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_field_ref_col_lx ctax_id_lx
			   {
			     $$ =
			     parse_cons (parse_field_ref_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '[' exp ']'
			   {
			     $$ =
			     parse_cons (parse_aref_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_subs_left_col_lx exp ctax_subs_right_col_lx
			   {
			     $$ =
			     parse_cons (parse_aref_col_sym,
					  parse_2list ($1, $3));
			   }
	|       exp '=' exp
			   {
			     $$ =
			     parse_cons (parse_assign_sym,
					  parse_2list ($1, $3));
			   }
	|       exp ctax_assign_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_assign_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '*' exp
			   {
			     $$ =
			     parse_cons (parse_times_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_multiply_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_times_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '/' exp
			   {
			     $$ =
			     parse_cons (parse_div_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_divide_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_div_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '%' exp
			   {
			     $$ =
			     parse_cons (parse_mod_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_modulo_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_mod_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '+' exp
			   {
			     $$ =
			     parse_cons (parse_plus_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_add_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_plus_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '-' exp
			   {
			     $$ =
			     parse_cons (parse_minus_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_subtract_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_minus_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_lshift_lx exp
			   {
			     $$ =
			     parse_cons (parse_lshift_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_lshift_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_lshift_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_rshift_lx exp
			   {
			     $$ =
			     parse_cons (parse_rshift_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_rshift_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_rshift_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_eq_lx exp
			   {
			     $$ =
			     parse_cons (parse_eq_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_eq_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_eq_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_ne_lx exp
			   {
			     $$ =
			     parse_cons (parse_ne_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_ne_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_ne_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_le_lx exp
			   {
			     $$ =
			     parse_cons (parse_le_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_le_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_le_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_ge_lx exp
			   {
			     $$ =
			     parse_cons (parse_ge_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_ge_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_ge_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '<' exp
			   {
			     $$ =
			     parse_cons (parse_lt_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_less_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_lt_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '>' exp
			   {
			     $$ =
			     parse_cons (parse_gt_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_greater_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_gt_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '&' exp
			   {
			     $$ =
			     parse_cons (parse_bit_and_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_bitand_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_bit_and_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '^' exp
			   {
			     $$ =
			     parse_cons (parse_bit_xor_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_bitxor_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_bit_xor_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '|' exp
			   {
			     $$ =
			     parse_cons (parse_bit_or_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_bitor_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_bit_or_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_and_lx exp
			   {
			     $$ =
			     parse_cons (parse_log_and_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_and_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_log_and_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_or_lx exp
			   {
			     $$ =
			     parse_cons (parse_log_or_sym,
					  parse_2list ($1, $3));
			   }
	|	exp ctax_or_col_lx exp
			   {
			     $$ =
			     parse_cons (parse_log_or_col_sym,
					  parse_2list ($1, $3));
			   }
	|	exp '?' exp ':' exp
			   {
			     $$ =
			     parse_cons (parse_if_exp_sym,
					  parse_cons ($1, 
						       parse_2list ($3,$5)));
			   }
	|	ctax_number_lx
			   { $$ = $1; }
	|	ctax_char_lx
			   { $$ = $1; }
	|	ctax_string_lx
			   { $$ = $1; }
	|	ctax_id_lx
			   { $$ = $1; }

	|	'@' ':' ctax_id_lx
			   { $$ = parse_2list (parse_scheme_kw_sym, $3); }
	|	'@' ctax_string_lx
			   { $$ = parse_2list (parse_scheme_val_sym, $2); }
	;

arg_list:	exp
		        { $$ = parse_cons ($1, parse_eol); }
	|	arg_list ',' exp
			{ $$ = parse_append ($1, $3); }
	|
			{ $$ = parse_eol; }


%%

int parse_line_no;
YYSTYPE parse_answer;
YYSTYPE parse_eol;
YYSTYPE parse_false;
YYSTYPE parse_define_sym;
YYSTYPE parse_SCM_sym;
YYSTYPE parse_if_sym;
YYSTYPE parse_while_sym;
YYSTYPE parse_for_sym;
YYSTYPE parse_return_sym;
YYSTYPE parse_break_sym;
YYSTYPE parse_continue_sym;
YYSTYPE parse_comma_sym;
YYSTYPE parse_do_sym;
YYSTYPE parse_scheme_val_sym;
YYSTYPE parse_scheme_kw_sym;
YYSTYPE parse_begin_sym;
YYSTYPE parse_neg_sym;
YYSTYPE parse_log_neg_sym;
YYSTYPE parse_pos_sym;
YYSTYPE parse_bit_neg_sym;
YYSTYPE parse_bit_and_sym;
YYSTYPE parse_times_sym;
YYSTYPE parse_div_sym;
YYSTYPE parse_mod_sym;
YYSTYPE parse_plus_sym;
YYSTYPE parse_minus_sym;
YYSTYPE parse_lshift_sym;
YYSTYPE parse_rshift_sym;
YYSTYPE parse_eq_sym;
YYSTYPE parse_ne_sym;
YYSTYPE parse_le_sym;
YYSTYPE parse_ge_sym;
YYSTYPE parse_lt_sym;
YYSTYPE parse_gt_sym;
YYSTYPE parse_bit_and_sym;
YYSTYPE parse_bit_xor_sym;
YYSTYPE parse_bit_or_sym;
YYSTYPE parse_log_and_sym;
YYSTYPE parse_log_or_sym;
YYSTYPE parse_if_exp_sym;
YYSTYPE parse_apply_sym;
YYSTYPE parse_lambda_sym;
YYSTYPE parse_list_sym;
YYSTYPE parse_array_sym;
YYSTYPE parse_bit_array_sym;
YYSTYPE parse_uint_array_sym;
YYSTYPE parse_int_array_sym;
YYSTYPE parse_float_array_sym;
YYSTYPE parse_double_array_sym;
YYSTYPE parse_complex_array_sym;
YYSTYPE parse_struct_sym;
YYSTYPE parse_struct_type_sym;
YYSTYPE parse_make_struct_sym;
YYSTYPE parse_field_ref_sym;
YYSTYPE parse_assign_sym;
YYSTYPE parse_aref_sym;
YYSTYPE parse_field_ref_col_sym;
YYSTYPE parse_aref_col_sym;
YYSTYPE parse_assign_col_sym;
YYSTYPE parse_times_col_sym;
YYSTYPE parse_mod_col_sym;
YYSTYPE parse_plus_col_sym;
YYSTYPE parse_minus_col_sym;
YYSTYPE parse_lshift_col_sym;
YYSTYPE parse_rshift_col_sym;
YYSTYPE parse_eq_col_sym;
YYSTYPE parse_ne_col_sym;
YYSTYPE parse_le_col_sym;
YYSTYPE parse_ge_col_sym;
YYSTYPE parse_lt_col_sym;
YYSTYPE parse_gt_col_sym;
YYSTYPE parse_bit_and_col_sym;
YYSTYPE parse_bit_or_col_sym;
YYSTYPE parse_log_and_col_sym;
YYSTYPE parse_log_or_col_sym;
YYSTYPE parse_bit_neg_col_sym;
YYSTYPE parse_log_neg_col_sym;

YYSTYPE parse_root;


void
parse_protect (a)
     YYSTYPE a;
{
  SCM protector;
  NEWCELL(protector);
  CAR(protector) = a;
  CDR(protector) = parse_root;
  parse_root = protector;
}

YYSTYPE
parse_intern (s)
     char * s;
{
  SCM answer;
  int len;
  len = strlen (s);
  {
    int x;
    for (x = 0; x < len; ++x)
      switch (s[x])
	{
	default:
	  break;
	case '_':
	  s[x] = '-';
	}
  }
  answer = scm_intern (s, strlen(s));
  if (CDR(answer) == SCM_UNDEFINED)
    CDR (answer) = MAKINUM(0);
  parse_protect (answer);
  return CAR(answer);
}


YYSTYPE
parse_make_string (s)
     char * s;
{
  SCM answer;
  char * out;
  char * in;
  in = s + 1;
  out = s;
 interpret_char:
  switch (*in)
    {
    default:
      *out = *in;
      ++out;
      ++in;
      goto interpret_char;
    case '"':
      break;
    case '\\':
      ++in;
      switch (*in)
	{
	default:
	  *out = *in;
	  ++out;
	  ++in;
	  goto interpret_char;
	case 'n':
	  *out = '\n';
	  ++out;
	  ++in;
	  goto interpret_char;
	case 'r':
	  *out = '\r';
	  ++out;
	  ++in;
	  goto interpret_char;
	case 't':
	  *out = '\t';
	  ++out;
	  ++in;
	  goto interpret_char;
	case '0':
	  {
	    int x;
	    int len;
	    ++in;
	    len = 1;
	    x = 0;
	    while (('0' < *in) && ('8' > *in) && (len < 4))
	      {
		x *= 8;
		x += (*in - '0');
		++in;
	      }
	    *out = x;
	    ++out;
	    ++in;
	    goto interpret_char;
	  }
	}
    }
  *out = 0;
  {
    int len;
    len = strlen (s);
    answer = scm_makstr (len, 0);
    memcpy (CHARS(answer), s, len);
  }
  parse_protect (answer);
  return answer;
}

YYSTYPE
parse_make_char (s)
     char * s;
{
  int c;
  char * in;
  in = s + 1;
  switch (*in)
    {
    default:
      c = *in;
      break;
    case '\\':
      ++in;
      switch (*in)
	{
	default:
	  c = *in;
	  break;
	case 'n':
	  c = '\n';
	  break;
	case 'r':
	  c = '\r';
	  break;
	case 't':
	  c = '\t';
	  break;
	case '0':
	  {
	    int x;
	    int len;
	    ++in;
	    len = 1;
	    x = 0;
	    while (('0' < *in) && ('8' > *in) && (len < 4))
	      {
		x *= 8;
		x += (*in - '0');
		++in;
	      }
	    c = x;
	    break;
	  }
	}
    }

  return MAKICHR (c);
}


YYSTYPE 
parse_cons (a, b)
     YYSTYPE a;
     YYSTYPE b;
{
  SCM answer;
  NEWCELL(answer);
  CAR(answer) = a;
  CDR(answer) = b;
  parse_protect (answer);
  return answer;
}

YYSTYPE 
parse_append (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  SCM newc;
  SCM orig;
  newc = parse_cons (p, parse_eol);

  if (l == EOL)
    return newc;

  orig = l;
  while (NIMP(l) && NIMP (CDR(l)))
    l = CDR(l);

  if (NIMP(l))
    CDR(l) = newc;

  return orig;
}

YYSTYPE 
parse_append_optcons (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  if (NIMP (p))
    return parse_append (l, p);
  else
    {
      SCM last;
      NEWCELL (last);
      CAR(last) = p;
      CDR(last) = parse_eol;
      return parse_append (l, last);
    }  
}


YYSTYPE 
parse_2list (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  SCM newc;
  NEWCELL (newc);
  CAR(newc) = p;
  CDR(newc) = EOL;
  return parse_cons (l, newc);
}

YYSTYPE
parse_number (t)
     char * t;
{
  return scm_istring2number (t, strlen (t), 10);
}

SCM ctax_burst_fn;
static char * parse_buffer;
static char * parse_buffer_pos;

int
parse_input (buf, max_size)
     char * buf;
     int max_size;
{
  SCM str;
  int result;
  str = scm_apply (ctax_burst_fn, EOL, EOL);
  if (NIMP(str) && STRINGP(str))
    {
      memcpy (buf, CHARS(str), LENGTH(str));
      return LENGTH(str);
    }
  else
    return 0;
}

#ifdef __STDC__
void
scm_init_ctax_parser (void)
#else
void
scm_init_ctax_parser ()
#endif
{
  parse_eol = EOL;
  parse_false = BOOL_F;

  parse_root = scm_sysintern ("ctax:parse-root", EOL);
  parse_SCM_sym = CAR(scm_sysintern ("ctax:SCM", MAKINUM(0)));
  parse_define_sym = CAR(scm_sysintern ("ctax:define", MAKINUM(0)));
  parse_if_sym = CAR(scm_sysintern ("ctax:if", MAKINUM(0)));
  parse_while_sym = CAR(scm_sysintern ("ctax:while", MAKINUM(0)));
  parse_for_sym = CAR(scm_sysintern ("ctax:for", MAKINUM(0)));
  parse_return_sym = CAR(scm_sysintern ("ctax:return", MAKINUM(0)));
  parse_break_sym = CAR(scm_sysintern ("ctax:break", MAKINUM(0)));
  parse_continue_sym = CAR(scm_sysintern ("ctax:continue", MAKINUM(0)));
  parse_comma_sym = CAR(scm_sysintern ("ctax:comma", MAKINUM(0)));
  parse_do_sym = CAR(scm_sysintern ("ctax:do", MAKINUM(0)));
  parse_scheme_val_sym = CAR(scm_sysintern ("ctax:scheme-val", MAKINUM(0)));
  parse_scheme_kw_sym = CAR(scm_sysintern ("ctax:scheme-kw", MAKINUM(0)));
  parse_begin_sym = CAR(scm_sysintern ("ctax:begin", MAKINUM(0)));
  parse_neg_sym = CAR(scm_sysintern ("ctax:neg", MAKINUM(0)));
  parse_log_neg_sym = CAR(scm_sysintern ("ctax:log-neg", MAKINUM(0)));
  parse_pos_sym = CAR(scm_sysintern ("ctax:pos", MAKINUM(0)));
  parse_bit_neg_sym = CAR(scm_sysintern ("ctax:bit-neg", MAKINUM(0)));
  parse_bit_and_sym = CAR(scm_sysintern ("ctax:bit-and", MAKINUM(0)));
  parse_times_sym = CAR(scm_sysintern ("ctax:times", MAKINUM(0)));
  parse_div_sym = CAR(scm_sysintern ("ctax:div", MAKINUM(0)));
  parse_mod_sym = CAR(scm_sysintern ("ctax:mod", MAKINUM(0)));
  parse_plus_sym = CAR(scm_sysintern ("ctax:plus", MAKINUM(0)));
  parse_minus_sym = CAR(scm_sysintern ("ctax:minus", MAKINUM(0)));
  parse_lshift_sym = CAR(scm_sysintern ("ctax:lshift", MAKINUM(0)));
  parse_rshift_sym = CAR(scm_sysintern ("ctax:rshift", MAKINUM(0)));
  parse_eq_sym = CAR(scm_sysintern ("ctax:eq", MAKINUM(0)));
  parse_ne_sym = CAR(scm_sysintern ("ctax:ne", MAKINUM(0)));
  parse_le_sym = CAR(scm_sysintern ("ctax:le", MAKINUM(0)));
  parse_ge_sym = CAR(scm_sysintern ("ctax:ge", MAKINUM(0)));
  parse_lt_sym = CAR(scm_sysintern ("ctax:lt", MAKINUM(0)));
  parse_gt_sym = CAR(scm_sysintern ("ctax:gt", MAKINUM(0)));
  parse_bit_and_sym = CAR(scm_sysintern ("ctax:bit-and", MAKINUM(0)));
  parse_bit_xor_sym = CAR(scm_sysintern ("ctax:bit-xor", MAKINUM(0)));
  parse_bit_or_sym = CAR(scm_sysintern ("ctax:bit-or", MAKINUM(0)));
  parse_log_and_sym = CAR(scm_sysintern ("ctax:log-and", MAKINUM(0)));
  parse_log_or_sym = CAR(scm_sysintern ("ctax:log-or", MAKINUM(0)));
  parse_if_exp_sym = CAR(scm_sysintern ("ctax:if-exp", MAKINUM(0)));
  parse_apply_sym = CAR(scm_sysintern ("ctax:apply", MAKINUM(0)));
  parse_lambda_sym = CAR(scm_sysintern ("ctax:lambda", MAKINUM(0)));
  parse_list_sym = CAR(scm_sysintern ("ctax:list", MAKINUM(0)));
  parse_array_sym = CAR(scm_sysintern ("ctax:array", MAKINUM(0)));
  parse_bit_array_sym = CAR(scm_sysintern ("ctax:bit-array", MAKINUM(0)));
  parse_uint_array_sym = CAR(scm_sysintern ("ctax:uint-array", MAKINUM(0)));
  parse_int_array_sym = CAR(scm_sysintern ("ctax:int-array", MAKINUM(0)));
  parse_float_array_sym = CAR(scm_sysintern ("ctax:float-array", MAKINUM(0)));
  parse_double_array_sym = CAR(scm_sysintern ("ctax:double-array", MAKINUM(0)));
  parse_complex_array_sym = CAR(scm_sysintern ("ctax:complex-array", MAKINUM(0)));
  parse_field_ref_sym = CAR(scm_sysintern ("ctax:->", MAKINUM(0)));
  parse_struct_sym = CAR(scm_sysintern ("ctax:struct", MAKINUM(0)));
  parse_struct_type_sym = CAR(scm_sysintern ("ctax:struct-type", MAKINUM(0)));
  parse_make_struct_sym = CAR(scm_sysintern ("ctax:make-struct", MAKINUM(0)));
  parse_assign_sym = CAR(scm_sysintern ("ctax:assign", MAKINUM(0)));
  parse_aref_sym = CAR(scm_sysintern ("ctax:aref", MAKINUM(0)));
  parse_field_ref_col_sym = CAR (scm_sysintern ("ctax:parse_field_ref_col_sym", MAKINUM (0)));
  parse_aref_col_sym = CAR (scm_sysintern ("ctax:[]:", MAKINUM (0)));
  parse_assign_col_sym = CAR (scm_sysintern ("ctax:=:", MAKINUM (0)));
  parse_times_col_sym = CAR (scm_sysintern ("ctax:*:", MAKINUM (0)));
  parse_mod_col_sym = CAR (scm_sysintern ("ctax:%:", MAKINUM (0)));
  parse_plus_col_sym = CAR (scm_sysintern ("ctax:+:", MAKINUM (0)));
  parse_minus_col_sym = CAR (scm_sysintern ("ctax:-:", MAKINUM (0)));
  parse_lshift_col_sym = CAR (scm_sysintern ("ctax:<<:", MAKINUM (0)));
  parse_rshift_col_sym = CAR (scm_sysintern ("ctax:>>:", MAKINUM (0)));
  parse_eq_col_sym = CAR (scm_sysintern ("ctax:==:", MAKINUM (0)));
  parse_ne_col_sym = CAR (scm_sysintern ("ctax:!=:", MAKINUM (0)));
  parse_le_col_sym = CAR (scm_sysintern ("ctax:<=:", MAKINUM (0)));
  parse_ge_col_sym = CAR (scm_sysintern ("ctax:>=:", MAKINUM (0)));
  parse_lt_col_sym = CAR (scm_sysintern ("ctax:<:", MAKINUM (0)));
  parse_gt_col_sym = CAR (scm_sysintern ("ctax:>:", MAKINUM (0)));
  parse_bit_and_col_sym = CAR (scm_sysintern ("ctax:&:", MAKINUM (0)));
  parse_bit_or_col_sym = CAR (scm_sysintern ("ctax:|:", MAKINUM (0)));
  parse_log_and_col_sym = CAR (scm_sysintern ("ctax:&&:", MAKINUM (0)));
  parse_log_or_col_sym = CAR (scm_sysintern ("ctax:||:", MAKINUM (0)));
  parse_bit_neg_col_sym = CAR (scm_sysintern ("ctax:~:" , MAKINUM (0)));
  parse_log_neg_col_sym = CAR (scm_sysintern ("ctax:!:" , MAKINUM (0)));
}

int
ctyywrap ()
{
  return 1;
}

yywrap()
{
  return 0; 
}
