/* classes: h_files */

#ifndef GCH
#define GCH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"


#ifdef vms
# ifndef CHEAP_CONTINUATIONS

   typedef int jmp_buf[17];
   extern int setjump(jmp_buf env);
   extern int longjump(jmp_buf env, int ret);

#  define setjmp setjump
#  define longjmp longjump
# else
#  include <setjmp.h>
# endif
#else				/* ndef vms */
# ifdef _CRAY1
    typedef int jmp_buf[112];
    extern int setjump(jmp_buf env);
    extern int longjump(jmp_buf env, int ret);

#  define setjmp setjump
#  define longjmp longjump
# else				/* ndef _CRAY1 */
#  include <setjmp.h>
# endif				/* ndef _CRAY1 */
#endif				/* ndef vms */


/* James Clark came up with this neat one instruction fix for
   continuations on the SPARC.  It flushes the register windows so
   that all the state of the process is contained in the stack. */

#ifdef sparc
# define FLUSH_REGISTER_WINDOWS asm("ta 3")
#else
# define FLUSH_REGISTER_WINDOWS /* empty */
#endif

/* If stack is not longword aligned then */

/* #define SHORT_ALIGN */
#ifdef THINK_C
# define SHORT_ALIGN
#endif
#ifdef MSDOS
# define SHORT_ALIGN
#endif
#ifdef atarist
# define SHORT_ALIGN
#endif

/* If stacks grow up then */

/* #define STACK_GROWS_UP */
#ifdef hp9000s800
# define STACK_GROWS_UP
#endif
#ifdef pyr
# define STACK_GROWS_UP
#endif
#ifdef nosve
# define STACK_GROWS_UP
#endif
#ifdef _UNICOS
# define STACK_GROWS_UP
#endif

/* CELL_UP and CELL_DN are used by scm_init_heap_seg to find scm_cell aligned inner
   bounds for allocated storage */

#ifdef PROT386
/*in 386 protected mode we must only adjust the offset */
# define CELL_UP(p) MK_FP(FP_SEG(p), ~7&(FP_OFF(p)+7))
# define CELL_DN(p) MK_FP(FP_SEG(p), ~7&FP_OFF(p))
#else
# ifdef _UNICOS
#  define CELL_UP(p) (CELLPTR)(~1L & ((long)(p)+1L))
#  define CELL_DN(p) (CELLPTR)(~1L & (long)(p))
# else
#  define CELL_UP(p) (CELLPTR)(~(sizeof(scm_cell)-1L) & ((long)(p)+sizeof(scm_cell)-1L))
#  define CELL_DN(p) (CELLPTR)(~(sizeof(scm_cell)-1L) & (long)(p))
# endif				/* UNICOS */
#endif				/* PROT386 */


/* {heap parameters}
 * 
 * These are parameters for controlling memory allocation.  The heap
 * is the area out of which scm_cons, object headers, and large objects
 * are allocated.
 *
 * The heap consists of a number of segments.  Each segment 
 * contains objects of only one size, specified when the segment is
 * created.
 *
 * Each heap cell is 8 bytes on a 32 bit machine and 16 bytes on a
 * 64 bit machine.  The units of the _SIZE parameters are bytes.
 * Cons pairs and object headers occupy one heap cell.
 * Large objects may occupy any number of cells.
 *
 * INIT_HEAP_SIZE is the initial size of heap.  If this much heap is
 * allocated initially the heap will grow by half its current size
 * each subsequent time more heap is needed.
 *
 * If INIT_HEAP_SIZE heap cannot be allocated initially, HEAP_SEG_SIZE
 * will be used, and the heap will grow by HEAP_SEG_SIZE when more
 * heap is needed.  HEAP_SEG_SIZE must fit into type sizet.  This code
 * is in scm_init_storage() and alloc_some_heap() in sys.c
 * 
 * If INIT_HEAP_SIZE can be allocated initially, the heap will grow by
 * EXPHEAP(scm_heap_size) when more heap is needed.
 *
 * MIN_HEAP_SEG_SIZE is minimum size of heap to accept when more heap
 * is needed.
 *
 * INIT_MALLOC_LIMIT is the initial amount of malloc usage which will
 * trigger a GC. 
 */

#define INIT_HEAP_SIZE (25000L*sizeof(scm_cell))
#define MIN_HEAP_SEG_SIZE (2000L*sizeof(scm_cell))
#ifdef _QC
# define HEAP_SEG_SIZE 32400L
#else
# ifdef sequent
#  define HEAP_SEG_SIZE (7000L*sizeof(scm_cell))
# else
#  define HEAP_SEG_SIZE (8100L*sizeof(scm_cell))
# endif
#endif
#define EXPHEAP(scm_heap_size) (scm_heap_size*2)
#define INIT_MALLOC_LIMIT 100000

#ifdef SHORT_ALIGN
typedef short SCM_STACKITEM;
#else
typedef long SCM_STACKITEM;
#endif
typedef struct 
{
  jmp_buf jmpbuf;
  SCM dynenv;
  SCM_STACKITEM *base;
  unsigned long seq;
} regs;
#define JMPBUF(x) (((regs *)CHARS(x))->jmpbuf)
#define SETJMPBUF SETCDR
#define DYNENV(x) (((regs *)CHARS(x))->dynenv)
#define BASE(x) (((regs *)CHARS(x))->base)
#define SEQ(x) (((regs *)CHARS(x))->seq)

#define SCM_PTR_GT(x, y) PTR_LT(y, x)
#define SCM_PTR_LE(x, y) (!PTR_GT(x, y))
#define SCM_PTR_GE(x, y) (!PTR_LT(x, y))

struct scm_heap_seg_data
{
  SCM_CELLPTR bounds[2];	/* lower and upper */
  SCM *freelistp;		/* the value of this may be shared */
  int ncells;			/* per object in this segment */
  int (*valid) P ((SCM_CELLPTR, struct scm_heap_seg_data *));
};

extern struct scm_heap_seg_data *scm_heap_table;
extern int scm_n_heap_segs;
extern int scm_take_stdin;

extern SCM scm_sys_protects[];
extern sizet scm_num_protects;



#define scm_cur_inp scm_sys_protects[0]
#define scm_cur_outp scm_sys_protects[1]
#define scm_cur_errp scm_sys_protects[2]
#define scm_def_inp scm_sys_protects[3]
#define scm_def_outp scm_sys_protects[4]
#define scm_def_errp scm_sys_protects[5]
#define scm_listofnull scm_sys_protects[6]
#define scm_undefineds scm_sys_protects[7]
#define scm_nullvect scm_sys_protects[8]
#define scm_nullstr scm_sys_protects[9]
#define scm_symhash scm_sys_protects[10]
#define scm_progargs scm_sys_protects[11]
#define scm_transcript scm_sys_protects[12]
#define scm_rootcont scm_sys_protects[13]
#define scm_dynwinds scm_sys_protects[14]
#define scm_symhash_vars scm_sys_protects[15]
#define scm_permobjs scm_sys_protects[16]
#define scm_flo0 scm_sys_protects[17]
#define scm_kw_obarray scm_sys_protects[18]
#define scm_type_obj_list scm_sys_protects[19]
#define scm_first_type scm_sys_protects[20]
#define scm_stand_in_procs scm_sys_protects[21]
#define SCM_NUM_PROTECTS 22




extern long scm_heap_size;
extern SCM_CELLPTR scm_heap_org;
extern SCM scm_freelist;
extern long scm_gc_cells_collected;
extern long scm_gc_malloc_collected;
extern long scm_gc_ports_collected;
extern long scm_cells_allocated;
extern long scm_lcells_allocated;
extern long scm_mallocated;
extern long scm_lmallocated;
extern long scm_mtrigger;
extern SCM *scm_loc_loadpath;


#ifdef __STDC__
extern void scm_grew_lim (long nm);
extern char * scm_must_malloc (long len, char *what);
extern char * scm_must_realloc (char *where, long olen, long len, char *what);
extern void scm_must_free (char *obj);
extern void scm_permenant_object (SCM obj);
extern SCM scm_alloc_large (int ncells, char * reason);
extern void scm_gc_for_alloc (int ncells, SCM * freelistp);
extern SCM scm_alloc_obj (SCM ncells, char * reason);
extern void scm_init_io (void);
extern SCM scm_markcdr (SCM ptr);
extern SCM scm_mark0 (SCM ptr);
extern sizet scm_free0 (SCM ptr);
extern SCM scm_equal0 (SCM ptr1, SCM ptr2);
extern void scm_init_storage (SCM_STACKITEM *stack_start_ptr, long init_heap_size, FILE * in, FILE * out, FILE * err);
extern SCM * scm_mkarray (int size, int fillp);
extern void scm_free_array (SCM * elts);
extern void scm_mark_arrays (void);
extern SCM scm_gc (void);
extern void scm_remember (SCM * ptr);
extern void scm_init_gc (void);

#else /* STDC */
extern void scm_grew_lim ();
extern char * scm_must_malloc ();
extern char * scm_must_realloc ();
extern void scm_must_free ();
extern void scm_permenant_object ();
extern SCM scm_alloc_large ();
extern void scm_gc_for_alloc ();
extern SCM scm_alloc_obj ();
extern void scm_init_io ();
extern SCM scm_markcdr ();
extern SCM scm_mark0 ();
extern sizet scm_free0 ();
extern SCM scm_equal0 ();
extern void scm_init_storage ();
extern SCM * scm_mkarray ();
extern void scm_free_array ();
extern void scm_mark_arrays ();
extern SCM scm_gc ();
extern void scm_remember ();
extern void scm_init_gc ();

#endif /* STDC */


#include "marksweep.h"
#endif  /* GCH */
