/* classes: h_files */

#ifndef GSCMH
#define GSCMH

/*	Copyright (C) 1994 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*  t. lord	Mon Jan 16 15:22:28 1995	*/


#ifdef STDC_HEADERS
# include <stdlib.h>
# ifdef AMIGA
#  include <stddef.h>
# endif /* def AMIGA */
# define sizet size_t
#else
# ifdef _SIZE_T
#  define sizet size_t
# else
#  define sizet unsigned int
# endif /* def _SIZE_T */
#endif /* def STDC_HEADERS */

#include "__scm.h"
#include "error.h"
#include "boolean.h"
#include "numbers.h"
#include "chars.h"
#include "pairs.h"
#include "smob.h"
#include "symbols.h"
#include "strings.h"
#include "strop.h"
#include "kw.h"
#include "variable.h"
#include "vectors.h"
#include "record.h"
#include "unif.h"
#include "ramap.h"
#include "struct.h"
#include "procs.h"
#include "gsubr.h"
#include "ports.h"
#include "vports.h"
#include "fports.h"
#include "strports.h"
#include "eq.h"
#include "dynwind.h"
#include "continuations.h"
#include "time.h"
#include "hash.h"
#include "files.h"
#include "arbiters.h"
#include "throw.h"
#include "eval.h"
#include "feature.h"
#include "scmsigs.h"
#include "simpos.h"
#include "gc.h"
#include "stackchk.h"
#include "repl.h"

#ifndef P
#ifdef __STDC__
#define P(s) s
#else
#define P(s) ()
#endif
#endif

typedef int GSCM_top_level;
typedef int GSCM_status;

#define GSCM_OK 			0
#define GSCM_QUIT 			(GSCM_OK + 1)
#define GSCM_RESTART 			(GSCM_QUIT + 1)
#define GSCM_ILLEGALLY_REENTERED 	(GSCM_RESTART + 1)
#define GSCM_OUT_OF_MEM 		(GSCM_ILLEGALLY_REENTERED + 1)
#define GSCM_ERROR_OPENING_FILE		(GSCM_OUT_OF_MEM + 1)
#define GSCM_ERROR_OPENING_INIT_FILE	(GSCM_ERROR_OPENING_FILE + 1)

typedef int (*gscm_equal_fn) P((SCM a, SCM b));
typedef int (*gscm_print_fn) P((SCM obj, SCM port, int writingp));
typedef void (*gscm_die_fn) P((SCM obj));

struct gscm_type
{
  char * name;
  gscm_equal_fn equal;
  gscm_print_fn print;
  gscm_die_fn die;
};


#define GSCM_DEFER_INTS			SCM_DEFER_INTS
#define GSCM_ALLOW_INTS			SCM_ALLOW_INTS

#define GSCM_EOL			SCM_EOL
#define GSCM_FALSE			SCM_BOOL_F
#define GSCM_TRUE			SCM_BOOL_T


#define gscm_cons 		scm_cons
#define gscm_list 		scm_listify
#define gscm_ilength		scm_ilength
#define gscm_obj_length		scm_obj_length
#define GSCM_EOL_MARKER 	SCM_UNDEFINED
#define GSCM_NOT_PASSED	 	SCM_UNDEFINED
#define GSCM_UNSPECIFIED 	SCM_UNSPECIFIED

#define gscm_set_car(OBJ, VAL) \
   ((SCM_NIMP(OBJ) && SCM_CONSP(OBJ)) \
		   ? (SCM_CAR(OBJ) = VAL) \
		   : scm_wta ((OBJ), (char *)SCM_ARG1, "set-car!"))

#define gscm_set_cdr(OBJ, VAL) \
   ((SCM_NIMP(OBJ) && SCM_CONSP(OBJ)) \
		   ? (SCM_CDR(OBJ) = VAL) \
		   : scm_wta ((OBJ), (char *)SCM_ARG1, "set-cdr!"))


#define SCAR(X)   ((SCM_NIMP(X) && SCM_CONSP(X)) \
		   ? SCM_CAR(X) \
		   : scm_wta ((X), (char *)SCM_ARG1, "car"))

#define SCDR(X)   ((SCM_NIMP(X) && SCM_CONSP(X)) \
		   ? SCM_CDR(X) \
		   : scm_wta ((X), (char *)SCM_ARG1, "cdr"))

#define gscm_car(OBJ)		SCAR (OBJ)
#define gscm_cdr(OBJ)		SCDR (OBJ)

#define gscm_caar(OBJ)		SCAR (SCAR (OBJ))
#define gscm_cdar(OBJ)		SCDR (SCAR (OBJ))
#define gscm_cadr(OBJ)		SCAR (SCDR (OBJ))
#define gscm_cddr(OBJ)		SCDR (SCDR (OBJ))

#define gscm_caaar(OBJ)		SCAR (SCAR (SCAR (OBJ)))
#define gscm_cdaar(OBJ)		SCDR (SCAR (SCAR (OBJ)))
#define gscm_cadar(OBJ)		SCAR (SCDR (SCAR (OBJ)))
#define gscm_cddar(OBJ)		SCDR (SCDR (SCAR (OBJ)))
#define gscm_caadr(OBJ)		SCAR (SCAR (SCDR (OBJ)))
#define gscm_cdadr(OBJ)		SCDR (SCAR (SCDR (OBJ)))
#define gscm_caddr(OBJ)		SCAR (SCDR (SCDR (OBJ)))
#define gscm_cdddr(OBJ)		SCDR (SCDR (SCDR (OBJ)))

#define gscm_caaaar(OBJ)	SCAR (SCAR (SCAR (SCAR (OBJ))))
#define gscm_cdaaar(OBJ)	SCDR (SCAR (SCAR (SCAR (OBJ))))
#define gscm_cadaar(OBJ)	SCAR (SCDR (SCAR (SCAR (OBJ))))
#define gscm_cddaar(OBJ)	SCDR (SCDR (SCAR (SCAR (OBJ))))
#define gscm_caadar(OBJ)	SCAR (SCAR (SCDR (SCAR (OBJ))))
#define gscm_cdadar(OBJ)	SCDR (SCAR (SCDR (SCAR (OBJ))))
#define gscm_caddar(OBJ)	SCAR (SCDR (SCDR (SCAR (OBJ))))
#define gscm_cdddar(OBJ)	SCDR (SCDR (SCDR (SCAR (OBJ))))
#define gscm_caaadr(OBJ)	SCAR (SCAR (SCAR (SCDR (OBJ))))
#define gscm_cdaadr(OBJ)	SCDR (SCAR (SCAR (SCDR (OBJ))))
#define gscm_cadadr(OBJ)	SCAR (SCDR (SCAR (SCDR (OBJ))))
#define gscm_cddadr(OBJ)	SCDR (SCDR (SCAR (SCDR (OBJ))))
#define gscm_caaddr(OBJ)	SCAR (SCAR (SCDR (SCDR (OBJ))))
#define gscm_cdaddr(OBJ)	SCDR (SCAR (SCDR (SCDR (OBJ))))
#define gscm_cadddr(OBJ)	SCAR (SCDR (SCDR (SCDR (OBJ))))
#define gscm_cddddr(OBJ)	SCDR (SCDR (SCDR (SCDR (OBJ))))

#define gscm_ulong 		scm_ulong2num
#define gscm_long 		scm_long2num
#define gscm_double(X)		scm_makdbl ((X), 0.0)
#define gscm_char(C)		SCM_MAKICHR(C)

#define gscm_2_ulong(OBJ)	scm_num2ulong((OBJ), (char *)SCM_ARG1, "gscm_2_ulong")
#define gscm_2_long(OBJ)	scm_num2long((OBJ), (char *)SCM_ARG1, "gscm_2_long")
#define gscm_2_double(OBJ)	scm_num2dbl((OBJ), "gscm_2_double")
extern int gscm_2_char P((SCM));

#define gscm_str(SRC, LEN)	scm_makfromstr (SRC, LEN, 0)
#define gscm_str0		makfrom0str
extern void gscm_2_str P((char ** str_out, int * len_out, SCM * obj_in));

#if 0
This was a mistake.  These three gscm_ entry points should return
boolean values of type SCM, not C integers.  The "is_eq" forms
are the ones that return integers.

Here is the plan.  If your code was broken when this code was
commented out, please change your code to use gscm_is_eq*.  Then,
a future snapshot, i will add the gscm_eq* entry points back
in, but with a different return type.

Sorry for any inconvenience.

-t


#define gscm_eq(OBJ)		(SCM_BOOL_F != scm_eq (OBJ))
#define gscm_eqv(OBJ)		(SCM_BOOL_F != scm_eqv (OBJ))
#define gscm_equal(OBJ)		(SCM_BOOL_F != scm_equal (OBJ))
#endif

#define gscm_is_eq(OBJ)		(SCM_BOOL_F != scm_eq (OBJ))
#define gscm_is_eqv(OBJ)		(SCM_BOOL_F != scm_eqv (OBJ))
#define gscm_is_equal(OBJ)		(SCM_BOOL_F != scm_equal (OBJ))

#define gscm_bool(CBOOL)	((CBOOL) ? SCM_BOOL_T : SCM_BOOL_F)
#define gscm_2_bool(BOOL)	(((BOOL) == SCM_BOOL_F) ? 0 : 1)

#define gscm_symbol(STR, LEN) 	 SCM_CAR(scm_intern (STR, LEN))
#define gscm_tmp_symbol(STR, LEN) SCM_CAR(scm_intern_obarray (STR, LEN, SCM_BOOL_F))

#define gscm_vector(N, FILL)	scm_make_vector (SCM_MAKINUM(N), (FILL))
#define gscm_vref(V, I)		scm_vector_ref ((V), SCM_MAKINUM(I))
#define gscm_vset(V, I, VAL)	scm_vector_set ((V), SCM_MAKINUM(I), (VAL))

extern SCM gscm_make_subr P((SCM (*fn)(),
			     int req, int opt, int varp, char * doc));
extern SCM gscm_curry P((SCM procedure, SCM first_arg));


#define gscm_catch(T, TH, H)		scm_catch ((T), (TH), (H))
#define gscm_throw(T, V)		scm_throw_exception ((T), (V))
#define gscm_dynamic_wind(E, T, L)	scm_dynwind ((E), (T), (L))

#define gscm_apply(PROC, ARGS)		scm_apply ((PROC), (ARGS), SCM_EOL)

extern void gscm_error P((char * message, SCM args));
extern SCM gscm_alloc P((struct gscm_type *, int size));
extern char * gscm_unwrap_obj P((struct gscm_type *, SCM * obj));
extern struct gscm_type * gscm_get_type P((SCM * obj));

#define gscm_print_obj			scm_iprin1
#define gscm_putc			scm_putc
#define gscm_puts			scm_puts
#define gscm_fwrite			scm_fwrite
#define gscm_flush			scm_flush
#define gscm_mkarray(SIZE)		scm_mkarray((SIZE), 1)
#define gscm_define			scm_sysintern

extern char * gscm_last_attempted_init_file;




#ifndef GSCM_MAGIC_SNARFER
#define GSCM_PROC(RANAME, CFN, STR, REQ, OPT, VAR)  \
	static char RANAME[]=STR;
#else
#define GSCM_PROC(RANAME, CFN, STR, REQ, OPT, VAR)  \
%%% gscm_define_procedure (RANAME, CFN, REQ, OPT, VAR, "")
#endif





#ifdef __STDC__
extern long gscm_mk_objid (SCM obj);
extern SCM gscm_id2obj (long n);
extern void gscm_free_id (long n);
extern void gscm_id_reassign (long n, SCM obj);
extern SCM gscm_sys_id(SCM n);
extern SCM gscm_sys_default_verbosity (void);
extern void gscm_verbosity (int n);
extern void gscm_with_verbosity (int n, void (*fn)P((void *)), void * data);
extern void gscm_set_init_heap_size (int x);
extern int gscm_init_heap_size (void);
extern GSCM_status gscm_init_from_fn (char *initfile, int argc, char **argv, void (*init_fn) ());
extern void gscm_take_stdin (void);
extern void gscm_verbose (int n);
extern GSCM_status gscm_create_top_level (GSCM_top_level * answer);
extern GSCM_status gscm_destroy_top_level (GSCM_top_level it);
extern GSCM_status gscm_seval_str (SCM *answer, GSCM_top_level toplvl, char * str);
extern void format_load_command (char * buf, char *file_name);
extern GSCM_status gscm_seval_file (SCM *answer, GSCM_top_level toplvl, char * file_name);
extern GSCM_status gscm_eval_str (char ** answer, GSCM_top_level toplvl, char * str);
extern GSCM_status gscm_eval_file (char ** answer, GSCM_top_level toplvl, char * file_name);
extern char * gscm_error_msg (int n);
extern void gscm_define_procedure (char * name, SCM (*fn)(), int req, int opt, int varp, char * doc);
extern SCM gscm_make_subr (SCM (*fn)(), int req, int opt, int varp, char * doc);
extern SCM gscm_curry (SCM procedure, SCM first_arg);
extern int gscm_2_char (SCM c);
extern void gscm_2_str (char ** out, int * len_out, SCM * objp);
extern void gscm_error (char * message, SCM args);
extern SCM gscm_alloc (struct gscm_type * type, int size);
extern char * gscm_unwrap_obj (struct gscm_type * type, SCM * objp);
extern struct gscm_type * gscm_get_type (SCM * objp);
extern SCM gscm_procedure_properties (SCM proc);
extern SCM gscm_set_procedure_properties_x (SCM proc, SCM new);
extern SCM gscm_procedure_assoc (SCM p, SCM k);
extern SCM gscm_procedure_property (SCM p, SCM k);
extern SCM gscm_set_procedure_property_x (SCM p, SCM k, SCM v);
extern GSCM_status guile_ks (void);
extern GSCM_status gscm_run_scm (int argc, char ** argv, FILE * in, FILE * out, FILE * err, GSCM_status (*initfn)(), char * initfile, char * initcmd);
extern SCM gscm_malloc_2_uve (int type, int k, int size, char * data);
extern int gscm_is_gscm_obj (SCM obj);

#else /* STDC */
extern long gscm_mk_objid ();
extern SCM gscm_id2obj ();
extern void gscm_free_id ();
extern void gscm_id_reassign ();
extern SCM gscm_sys_id();
extern SCM gscm_sys_default_verbosity ();
extern void gscm_verbosity ();
extern void gscm_with_verbosity ();
extern void gscm_set_init_heap_size ();
extern int gscm_init_heap_size ();
extern GSCM_status gscm_init_from_fn ();
extern void gscm_take_stdin ();
extern void gscm_verbose ();
extern GSCM_status gscm_create_top_level ();
extern GSCM_status gscm_destroy_top_level ();
extern GSCM_status gscm_seval_str ();
extern void format_load_command ();
extern GSCM_status gscm_seval_file ();
extern GSCM_status gscm_eval_str ();
extern GSCM_status gscm_eval_file ();
extern char * gscm_error_msg ();
extern void gscm_define_procedure ();
extern SCM gscm_make_subr ();
extern SCM gscm_curry ();
extern int gscm_2_char ();
extern void gscm_2_str ();
extern void gscm_error ();
extern SCM gscm_alloc ();
extern char * gscm_unwrap_obj ();
extern struct gscm_type * gscm_get_type ();
extern SCM gscm_procedure_properties ();
extern SCM gscm_set_procedure_properties_x ();
extern SCM gscm_procedure_assoc ();
extern SCM gscm_procedure_property ();
extern SCM gscm_set_procedure_property_x ();
extern GSCM_status guile_ks ();
extern GSCM_status gscm_run_scm ();
extern SCM gscm_malloc_2_uve ();
extern int gscm_is_gscm_obj ();

#endif /* STDC */











#endif  /* GSCMH */
