/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include <stdio.h>
#include "_scm.h"


/* {Locked Vectors}
 */

/* Return the Nth lvector hook function or #f it 
 * was not provided. 
 */
static SCM f_lvector_ref;

#ifdef __STDC__
SCM
scm_get_lvector_hook (SCM vec, int index)
#else
SCM
scm_get_lvector_hook (vec, index)
     SCM vec;
     int index;
#endif
{
  SCM keyvec;
  SCM hooks;
  keyvec = VELTS (vec)[0];

  if (   IMP (keyvec)
      || !VECTORP (keyvec)
      || (LENGTH (keyvec) != 0))
    return BOOL_F;

  hooks = VELTS (keyvec)[0];

  if (   IMP (hooks)
      || !LVECTORP (hooks)
      || (index >= LENGTH (hooks))
      || (LVECTOR_KEY (hooks, index) != f_lvector_ref))
      return BOOL_F;

  return VELTS (hooks)[index];
}

PROC (s_lvector_isa_p, "lvector-isa?", 2, 0, 0, scm_lvector_isa_p);
#ifdef __STDC__
SCM
scm_lvector_isa_p (SCM vec, SCM keyvec)
#else
SCM
scm_lvector_isa_p (vec, keyvec)
     SCM vec;
     SCM keyvec;
#endif
{
  ASSERT (NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_isa_p);
  if (keyvec == VELTS (vec)[0])
    return BOOL_T;
  {
    SCM hook;

    hook = scm_get_lvector_hook (vec, LV_ISA_FN);
    if (hook == BOOL_F)
      return BOOL_F;
    return scm_apply (hook, scm_cons (vec, scm_cons (keyvec, EOL)), EOL);
  }
}


PROC (s_lvector_set_x, "lvector-set!", 4, 1, 0, scm_lvector_set_x);
#ifdef __STDC__
SCM
scm_lvector_set_x (SCM vec, SCM key, SCM index, SCM val, SCM rock)
#else
SCM
scm_lvector_set_x (vec, key, index, val, rock)
     SCM vec;
     SCM key;
     SCM index;
     SCM val;
     SCM rock;
#endif
{
  int i;
  ASSERT ( NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_set_x );
  ASSERT ( INUMP (index), index, ARG2, s_lvector_set_x );
  ASSERT ( INUM (index) < LENGTH (vec), index, OUTOFRANGE, s_lvector_set_x );
  i = INUM (index);

  if (key == VELTS (VELTS (vec)[0])[i])
    {
      VELTS (vec)[i] = val;
      return UNSPECIFIED;
    }
  else
  {
    SCM hook;
    hook = scm_get_lvector_hook (vec, LV_SET_FN);
    ASSERT (hook != BOOL_F,
	    key,
	    "wrong key for locked vector element:", s_lvector_set_x);
    
    return scm_apply (hook,
		      scm_listify (vec, key, index, val,
				   rock, SCM_UNDEFINED), EOL);
  }
}

PROC (s_lvector_poke_x, "lvector-poke!", 3, 0, 0, scm_lvector_poke_x);
#ifdef __STDC__
SCM
scm_lvector_poke_x (SCM vec, SCM index, SCM val)
#else
SCM
scm_lvector_poke_x (vec, index, val)
     SCM vec;
     SCM index;
     SCM val;
#endif
{
  int i;
  ASSERT ( NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_poke_x );
  ASSERT ( INUMP (index), index, ARG2, s_lvector_poke_x );
  ASSERT ( INUM (index) < LENGTH (vec), index, OUTOFRANGE, s_lvector_poke_x );
  i = INUM (index);
  VELTS (vec)[i] = val;
  return UNSPECIFIED;
}


PROC (s_lvector_ref, "lvector-ref", 3, 0, 0, scm_lvector_ref);
#ifdef __STDC__
SCM
scm_lvector_ref (SCM vec, SCM key, SCM index)
#else
SCM
scm_lvector_ref (vec, key, index)
     SCM vec;
     SCM key;
     SCM index;
#endif
{
  SCM keyvec;
  SCM answer;
  int i;
  ASSERT ( NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_ref );
  keyvec = VELTS (vec)[0];
  ASSERT ( INUMP (index), index, ARG2, s_lvector_ref );
  i = INUM (index);
  ASSERT ( INUM (index) < LENGTH (vec), index, OUTOFRANGE, s_lvector_ref );
  answer = VELTS (vec)[i];
  if (key == VELTS (keyvec)[i])
    return answer;

  {
    SCM hook;
    hook = scm_get_lvector_hook (vec, LV_REF_FN);
    ASSERT (hook != BOOL_F,
	    key,
	    "wrong key for locked vector element:", s_lvector_set_x);
    
    return scm_apply (hook,
		      scm_cons (vec, scm_cons (key, scm_cons (index, EOL))),
		      EOL);
  }
}

PROC (s_lvector_ref2, "lvector-ref2", 3, 1, 0, scm_lvector_ref2);
#ifdef __STDC__
SCM
scm_lvector_ref2 (SCM vec, SCM key, SCM index, SCM rock)
#else
SCM
scm_lvector_ref2 (vec, key, index, rock)
     SCM vec;
     SCM key;
     SCM index;
     SCM rock;
#endif
{
  SCM keyvec;
  SCM answer;
  int i;
  ASSERT ( NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_ref );
  keyvec = VELTS (vec)[0];
  ASSERT ( INUMP (index), index, ARG2, s_lvector_ref );
  i = INUM (index);
  if (i < LENGTH (vec))
   {
     answer = VELTS (vec)[i];
     if (key == VELTS (keyvec)[i])
       return answer;
   }
  {
    SCM hook;
    hook = scm_get_lvector_hook (vec, LV_REF_FN);
    ASSERT (hook != BOOL_F,
	    key,
	    "wrong key for locked vector element:", s_lvector_set_x);
    
    return scm_apply (hook,
		      scm_listify (vec, key, index, rock, SCM_UNDEFINED),
		      EOL);
  }
}


PROC (s_lvector_peek, "lvector-peek", 2, 0, 0, scm_lvector_peek);
#ifdef __STDC__
SCM
scm_lvector_peek (SCM vec, SCM index)
#else
SCM
scm_lvector_peek (vec, index)
     SCM vec;
     SCM index;
#endif
{
  SCM keyvec;
  int i;
  ASSERT ( NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_peek );
  keyvec = VELTS (vec)[0];
  ASSERT ( INUMP (index), index, ARG2, s_lvector_peek );
  i = INUM (index);
  ASSERT ( INUM (index) < LENGTH (vec), index, OUTOFRANGE, s_lvector_peek );
  return VELTS (vec)[i];
}


#define LVEC_CCL_KEY(C) (VELTS (C) [1])
#define LVEC_CCL_INDEX(C) (VELTS (C) [2])

static char s_lvector_accessor1[] = " lvector-accessor-procedure";
#ifdef __STDC__
static SCM
lvector_accessor1 (SCM ccl, SCM lvec)
#else
static SCM
lvector_accessor1 (ccl, lvec)
     SCM ccl;
     SCM lvec;
#endif
{
  ASSERT (NIMP (lvec) && LVECTORP (lvec), lvec, ARG1, s_lvector_accessor1);
  if (LVEC_CCL_KEY (ccl) == VELTS (lvec)[0])
    return VELTS (lvec) [INUM (LVEC_CCL_INDEX (ccl))];
  else
    return scm_lvector_ref (lvec,
			    LVEC_CCL_KEY (ccl),
			    INUM (LVEC_CCL_INDEX (ccl)));
}

static char s_lvector_modifier1[] = " lvector-modifier-procedure";

#ifdef __STDC__
static SCM
lvector_modifier1 (SCM ccl, SCM lvec, SCM val)
#else
static SCM
lvector_modifier1 (ccl, lvec, val)
     SCM ccl;
     SCM lvec;
     SCM val;
#endif
{
  ASSERT (NIMP (lvec) && LVECTORP (lvec), lvec, ARG1, s_lvector_modifier1);
  if (LVEC_CCL_KEY (ccl) == VELTS (lvec)[0])
    {
      VELTS (lvec) [INUM (LVEC_CCL_INDEX (ccl))] = val;
      return UNSPECIFIED;
    }
  else
    return scm_lvector_set_x (lvec,
			      LVEC_CCL_KEY (ccl), INUM (LVEC_CCL_INDEX (ccl)),
			      val, BOOL_F);
}


static SCM f_lvector_accessor1;
static SCM f_lvector_modifier1;

PROC (s_lvector_accessor, "lvector-accessor", 2, 0, 0, scm_lvector_accessor);
#ifdef __STDC__
SCM
scm_lvector_accessor (SCM type, SCM index)
#else
SCM
scm_lvector_accessor (type, index)
     SCM type;
     SCM index;
#endif
{
  SCM answer;
  ASSERT (NIMP (type) && VECTORP (type), type, ARG1, s_lvector_accessor);
  ASSERT (INUMP (index), index, ARG2, s_lvector_accessor);
  ASSERT (INUM (index) < LENGTH (type), index, OUTOFRANGE, s_lvector_accessor);
  answer = scm_makcclo (f_lvector_accessor1, 3L);
  LVEC_CCL_KEY (answer) = ((type != BOOL_F) ? type : answer);
  LVEC_CCL_INDEX (answer) = index;
  return answer;
}


PROC (s_lvector_modifier, "lvector-modifier", 2, 0, 0, scm_lvector_modifier);
#ifdef __STDC__
SCM
scm_lvector_modifier (SCM type, SCM index)
#else
SCM
scm_lvector_modifier (type, index)
     SCM type;
     SCM index;
#endif
{
  SCM answer;
  ASSERT (NIMP (type) && VECTORP (type), type, ARG1, s_lvector_modifier);
  ASSERT (INUMP (index), index, ARG2, s_lvector_modifier);
  ASSERT (INUM (index) < LENGTH (type), index, OUTOFRANGE, s_lvector_modifier);
  answer = scm_makcclo (f_lvector_modifier1, 3L);
  LVEC_CCL_KEY (answer) = ((type != BOOL_F) ? type : answer);
  LVEC_CCL_INDEX (answer) = index;
  return answer;
}


PROC (s_lock_vector_x, "lock-vector!", 1, 0, 0, scm_lock_vector_x);
#ifdef __STDC__
SCM
scm_lock_vector_x (SCM vec)
#else
SCM
scm_lock_vector_x (vec)
     SCM vec;
#endif
{
  SCM keyvec;
  ASSERT (NIMP (vec) && VECTORP (vec), vec, ARG1, s_lock_vector_x);
  ASSERT (LENGTH (vec), vec, "missing key vector as element 0", s_lock_vector_x);
  keyvec = VELTS (vec)[0];
  ASSERT (NIMP (keyvec) && VECTORP (keyvec), vec,
	  "bad key vector (element 0)", s_lock_vector_x);
  ASSERT (LENGTH (keyvec) >= LENGTH (vec), vec,
	  "key vector too short", s_lock_vector_x);
  SETLENGTH ( vec, LENGTH (vec), tc7_lvector );
  return vec;
}


PROC (s_unlock_vector_x, "unlock-vector!", 1, 0, 0, scm_unlock_vector_x);
#ifdef __STDC__
SCM
scm_unlock_vector_x (SCM vec)
#else
SCM
scm_unlock_vector_x (vec)
     SCM vec;
#endif
{
  ASSERT (NIMP (vec) && LVECTORP (vec), vec, ARG1, s_unlock_vector_x);
  SETLENGTH ( vec, LENGTH (vec), tc7_vector );
  return vec;
}


PROC (s_lvector_keys, "lvector-keys", 1, 0, 0, scm_lvector_keys);
#ifdef __STDC__
SCM
scm_lvector_keys (SCM vec)
#else
SCM
scm_lvector_keys (vec)
     SCM vec;
#endif
{
  ASSERT (NIMP (vec) && LVECTORP (vec), vec, ARG1, s_lvector_keys);
  return VELTS (vec)[0];
}


PROC (s_lvector_p, "lvector?", 1, 0, 0, scm_lvector_p);
#ifdef __STDC__
SCM
scm_lvector_p (SCM vec)
#else
SCM
scm_lvector_p (vec)
     SCM vec;
#endif
{
  return  ((NIMP (vec) && LVECTORP (vec))
	   ? BOOL_T
	   : BOOL_F);
}




#ifdef __STDC__
void
scm_init_lvectors (void)
#else
void
scm_init_lvectors ()
#endif
{
  f_lvector_accessor1 = scm_make_subr (s_lvector_accessor1,
				       tc7_subr_2,
				       lvector_accessor1);
  f_lvector_modifier1 = scm_make_subr (s_lvector_modifier1,
				       tc7_subr_3,
				       lvector_modifier1);
#include "lvectors.x"
  f_lvector_ref = CDR (scm_intern0 (s_lvector_ref));
}
