/* classes: h_files */

#ifndef NUMBERSH
#define NUMBERSH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"




/* Immediate Numbers 
 *
 * Inums are exact integer data that fits within an SCM word.
 */
#define SCM_INUMP(x)	(2 & (int)(x))
#define SCM_NINUMP(x) 	(!SCM_INUMP(x))

#ifdef __TURBOC__
/* shifts of more than one are done by a library call, single shifts are
 * performed in registers
 */
# define SCM_MAKINUM(x) ((((x)<<1)<<1)+2L)
#else
# define SCM_MAKINUM(x) (((x)<<2)+2L)
#endif /* def __TURBOC__ */


/* SRS is signed right shift */
/* Turbo C++ v1.0 has a bug with right shifts of signed longs!
 * It is believed to be fixed in Turbo C++ v1.01
 */
#if (-1==(((-1)<<2)+2)>>2) && (__TURBOC__ != 0x295)
# define SCM_SRS(x, y) ((x)>>y)
# ifdef __TURBOC__
#  define SCM_INUM(x) (((x)>>1)>>1)
# else
#  define SCM_INUM(x) SCM_SRS(x, 2)
# endif /* def __TURBOC__ */
#else
# define SCM_SRS(x, y) (((x)<0) ? ~((~(x))>>y) : (x)>>y)
# define SCM_INUM(x) SCM_SRS(x, 2)
#endif /*  (-1==(((-1)<<2)+2)>>2) && (__TURBOC__ != 0x295) */


/* A name for 0.
 */
#define SCM_INUM0 ((SCM) 2)



/* FIXABLE is non-0 if its long argument can be encoded in an INUM.
 */
#define SCM_POSFIXABLE(n) ((n) <= SCM_MOST_POSITIVE_FIXNUM)
#define SCM_NEGFIXABLE(n) ((n) >= SCM_MOST_NEGATIVE_FIXNUM)
#define SCM_UNEGFIXABLE(n) ((n) <= -SCM_MOST_NEGATIVE_FIXNUM)
#define SCM_FIXABLE(n) (SCM_POSFIXABLE(n) && SCM_NEGFIXABLE(n))

/* INTBUFLEN is the maximum number of characters neccessary for the
 * printed or scm_string representation of an exact immediate.
 */

#ifndef SCM_CHAR_BIT
# define SCM_CHAR_BIT 8
#endif /* ndef SCM_CHAR_BIT */
#ifndef SCM_LONG_BIT
# define SCM_LONG_BIT (SCM_CHAR_BIT*sizeof(long)/sizeof(char))
#endif /* ndef SCM_LONG_BIT */
#define SCM_INTBUFLEN (5+SCM_LONG_BIT)

/* FLOBUFLEN is the maximum number of characters neccessary for the
 * printed or scm_string representation of an inexact number.
 */

#ifdef FLOATS
# define SCM_FLOBUFLEN (10+2*(sizeof(double)/sizeof(char)*SCM_CHAR_BIT*3+9)/10)
#endif /* FLOATS */




/* Numbers 
 */

#ifdef FLOATS
#define SCM_INEXP(x) (SCM_TYP16(x)==scm_tc16_flo)
#define SCM_CPLXP(x) (SCM_CAR(x)==scm_tc_dblc)
#define SCM_REAL(x) (*(((scm_dbl *) (SCM2PTR(x)))->real))
#define SCM_IMAG(x) (*((double *)(CHARS(x)+sizeof(double))))
/* ((&REAL(x))[1]) */
#ifdef SINGLES
#define SCM_REALP(x) ((~REAL_PART & CAR(x))==scm_tc_flo)
#define SCM_SINGP(x) (CAR(x)==scm_tc_flo)
#define SCM_FLO(x) (((scm_flo *)(SCM2PTR(x)))->num)
#define SCM_REALPART(x) (SCM_SINGP(x)?0.0+FLO(x):SCM_REAL(x))
#else /* SINGLES */
#define SCM_REALP(x) (CAR(x)==scm_tc_dblr)
#define SCM_REALPART SCM_REAL
#endif /* SINGLES */
#endif


/* Define BIGDIG to an integer type whose size is smaller than long if
 * you want bignums.  BIGRAD is one greater than the biggest BIGDIG. 
 *
 * Define DIGSTOOBIG if the digits equivalent to a long won't fit in a long. 
 */
#ifdef BIGNUMS
# ifdef _UNICOS
#  define SCM_DIGSTOOBIG
#  if (1L << 31) <= SCM_USHRT_MAX
#   define SCM_BIGDIG unsigned short
#  else
#   define SCM_BIGDIG unsigned int
#  endif /*  (1L << 31) <= USHRT_MAX */
#  define SCM_BITSPERDIG 32
# else
#  define SCM_BIGDIG unsigned short
#  define SCM_BITSPERDIG (sizeof(SCM_BIGDIG)*SCM_CHAR_BIT)
# endif /* def _UNICOS */
# define SCM_BIGRAD (1L << SCM_BITSPERDIG)
# define SCM_DIGSPERLONG ((sizet)((sizeof(long)*SCM_CHAR_BIT+SCM_BITSPERDIG-1)/SCM_BITSPERDIG))
# define SCM_BIGUP(x) ((unsigned long)(x) << SCM_BITSPERDIG)
# define SCM_BIGDN(x) ((x) >> SCM_BITSPERDIG)
# define SCM_BIGLO(x) ((x) & (SCM_BIGRAD-1))
#endif /* def BIGNUMS */

#ifndef SCM_BIGDIG
/* Definition is not really used but helps various function
 * prototypes to compile with conditionalization.
 */
# define SCM_BIGDIG unsigned short
# define NO_BIGDIG
# ifndef FLOATS
#  define INUMS_ONLY
# endif /* ndef FLOATS */
#endif /* ndef SCM_BIGDIG */

#ifdef FLOATS
#define SCM_NUMBERP(x) (INUMP(x) || (SCM_NIMP(x) && NUMP(x)))
#else
#ifdef BIGDIG
#define SCM_NUMBERP(x) (INUMP(x) || (SCM_NIMP(x) && NUMP(x)))
#else
#define SCM_NUMBERP INUMP
#endif
#endif
#define SCM_NUMP(x) ((0xfcff & (int)CAR(x))==tc7_smob)
#define SCM_BIGP(x) (TYP16S(x)==tc16_bigpos)
#define SCM_BIGSIGN(x) (0x0100 & (int)CAR(x))
#define SCM_BDIGITS(x) ((BIGDIG *)(CDR(x)))
#define SCM_NUMDIGS(x) ((sizet)(CAR(x)>>16))
#define SCM_SETNUMDIGS(x, v, t) CAR(x) = (((v)+0L)<<16)+(t)


#ifdef FLOATS
typedef struct scm_dblproc
{
  char *scm_string;
  double (*cproc) ();
} scm_dblproc;

#ifdef SINGLES
typedef struct scm_flo
{
  SCM type;
  float num;
} scm_flo;
#endif

typedef struct scm_dbl
{
  SCM type;
  double *real;
} scm_dbl;
#endif




#ifdef __STDC__
extern SCM scm_exact_p(SCM x);
extern SCM scm_odd_p(SCM n);
extern SCM scm_even_p(SCM n);
extern SCM scm_abs(SCM x);
extern SCM scm_quotient(SCM x, SCM y);
extern SCM scm_remainder(SCM x, SCM y);
extern SCM scm_modulo(SCM x, SCM y);
extern SCM scm_gcd(SCM x, SCM y);
extern SCM scm_lcm(SCM n1, SCM n2);
extern SCM scm_logand(SCM n1, SCM n2);
extern SCM scm_logior(SCM n1, SCM n2);
extern SCM scm_logxor(SCM n1, SCM n2);
extern SCM scm_logtest(SCM n1, SCM n2);
extern SCM scm_logbit_p(SCM n1, SCM n2);
extern SCM scm_logand(SCM n1, SCM n2);
extern SCM scm_logior(SCM n1, SCM n2);
extern SCM scm_logxor(SCM n1, SCM n2);
extern SCM scm_logtest(SCM n1, SCM n2);
extern SCM scm_logbit_p(SCM n1, SCM n2);
extern SCM scm_lognot(SCM n);
extern SCM scm_integer_expt(SCM z1, SCM z2);
extern SCM scm_ash(SCM n, SCM cnt);
extern SCM scm_bit_extract(SCM n, SCM start, SCM end);
extern SCM scm_logcount (SCM n);
extern SCM scm_integer_length(SCM n);
extern SCM scm_mkbig(sizet nlen, int sign);
extern SCM scm_big2inum(SCM b, sizet l);
extern SCM scm_adjbig(SCM b, sizet nlen);
extern SCM scm_normbig(SCM b);
extern SCM scm_copybig(SCM b, int sign);
extern SCM scm_long2big(long n);
extern SCM scm_2ulong2big(unsigned long * np);
extern SCM scm_ulong2big(unsigned long n);
extern int scm_bigcomp(SCM x, SCM y);
extern void scm_longdigs(long x, SCM_BIGDIG digs[]);
extern SCM scm_addbig(SCM_BIGDIG *x, sizet nx, int xsgn, SCM bigy, int sgny);
extern SCM scm_mulbig(SCM_BIGDIG *x, sizet nx, SCM_BIGDIG *y, sizet ny, int sgn);
extern unsigned int scm_divbigdig(SCM_BIGDIG *ds, sizet h, SCM_BIGDIG div);
extern SCM scm_divbigint(SCM x, long z, int sgn, int mode);
extern SCM scm_divbigbig(SCM_BIGDIG *x, sizet nx, SCM_BIGDIG *y, sizet ny, int sgn, int modes);
extern sizet scm_iint2str(long num, int rad, char *p);
extern SCM scm_number_to_string(SCM x, SCM radix);
extern int scm_floprint(SCM sexp, SCM port, int writing);
extern int scm_bigprint(SCM exp, SCM port, int writing);
extern SCM scm_istr2int(char *str, long len, long radix);
extern SCM scm_istr2int(char *str, long len, long radix);
extern SCM scm_istr2flo(char *str, long len, long radix);
extern SCM scm_istring2number(char *str, long len, long radix);
extern SCM scm_string_to_number(SCM str, SCM radix);
extern SCM scm_makdbl (double x, double y);
extern SCM scm_bigequal(SCM x, SCM y);
extern SCM scm_floequal(SCM x, SCM y);
extern SCM scm_number_p(SCM x);
extern SCM scm_real_p(SCM x);
extern SCM scm_int_p(SCM x);
extern SCM scm_inexact_p(SCM x);
extern SCM scm_num_eq_p(SCM x, SCM y);
extern SCM scm_less_p(SCM x, SCM y);
extern SCM scm_gr_p(SCM x, SCM y);
extern SCM scm_leq_p(SCM x, SCM y);
extern SCM scm_geq_p(SCM x, SCM y);
extern SCM scm_zero_p(SCM z);
extern SCM scm_positive_p(SCM x);
extern SCM scm_negative_p(SCM x);
extern SCM scm_max(SCM x, SCM y);
extern SCM scm_min(SCM x, SCM y);
extern SCM scm_sum(SCM x, SCM y);
extern SCM scm_difference(SCM x, SCM y);
extern SCM scm_product(SCM x, SCM y);
extern double scm_num2dbl (SCM a, char * why);
extern SCM scm_fuck (SCM a);
extern SCM scm_divide(SCM x, SCM y);
extern double scm_asinh(double x);
extern double scm_acosh(double x);
extern double scm_atanh(double x);
extern double scm_truncate(double x);
extern double scm_round(double x);
extern double scm_exact_to_inexact(double z);
extern SCM scm_sys_expt(SCM z1, SCM z2);
extern SCM scm_sys_atan2(SCM z1, SCM z2);
extern SCM scm_make_rectangular(SCM z1, SCM z2);
extern SCM scm_make_polar(SCM z1, SCM z2);
extern SCM scm_realpart(SCM z);
extern SCM scm_imag_part(SCM z);
extern SCM scm_magnitude(SCM z);
extern SCM scm_angle(SCM z);
extern SCM scm_inexact_to_exact(SCM z);
extern SCM scm_trunc(SCM x);
extern SCM scm_dbl2big(double d);
extern double scm_big2dbl(SCM b);
extern SCM scm_long2num(long sl);
extern SCM scm_ulong2num(unsigned long sl);
extern long scm_num2long(SCM num, char *pos, char *s_caller);
extern long num2long(SCM num, char *pos, char *s_caller);
extern unsigned long scm_num2ulong(SCM num, char *pos, char *s_caller);
extern void scm_init_numbers (void);

#else /* STDC */
extern SCM scm_exact_p();
extern SCM scm_odd_p();
extern SCM scm_even_p();
extern SCM scm_abs();
extern SCM scm_quotient();
extern SCM scm_remainder();
extern SCM scm_modulo();
extern SCM scm_gcd();
extern SCM scm_lcm();
extern SCM scm_logand();
extern SCM scm_logior();
extern SCM scm_logxor();
extern SCM scm_logtest();
extern SCM scm_logbit_p();
extern SCM scm_logand();
extern SCM scm_logior();
extern SCM scm_logxor();
extern SCM scm_logtest();
extern SCM scm_logbit_p();
extern SCM scm_lognot();
extern SCM scm_integer_expt();
extern SCM scm_ash();
extern SCM scm_bit_extract();
extern SCM scm_logcount ();
extern SCM scm_integer_length();
extern SCM scm_mkbig();
extern SCM scm_big2inum();
extern SCM scm_adjbig();
extern SCM scm_normbig();
extern SCM scm_copybig();
extern SCM scm_long2big();
extern SCM scm_2ulong2big();
extern SCM scm_ulong2big();
extern int scm_bigcomp();
extern void scm_longdigs();
extern SCM scm_addbig();
extern SCM scm_mulbig();
extern unsigned int scm_divbigdig();
extern SCM scm_divbigint();
extern SCM scm_divbigbig();
extern sizet scm_iint2str();
extern SCM scm_number_to_string();
extern int scm_floprint();
extern int scm_bigprint();
extern SCM scm_istr2int();
extern SCM scm_istr2int();
extern SCM scm_istr2flo();
extern SCM scm_istring2number();
extern SCM scm_string_to_number();
extern SCM scm_makdbl ();
extern SCM scm_bigequal();
extern SCM scm_floequal();
extern SCM scm_number_p();
extern SCM scm_real_p();
extern SCM scm_int_p();
extern SCM scm_inexact_p();
extern SCM scm_num_eq_p();
extern SCM scm_less_p();
extern SCM scm_gr_p();
extern SCM scm_leq_p();
extern SCM scm_geq_p();
extern SCM scm_zero_p();
extern SCM scm_positive_p();
extern SCM scm_negative_p();
extern SCM scm_max();
extern SCM scm_min();
extern SCM scm_sum();
extern SCM scm_difference();
extern SCM scm_product();
extern double scm_num2dbl ();
extern SCM scm_fuck ();
extern SCM scm_divide();
extern double scm_asinh();
extern double scm_acosh();
extern double scm_atanh();
extern double scm_truncate();
extern double scm_round();
extern double scm_exact_to_inexact();
extern SCM scm_sys_expt();
extern SCM scm_sys_atan2();
extern SCM scm_make_rectangular();
extern SCM scm_make_polar();
extern SCM scm_realpart();
extern SCM scm_imag_part();
extern SCM scm_magnitude();
extern SCM scm_angle();
extern SCM scm_inexact_to_exact();
extern SCM scm_trunc();
extern SCM scm_dbl2big();
extern double scm_big2dbl();
extern SCM scm_long2num();
extern SCM scm_ulong2num();
extern long scm_num2long();
extern long num2long();
extern unsigned long scm_num2ulong();
extern void scm_init_numbers ();

#endif /* STDC */















#endif  /* NUMBERSH */
