/* classes: h_files */

#ifndef STRUCTH
#define STRUCTH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"



#define scm_struct_i_name 0
#define scm_struct_i_vcell 1
#define scm_struct_i_format (struct_i_vcell + 1)
#define scm_struct_i_refcnt (struct_i_format + 1)
#define scm_struct_i_self (struct_i_refcnt + 1)
#define scm_struct_i_sekrit (struct_i_self + 1)
#define scm_struct_i_vtab_size (struct_i_sekrit + 1)
#define scm_struct_i_vtab  (struct_i_vtab_size + 1)
#define scm_n_struct_header (struct_i_vtab + 1)

#define SCM_STRUCT_TYPE_NAME(x) (SCM_VELTS (x)[struct_i_name])
#define SCM_STRUCT_TYPE_VCELL(x) (SCM_VELTS (x)[struct_i_vcell])
#define SCM_STRUCT_TYPE_FORMAT(x) (SCM_VELTS (x)[struct_i_format])
#define SCM_STRUCT_TYPE_REFCNT(x) (SCM_VELTS (x)[struct_i_refcnt])
#define SCM_STRUCT_TYPE_SELF(x) (SCM_VELTS (x)[struct_i_self])
#define SCM_STRUCT_TYPE_SEKRIT(x) (SCM_VELTS (x)[struct_i_sekrit])
#define SCM_STRUCT_TYPE_VTAB_SIZE(x) (SCM_VELTS (x)[struct_i_vtab_size])
#define SCM_STRUCT_TYPE_VTAB(x) (&(SCM_VELTS (x)[struct_i_vtab]))
#define SCM_STRUCT_TYPEP(X) (SCM_CAR (X) == (1 + SCM_CDR (first_type)))

#define SCM_STRUCTP(X)  (SCM_TYP3(X) == scm_tc3_cons_gloc)
#define SCM_STRUCT_TYPE(X) ((SCM *)(SCM_CAR(X) - 1))


#ifdef __STDC__
extern SCM scm_sys_bottom_struct_type (void);
extern SCM scm_sys_make_struct (SCM type, SCM nelts);
extern SCM scm_sys_make_struct_type (SCM name, SCM format, SCM sekrit, SCM vtable);
extern SCM scm_sys_struct_type_name (SCM obj);
extern SCM scm_sys_struct_type_format (SCM obj);
extern SCM scm_sys_struct_type_secret_p (SCM obj, SCM guess);
extern SCM _struct_ref (SCM obj, int i, int anyp);
extern SCM scm_sys_struct_ref (SCM obj, SCM n);
extern SCM scm_sys_struct_checked_ref (SCM obj, SCM n, SCM secret);
extern SCM scm_sys_vtab_ref (SCM obj, SCM n);
extern SCM scm_sys_struct_set_x (SCM obj, SCM n, SCM val);
extern SCM scm_sys_struct_checked_set_x (SCM obj, SCM n, SCM val, SCM secret);
extern SCM scm_sys_struct_p(SCM obj);
extern SCM scm_sys_struct_type_p(SCM obj);
extern SCM scm_sys_struct_type (SCM obj);
extern void scm_init_struct (void);

#else /* STDC */
extern SCM scm_sys_bottom_struct_type ();
extern SCM scm_sys_make_struct ();
extern SCM scm_sys_make_struct_type ();
extern SCM scm_sys_struct_type_name ();
extern SCM scm_sys_struct_type_format ();
extern SCM scm_sys_struct_type_secret_p ();
extern SCM _struct_ref ();
extern SCM scm_sys_struct_ref ();
extern SCM scm_sys_struct_checked_ref ();
extern SCM scm_sys_vtab_ref ();
extern SCM scm_sys_struct_set_x ();
extern SCM scm_sys_struct_checked_set_x ();
extern SCM scm_sys_struct_p();
extern SCM scm_sys_struct_type_p();
extern SCM scm_sys_struct_type ();
extern void scm_init_struct ();

#endif /* STDC */







#endif  /* STRUCTH */
