// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Example/test code using Inti::Gtk::Adjustment
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <inti/gtk/adjustment.h>
#include <inti/gtk/gtkbase.h>
#include <inti/ptr.h>
#include <vector>
#include <string>
#include <iostream>

using namespace Inti;

class MyAdj : public Gtk::Adjustment
{
public:
  MyAdj ();
  
protected:
  virtual void destroy_impl ()
  {
    cout << "destroyed!" << endl;
    // destroy implementations must always chain up!
    Adjustment::destroy_impl ();
  }

  virtual void changed_impl ()
  {
    cout << "changed implementation" << endl;
  }

  virtual void value_changed_impl ()
  {
    cout << "value changed implementation" << endl;
  }
};

MyAdj::MyAdj ()
  : Gtk::Adjustment (0.0, 100.0, 10.0, 40.0, 10.0)
{
  
}


class AdjListener
{
public:
  void adjustment_changed ();

  void adjustment_value_changed ();

};

void
AdjListener::adjustment_changed ()
{
  cout << "Adjustment changed signal handler" << endl;
}

void
AdjListener::adjustment_value_changed ()
{
  cout << "Adjustment value changed signal handler" << endl;
}

int
main (int argc, char **argv)
{
  using namespace Gtk;
  
  init (&argc, &argv);

  ptr<MyAdj> adj (new MyAdj);
  Adjustment::ptr a (0.0, 100.0, 10.0, 40.0, 10.0);
  Adjustment::ptr (new Adjustment);
  
  AdjListener al;
  
  Connection c =
    adj->sig_value_changed ().connect ( slot (&al,
                                              &AdjListener::adjustment_value_changed) );
  
  adj->sig_value_changed ().connect ( slot (&al,
                                            &AdjListener::adjustment_value_changed) );
  
  adj->set_value (1.0);
  adj->set_value (3.0);
  
  // try out disconnection
  c.disconnect ();
  adj->set_value (10.0);
  
  return 0;
}

