// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Typing game example
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef BADGUY_H
#define BADGUY_H

#include <inti/gdk/gdkbase.h>
#include <inti/gtk/widget.h>

using namespace Inti;

class Game;

class Badguy
{
public:
  virtual ~Badguy ();

  const Gdk::Rectangle & extents () const { return extents_; }
  
  // inflict damage; typing a character may damage
  // a Badguy.
  virtual void damage (const string & str) = 0; 

  // Update our state, considering that msecs_elapsed have passed
  // since the last update. Called before render()
  virtual void update (long msecs_elapsed) = 0;
  
  virtual void render (Gtk::Widget * widget,
                       Gdk::Drawable * drawable,
                       const Gdk::Rectangle & clip) = 0;
  
  Game * game () { return game_; }
  const Game * game () const { return game_; }
  
protected:
  Badguy (Game * game);

  void set_extents (const Gdk::Rectangle & rect);
  
private:
  Game * game_;
  Gdk::Rectangle extents_;

  Badguy (const Badguy &);
  Badguy & operator= (const Badguy &);
};

enum BadguyType
{
  BADGUY_EASY,
  BADGUY_SCARY
};

Badguy * create_badguy (Game * game, BadguyType type);

#endif

