// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "cursor.h"
#include "bitmap.h"
#include "color.h"

Inti::Gdk::Cursor::Cursor (Type t)
  : type_(t), cursor_(0)
{
  bool need_pixmap = false;
  GdkCursorType gdk_type = GDK_LEFT_PTR;
    
  switch (type_)
    {
    case RIGHT_ARROW:
      gdk_type = GDK_RIGHT_PTR;
      break;

    case INVISIBLE:
      need_pixmap = true;
      break;

    case CROSSHAIR:
      gdk_type = GDK_CROSSHAIR;
      break;

    case IBEAM:
      gdk_type = GDK_XTERM;
      break;

    case BUSY:
      gdk_type = GDK_WATCH;
      break;

    case MOVE:
      gdk_type = GDK_FLEUR;
      break;

    case HAND:
      gdk_type = GDK_HAND2;
      break;
        
    case RESIZE_LEFT:
      gdk_type = GDK_LEFT_SIDE;
      break;

    case RESIZE_RIGHT:
      gdk_type = GDK_RIGHT_SIDE;
      break;

    case RESIZE_NW:
      gdk_type = GDK_TOP_LEFT_CORNER;
      break;

    case RESIZE_NE:
      gdk_type = GDK_TOP_RIGHT_CORNER;
      break;

    case RESIZE_SW:
      gdk_type = GDK_BOTTOM_LEFT_CORNER;
      break;

    case RESIZE_SE:
      gdk_type = GDK_BOTTOM_RIGHT_CORNER;
      break;

    case RESIZE_TOP:
      gdk_type = GDK_TOP_SIDE;
      break;

    case RESIZE_BOTTOM:
      gdk_type = GDK_BOTTOM_SIDE;
      break;

        
    case RESIZE_VERTICAL_SPLIT:
      gdk_type = GDK_SB_H_DOUBLE_ARROW;
      break;

    case RESIZE_HORIZONTAL_SPLIT:
      gdk_type = GDK_SB_V_DOUBLE_ARROW;
      break;

    case CUSTOM: // fall through to STANDARD
    case STANDARD_ARROW: // fall thru
    default:
      // leave it as GDK_LEFT_PTR
      break;
    }

  if (!need_pixmap)
    cursor_ = gdk_cursor_new (gdk_type);
  else
    {
      GdkPixmap * pixmap;
      GdkBitmap * mask;

      switch (type_)
        {
        case INVISIBLE:
          
          break;

        default:
          g_assert_not_reached ();
          break;
        }
    }
}

Inti::Gdk::Cursor::Cursor (const Pixmap * pixmap,
                              const Bitmap * mask,
                              const Color & foreground,
                              const Color & background,
                              int hotspot_x,
                              int hotspot_y)
  : type_(CUSTOM)
{
  cursor_ = gdk_cursor_new_from_pixmap (pixmap ? pixmap->gdk_pixmap () : 0,
                                        mask ? mask->gdk_bitmap () : 0,
                                        foreground.gdk_color (),
                                        background.gdk_color (),
                                        hotspot_x,
                                        hotspot_y);
}

Inti::Gdk::Cursor::Cursor (GdkCursorType gdk_type)
  : type_(CUSTOM)
{
  cursor_ = gdk_cursor_new (gdk_type);
}

Inti::Gdk::Cursor::Cursor (const Cursor& src)
{
  type_ = src.type_;
  
  if (src.cursor_)
    gdk_cursor_ref (src.cursor_);

  cursor_ = src.cursor_;
}

Inti::Gdk::Cursor&
Inti::Gdk::Cursor::operator=(const Cursor& src)
{
  if (cursor_ == src.cursor_)
    return *this;
  else
    {
      type_ = src.type_;
  
      if (src.cursor_)
        gdk_cursor_ref (src.cursor_);

      if (cursor_)
        gdk_cursor_unref (cursor_);

      cursor_ = src.cursor_;

      return *this;
    }
}

Inti::Gdk::Cursor::~Cursor ()
{
  if (cursor_)
    gdk_cursor_unref (cursor_);
}







/////////// Everything below here is machine-generated
