// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_DND_H_
#define _INTI_GDK_DND_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkdnd.h>
#include <vector>
#include <inti/gdk/gdkbase.h>
#include <inti/object.h>

namespace Inti
{  
  namespace Gdk
  {
    namespace Private
    {
      class DragContextClass;
    };

    class Window;    
    
    class DragContext : public Object
    {
    public:
      
      GdkDragContext * gdk_drag_context () const { return (GdkDragContext*)g_object (); }

      DragProtocol protocol () const;
      Window * source_window () const;
      Window * dest_window () const;
      vector<Atom> targets () const;
      DragActionField actions () const;
      DragAction suggested_action () const;
      DragAction action () const;
      guint32 start_time () const;

      void status (DragAction action, guint32 time);
      
    protected:
      virtual ~DragContext ();
      DragContext (GdkDragContext * src, GdkDragContextClass * orig);
      
    private:
      DragContext (const DragContext&);
      DragContext& operator=(const DragContext&);

      friend class Private::DragContextClass;      
      
    }; // class DragContext
    
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_DND_H_
