// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "event.h"
#include "window.h"
#include <gdk/gdk.h>

// These should probably be in GDK eventually
static void
gdk_event_copy_construct (GdkEvent *new_event, GdkEvent *event)
{
  g_return_if_fail (new_event != NULL);
  g_return_if_fail (event != NULL);
  
  *new_event = *event;
  gdk_window_ref (event->any.window);
  
  switch (event->any.type)
    {
    case GDK_KEY_PRESS:
    case GDK_KEY_RELEASE:
      new_event->key.string = g_strdup (event->key.string);
      break;
      
    case GDK_ENTER_NOTIFY:
    case GDK_LEAVE_NOTIFY:
      if (event->crossing.subwindow != NULL)
	gdk_window_ref (event->crossing.subwindow);
      break;
      
    case GDK_DRAG_ENTER:
    case GDK_DRAG_LEAVE:
    case GDK_DRAG_MOTION:
    case GDK_DRAG_STATUS:
    case GDK_DROP_START:
    case GDK_DROP_FINISHED:
      gdk_drag_context_ref (event->dnd.context);
      break;
      
    default:
      break;
    }
}

static void
gdk_event_free_fields (GdkEvent * event)
{
  g_return_if_fail (event != NULL);
  
  if (event->any.window)
    gdk_window_unref (event->any.window);
  
  switch (event->any.type)
    {
    case GDK_KEY_PRESS:
    case GDK_KEY_RELEASE:
      g_free (event->key.string);
      break;
      
    case GDK_ENTER_NOTIFY:
    case GDK_LEAVE_NOTIFY:
      if (event->crossing.subwindow != NULL)
	gdk_window_unref (event->crossing.subwindow);
      break;
      
    case GDK_DRAG_ENTER:
    case GDK_DRAG_LEAVE:
    case GDK_DRAG_MOTION:
    case GDK_DRAG_STATUS:
    case GDK_DROP_START:
    case GDK_DROP_FINISHED:
      gdk_drag_context_unref (event->dnd.context);
      break;
      
    default:
      break;
    }
}

static void
gdk_event_assign (GdkEvent * dest, GdkEvent * src)
{
  g_return_if_fail (src != NULL);

  if (dest == src)
    return;
  
  gdk_window_ref (src->any.window);
  gdk_window_unref (dest->any.window);
  
  switch (src->any.type)
    {
    case GDK_KEY_PRESS:
    case GDK_KEY_RELEASE:
      if (dest->key.string != src->key.string)
        g_free (dest->key.string);

      *dest = *src;

      if (dest->key.string != src->key.string)
        dest->key.string = g_strdup (src->key.string);
      break;
      
    case GDK_ENTER_NOTIFY:
    case GDK_LEAVE_NOTIFY:
      if (src->crossing.subwindow != NULL)
	gdk_window_ref (src->crossing.subwindow);
      *dest = *src;
      break;
      
    case GDK_DRAG_ENTER:
    case GDK_DRAG_LEAVE:
    case GDK_DRAG_MOTION:
    case GDK_DRAG_STATUS:
    case GDK_DROP_START:
    case GDK_DROP_FINISHED:
      gdk_drag_context_ref (src->dnd.context);
      *dest = *src;
      break;
      
    default:
      *dest = *src;
      break;
    }
}

Inti::Gdk::Event::Event (const Event & src)
{
  gdk_event_copy_construct ((GdkEvent*)this,
                            (GdkEvent*)&src);

}

Inti::Gdk::Event::Event (GdkEvent * src)
{
  gdk_event_copy_construct ((GdkEvent*)this,
                            src);
}

Inti::Gdk::Event::~Event ()
{
  gdk_event_free_fields ((GdkEvent*)this);
}

Inti::Gdk::Event&
Inti::Gdk::Event::operator= (const Event & src)
{
  gdk_event_assign ((GdkEvent*)this,
                    (GdkEvent*)&src);

  return *this;
}

Inti::Gdk::Window *
Inti::Gdk::Event::window () const
{
  return dynamic_cast<Window*>
    (Object::_private_wrap ((GObject *)Base::event.any.window, false));
}

Inti::Gdk::Window *
Inti::Gdk::Event::crossing_subwindow () const
{
  return dynamic_cast<Window*>
    (Object::_private_wrap ((GObject*)Base::event.crossing.subwindow, false));
}

Inti::Gdk::Event *
Inti::Gdk::event_peek ()
{
  GdkEvent * gdk_event;

  gdk_event = gdk_event_peek ();

  if (gdk_event == 0)
    return 0;
  else
    {
      Event * e = new Event (gdk_event);
      gdk_event_free (gdk_event);
      return e;
    }
}

void
Inti::Gdk::event_put (const Event & event)
{
  gdk_event_put ((GdkEvent*)&event);
}

Inti::Gdk::Event *
Inti::Gdk::get_graphics_expose (Window * win)
{
  GdkEvent * gdk_event;

  g_return_val_if_fail (win != 0, 0);
  
  gdk_event = gdk_event_get_graphics_expose (win->gdk_window ());

  if (gdk_event == 0)
    return 0;
  else
    {
      Event * e = new Event (gdk_event);
      gdk_event_free (gdk_event);
      return e;
    }
}

/////////// Everything below here is machine-generated
