// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_GDKBASE_H_
#define _INTI_GDK_GDKBASE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdk.h>
#include <inti/utf-string.h>

/*$ doc header
  $short Gdk functions and enumerations not associated with a particular class
  or module
  $*/

namespace Inti
{  
  namespace Gdk
  {
    typedef enum
    {
      LSB_FIRST = GDK_LSB_FIRST,
      MSB_FIRST = GDK_MSB_FIRST
    } ByteOrder;
    typedef enum
    {
      SOURCE_MOUSE = GDK_SOURCE_MOUSE,
      SOURCE_PEN = GDK_SOURCE_PEN,
      SOURCE_ERASER = GDK_SOURCE_ERASER,
      SOURCE_CURSOR = GDK_SOURCE_CURSOR
    } InputSource;
    typedef enum
    {
      EXTENSION_EVENTS_NONE = GDK_EXTENSION_EVENTS_NONE,
      EXTENSION_EVENTS_ALL = GDK_EXTENSION_EVENTS_ALL,
      EXTENSION_EVENTS_CURSOR = GDK_EXTENSION_EVENTS_CURSOR
    } ExtensionMode;
    typedef unsigned int ExtensionModeField;

    typedef enum
    {
      EXPOSURE_MASK = GDK_EXPOSURE_MASK,
      POINTER_MOTION_MASK = GDK_POINTER_MOTION_MASK,
      POINTER_MOTION_HINT_MASK = GDK_POINTER_MOTION_HINT_MASK,
      BUTTON_MOTION_MASK = GDK_BUTTON_MOTION_MASK,
      BUTTON1_MOTION_MASK = GDK_BUTTON1_MOTION_MASK,
      BUTTON2_MOTION_MASK = GDK_BUTTON2_MOTION_MASK,
      BUTTON3_MOTION_MASK = GDK_BUTTON3_MOTION_MASK,
      BUTTON_PRESS_MASK = GDK_BUTTON_PRESS_MASK,
      BUTTON_RELEASE_MASK = GDK_BUTTON_RELEASE_MASK,
      KEY_PRESS_MASK = GDK_KEY_PRESS_MASK,
      KEY_RELEASE_MASK = GDK_KEY_RELEASE_MASK,
      ENTER_NOTIFY_MASK = GDK_ENTER_NOTIFY_MASK,
      LEAVE_NOTIFY_MASK = GDK_LEAVE_NOTIFY_MASK,
      FOCUS_CHANGE_MASK = GDK_FOCUS_CHANGE_MASK,
      STRUCTURE_MASK = GDK_STRUCTURE_MASK,
      PROPERTY_CHANGE_MASK = GDK_PROPERTY_CHANGE_MASK,
      VISIBILITY_NOTIFY_MASK = GDK_VISIBILITY_NOTIFY_MASK,
      PROXIMITY_IN_MASK = GDK_PROXIMITY_IN_MASK,
      PROXIMITY_OUT_MASK = GDK_PROXIMITY_OUT_MASK,
      SUBSTRUCTURE_MASK = GDK_SUBSTRUCTURE_MASK,
      SCROLL_MASK = GDK_SCROLL_MASK,
      ALL_EVENTS_MASK = GDK_ALL_EVENTS_MASK
    } EventMask;
    typedef unsigned int EventMaskField;

    typedef enum
    {
      SHIFT_MASK = GDK_SHIFT_MASK,
      LOCK_MASK = GDK_LOCK_MASK,
      CONTROL_MASK = GDK_CONTROL_MASK,
      MOD1_MASK = GDK_MOD1_MASK,
      MOD2_MASK = GDK_MOD2_MASK,
      MOD3_MASK = GDK_MOD3_MASK,
      MOD4_MASK = GDK_MOD4_MASK,
      MOD5_MASK = GDK_MOD5_MASK,
      BUTTON1_MASK = GDK_BUTTON1_MASK,
      BUTTON2_MASK = GDK_BUTTON2_MASK,
      BUTTON3_MASK = GDK_BUTTON3_MASK,
      BUTTON4_MASK = GDK_BUTTON4_MASK,
      BUTTON5_MASK = GDK_BUTTON5_MASK,
      RELEASE_MASK = GDK_RELEASE_MASK,
      MODIFIER_MASK = GDK_MODIFIER_MASK
    } ModifierType;
    typedef unsigned int ModifierTypeField;

    typedef unsigned int DragActionField;
    typedef enum
    {
      ACTION_DEFAULT = GDK_ACTION_DEFAULT,
      ACTION_COPY = GDK_ACTION_COPY,
      ACTION_MOVE = GDK_ACTION_MOVE,
      ACTION_LINK = GDK_ACTION_LINK,
      ACTION_PRIVATE = GDK_ACTION_PRIVATE,
      ACTION_ASK = GDK_ACTION_ASK
    } DragAction;
    typedef enum
    {
      DRAG_PROTO_MOTIF = GDK_DRAG_PROTO_MOTIF,
      DRAG_PROTO_XDND = GDK_DRAG_PROTO_XDND,
      DRAG_PROTO_ROOTWIN = GDK_DRAG_PROTO_ROOTWIN,
      DRAG_PROTO_NONE = GDK_DRAG_PROTO_NONE,
      DRAG_PROTO_WIN32_DROPFILES = GDK_DRAG_PROTO_WIN32_DROPFILES,
      DRAG_PROTO_OLE2 = GDK_DRAG_PROTO_OLE2
    } DragProtocol;

    typedef enum
    {
      SELECTION_PRIMARY = GDK_SELECTION_PRIMARY,
      SELECTION_SECONDARY = GDK_SELECTION_SECONDARY
    } Selection;
    
    typedef GdkAtom Atom;
    
    inline guint32 current_time () { return GDK_CURRENT_TIME; }
    Atom atom_intern (const string & atom_name,
                      bool only_if_exists = false);
    Atom atom_intern (const char * atom_name,
                      bool only_if_exists = false);
    
    class Point;
    class Cursor;
    class Window;
    
    class Rectangle : private GdkRectangle
    {
    private:
      typedef GdkRectangle Base;
    public:
      Rectangle ();
      Rectangle (int x, int y, int width, int height);
      
      static inline Rectangle * wrap (GdkRectangle * src) { return (Rectangle*) src; }
      
      // using default destructor
      // using default copy constructor and assignment
      
      int x () const { return Base::x; }
      int y () const { return Base::y; }
      int width () const { return Base::width; }
      int height () const { return Base::height; }

      void set_x (int x) { Base::x = x; }
      void set_y (int y) { Base::y = y; }
      void set_width (int w) { Base::width = w; }
      void set_height (int h) { Base::height = h; }

      void set (int x, int y, int width, int height);

      void set_position (int x, int y);
      void set_position (const Point & point);

      void set_size (int width, int height);

      void translate (int x_delta, int y_delta);
      
      bool intersects (const Rectangle & rect) const;
      
      bool intersection_with (const Rectangle & rect);
      void union_with (const Rectangle & rect);

      bool operator== (const Rectangle & rhs) const;
      bool operator!= (const Rectangle & rhs) const;
      
      GdkRectangle * gdk_rectangle () const
      {
        return (GdkRectangle*) this;
      }
    }; // class Rectangle

    class Point : private GdkPoint
    {
    private:
      typedef GdkPoint Base;
    public:
      Point ();
      Point (int x, int y);
      
      static inline Point * wrap (GdkPoint * src) { return (Point*) src; }
      
      // using default destructor
      // using default copy constructor and assignment
      
      int x () const { return Base::x; }
      int y () const { return Base::y; }

      void set_x (int x) { Base::x = x; }
      void set_y (int y) { Base::y = y; }

      void set (int x, int y);

      bool operator== (const Point & rhs) const;
      bool operator!= (const Point & rhs) const;
      
      GdkPoint * gdk_point () const
      {
        return (GdkPoint*) this;
      }
    }; // class Point

    class Segment : private GdkSegment
    {
    private:
      typedef GdkSegment Base;
    public:
      Segment ();
      Segment (int x1, int y1, int x2, int y2);
      Segment (const Point & point1, const Point & point2);
      
      // using default destructor
      // using default copy/assignment

      int x1 () const { return Base::x1; }
      int y1 () const { return Base::y1; }
      int x2 () const { return Base::x2; }
      int y2 () const { return Base::y2; }
      
      void set_start (int x, int y);
      void set_start (const Point & point);
      void set_end (int x, int y);
      void set_end (const Point & point);

      void set (int x1, int y1, int x2, int y2);
      void set (const Point & point1, const Point & point2);
      
      bool operator== (const Segment & rhs) const;
      bool operator!= (const Segment & rhs) const;
      
      GdkSegment * gdk_segment () const
      {
        return (GdkSegment*) this;
      }
    }; // class Segment

    void beep ();

    bool init (int * argc, char *** argv, bool fatal_errors=true);

    namespace Private
    {
      void internal_init ();
    };
    
    void set_sm_client_id (const string & str);
    void set_sm_client_id (const char * str);

    ustring set_locale ();

    void error_trap_push ();
    int error_trap_pop ();
    void set_use_xshm (bool setting);
    bool use_xshm ();
    ustring display ();

    bool pointer_grab (Window * window,
                       bool owner_events,
                       EventMaskField event_mask,
                       Window * confine_to,
                       const Cursor & cursor,
                       guint32 time);

    void pointer_ungrab (guint32 time);

    bool keyboard_grab (Window * window,
                        bool owner_events,
                        guint32 time);

    void keyboard_ungrab (guint32 time);

    bool pointer_grabbed ();

    int screen_width ();
    int screen_height ();
    int screen_width_mm ();
    int screen_height_mm ();
    
    void flush ();

    void key_repeat_disable ();
    void key_repeat_restore ();

    // Didn't wrap send_clientmessage

    ustring keyval_name (unsigned int keyval);
    unsigned int keyval_from_name (const string & name);
    unsigned int keyval_from_name (const char * name);
    void keyval_convert_case (unsigned int keyval,
                              unsigned int * upper,
                              unsigned int * lower);
    unsigned int keyval_to_upper (unsigned int keyval);
    unsigned int keyval_to_lower (unsigned int keyval);
    bool keyval_is_upper (unsigned int keyval);
    bool keyval_is_lower (unsigned int keyval);

    // FIXME thread locks
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_GDKBASE_H_
