// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_PIXMAP_H_
#define _INTI_GDK_PIXMAP_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/drawable.h>
#include <gdk/gdkpixmap.h>

namespace Inti
{  
  namespace Gdk
  {
    namespace Private
    {
      class PixmapClass;
    }; // namespace Private

    class Pixmap : public Drawable
    {
    public:
      GdkPixmap * gdk_pixmap () const
      {
        return (GdkPixmap*)gdk_drawable ();
      }

      Pixmap (int width,
              int height,
              int depth);
      
    protected:
      friend class Private::PixmapClass;
      explicit Pixmap (GdkPixmapObject * src, GdkPixmapObjectClass * orig_class);

      virtual ~Pixmap ();
      
    private:
      Pixmap (const Pixmap&);
      Pixmap& operator=(const Pixmap&);

    };

  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_PIXMAP_H_
