// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_VISUAL_H_
#define _INTI_GDK_VISUAL_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/gdkbase.h>
#include <gdk/gdkvisual.h>
#include <vector>

/*$ doc header
  $short The #Inti::Gdk::Visual class (describes the pixel format of a #Inti::Gdk::Drawable)
  $*/

namespace Inti
{  
  namespace Gdk
  {
    class Visual : private GdkVisual
    {
    private:
      typedef GdkVisual Base;
      
    public:
      GdkVisual * gdk_visual () const
      {
        return (GdkVisual*)this;
      }

      static inline const Visual * wrap (GdkVisual * gdk_visual)
      {
        return (const Visual*) gdk_visual;
      }
      
      typedef enum
      {
        STATIC_GRAY = GDK_VISUAL_STATIC_GRAY,
        GRAYSCALE = GDK_VISUAL_GRAYSCALE,
        STATIC_COLOR = GDK_VISUAL_STATIC_COLOR,
        PSEUDO_COLOR = GDK_VISUAL_PSEUDO_COLOR,
        TRUE_COLOR = GDK_VISUAL_TRUE_COLOR,
        DIRECT_COLOR = GDK_VISUAL_DIRECT_COLOR
      } Type;

      Type type () const
      {
        return (Type) Base::type;
      }

      int depth () const
      {
        return Base::depth;
      }

      ByteOrder byte_order () const
      {
        return (ByteOrder) Base::byte_order;
      }

      int colormap_size () const
      {
        return Base::colormap_size;
      }

      int bits_per_rgb () const
      {
        return Base::bits_per_rgb;
      }

      guint32 red_mask () const
      {
        return Base::red_mask;
      }

      int red_shift () const
      {
        return Base::red_shift;
      }

      int red_prec () const
      {
        return Base::red_prec;
      }

      guint32 green_mask () const
      {
        return Base::green_mask;
      }

      int green_shift () const
      {
        return Base::green_shift;
      }

      int green_prec () const
      {
        return Base::green_prec;
      }
      
      guint32 blue_mask () const
      {
        return Base::blue_mask;
      }

      int blue_shift () const
      {
        return Base::blue_shift;
      }

      int blue_prec () const
      {
        return Base::blue_prec;
      }

      static int best_depth ();
      static Type best_type ();
      static const Visual * system ();
      static const Visual * best ();
      static const Visual * best_with_depth (int depth);
      static const Visual * best_with_type (Type t);
      static const Visual * best_with_both (int depth, Type t);

      static vector<const Visual*> list ();
      static vector<int> list_depths ();
      static vector<Type> list_types ();
      
    protected:
      
    private:
      friend class ICanCallThePrivateConstructorToAvoidCompilerWarnings;
      Visual (); // makes no sense
      Visual (const Visual&);
      Visual& operator=(const Visual&);
      ~Visual ();
      
    }; // class Visual

  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_VISUAL_H_
