// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "adjustment.h"
#include "adjustment-class.h"
#include <inti/private-util.h>
#include "marshal.h"
#include <inti/proxies.h>

Inti::Gtk::Adjustment::Adjustment (float lower, float upper,
                                      float step_increment,
                                      float page_increment,
                                      float page_size)
  : Object (Private::AdjustmentClass::make_proxy(),
            Private::AdjustmentClass::original_class ())
{
  if (!GTK_OBJECT_CONSTRUCTED (g_object ()))
    gtk_object_default_construct (GTK_OBJECT (g_object ()));
  
  set_range (lower, upper, step_increment,
             page_size, page_size);
}

Inti::Gtk::Adjustment::Adjustment ()
  : Object (Private::AdjustmentClass::make_proxy (),
            Private::AdjustmentClass::original_class ())
{
  if (!GTK_OBJECT_CONSTRUCTED (g_object ()))
    gtk_object_default_construct (GTK_OBJECT (g_object ()));
  
}

Inti::Gtk::Adjustment::Adjustment (GtkAdjustment *obj,
                                      GtkAdjustmentClass * orig)
  : Object ((GObject*)obj,
            (GObjectClass*)orig)
{
  if (!GTK_OBJECT_CONSTRUCTED (g_object ()))
    gtk_object_default_construct (GTK_OBJECT (g_object ()));
}

Inti::Gtk::Adjustment::~Adjustment ()
{

}

void
Inti::Gtk::Adjustment::sink_impl ()
{
  gtk_object_sink (GTK_OBJECT (g_object ()));
}

bool
Inti::Gtk::Adjustment::floating () const
{
  return GTK_OBJECT_FLOATING (g_object ());
}

void
Inti::Gtk::Adjustment::adjustment_changed_proxy (GtkAdjustment *obj)
{
  Inti::Private::proxy_implementation_0 (obj,
                                            &Adjustment::changed_impl,
                                            &Adjustment::on_changed);
}

void
Inti::Gtk::Adjustment::adjustment_value_changed_proxy (GtkAdjustment *obj)
{
  Inti::Private::proxy_implementation_0 (obj,
                                            &Adjustment::value_changed_impl,
                                            &Adjustment::on_value_changed);
}

void
Inti::Gtk::Adjustment::changed_impl ()
{
  GtkAdjustmentClass * orig =
    (GtkAdjustmentClass *) original_class ();

  if (orig->changed)
    (* orig->changed) (gtk_adjustment ());
}

void
Inti::Gtk::Adjustment::value_changed_impl ()
{
  GtkAdjustmentClass * orig =
    (GtkAdjustmentClass *) original_class ();

  if (orig->value_changed)
    (* orig->value_changed) (gtk_adjustment ());
}

void
Inti::Gtk::Adjustment::on_changed ()
{
  // nothing
}

void
Inti::Gtk::Adjustment::on_value_changed ()
{
  // nothing
}

void
Inti::Gtk::Adjustment::set_range (float lower, float upper,
                                     float step_increment,
                                     float page_increment,
                                     float page_size)
{
  GtkAdjustment * adj = gtk_adjustment ();

  adj->lower = MIN (lower, upper);
  adj->upper = MAX (lower, upper);
  // Clamp various increments and sizes to be no larger
  // than the range it's possible to move.
  float range = adj->upper - adj->lower;
  adj->step_increment = MIN (range, step_increment);
  adj->page_increment = MIN (range, page_increment);
  adj->page_size      = MIN (range, page_size);

  // Make sure the value is clamped
  set_value (CLAMP (value (), this->lower (), this->upper ()));

  gtk_adjustment_changed (adj);
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Adjustment::set_value (float value)
{
   gtk_adjustment_set_value (gtk_adjustment (), value);
}
void
Inti::Gtk::Adjustment::clamp_page (float lower, float upper)
{
   gtk_adjustment_clamp_page (gtk_adjustment (), lower, upper);
}
const Inti::Gtk::Adjustment::ValueChangedSignalType
Inti::Gtk::Adjustment::value_changed_signal ("value_changed", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Adjustment::ChangedSignalType
Inti::Gtk::Adjustment::changed_signal ("changed", (Private::SignalFunc)Private::slot0_void_callback);

