// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_ADJUSTMENT_H_
#define _INTI_GTK_ADJUSTMENT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <inti/gtk/gtk-signals.h>
#include <gtk/gtkadjustment.h>

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class AdjustmentClass;
    };

    class Adjustment : public Object
    {
    public:
      /*$ doc class Adjustment
        $short represents a floating point value with constraints
        on its range

        $copy none
        $memory floating

        $long

        <para>
        Represents a value; the value can only be changed
        within a certain range. See set_range() for details on the range,
        and set_value() for details on the value.
        An #Adjustment is used by #Scrollbar, #SpinButton, and other
        widgets that move a value within a limited range.
        #Adjustment emits a \\value_changed signal when the
        value is altered, allowing widgets to update their display.
        </para>

        <para>
        If you're familiar with the Model-View-Controller (MVC) design
        pattern, you can think of an #Adjustment as the "model" for
        #Scrollbar and #SpinButton. (If you don't know what MVC means,
        don't worry about it.)
        </para>

        $*/

      GtkAdjustment * gtk_adjustment () const
      {
        return (GtkAdjustment*)g_object ();
      }

      /*$ doc constructor
        $short Construct an adjustment with all values set to 0.0
        $long

        <para>
        This constructor creates an adjustment with its lower, upper,
        step_increment, page_increment, and page_size values set to 0.0.
        You should call set_range () immediately; set_value () will
        have no effect until you call set_range (), because values
        are clamped to fit inside the range.
        </para>

        $*/
      Adjustment ();

      /*$ doc constructor
        $short Construct an adjustment with range values
        @lower lower bound
        @upper upper bound
        @step_increment small step
        @page_increment larger step
        @page_size size of visible area
        $long

        <para>
        This constructor calls set_range() for you; see the
        documentation for set_range() for details.
        </para>

        $*/
      Adjustment (float lower, float upper,
                  float step_increment,
                  float page_increment,
                  float page_size);

      /*$ doc method set_value
        $short Set the current value of the adjustment
        @value the new value
        $long

        <para>
        Set the current value of the adjustment.
        If the value is outside the
        bounds of the adjustment (see set_range()),
        the value will be clamped to fit within the bounds.
        If the new value is different from the previous
        value, a \\value_changed signal is emitted.
        </para>

        $*/

      void set_value (float value);

      /*$ doc method set_range
        $short Set the current value of the adjustment
        @lower lower bound of the range
        @upper upper bound of the range
        @step_increment small step distance
        @page_increment large step distance
        @page_size size of visible range (only makes
        sense for some applications, such as scrollbars)
        $long

        <para>
        Sets up the attributes of the range of numbers the
        adjustment represents.
        The @lower and @upper values are the minimum and maximum
        values the adjustment can be set to (see set_value()).
        The @step_increment and @page_increment are used by
        widgets that allow the user to step or page,
        such as #SpinButton and #Scrollbar. The @step_increment might
        be the height of a single line of text, for example,
        if you're implementing a text widget, and the @page_increment might
        be the number of lines on the screen minus one.
        #Scrollbar uses the @page_size to determine how large to
        make the drag slider; @page_size should be the size of the
        range that's currently visible onscreen. #SpinButton does not
        use @page_size for anything.
        </para>

        <para>
        A \\changed signal is emitted after setting the new values.
        </para>

        $*/

      void set_range (float lower, float upper,
                      float step_increment,
                      float page_increment,
                      float page_size);

      /*$ doc method value
        $short Get the current value of the adjustment
        $long

        <para>
        See set_value() and set_range() for more details.
        </para>
        $*/

      float value () const { return gtk_adjustment ()->value; }

      /*$ doc method lower
        $short Get the lower bound of the adjustment
        $long

        <para>
        See set_range() for more details.
        </para>
        $*/

      float lower () const { return gtk_adjustment ()->lower; }

      /*$ doc method upper
        $short Get the upper bound of the adjustment
        $long

        <para>
        See set_range() for more details.
        </para>
        $*/

      float upper () const { return gtk_adjustment ()->upper; }

      /*$ doc method step_increment
        $short Get the step increment of the adjustment
        $long

        <para>
        See set_range() for more details.
        </para>
        $*/

      float step_increment () const { return gtk_adjustment ()->step_increment; }

      /*$ doc method page_increment
        $short Get the page increment of the adjustment
        $long

        <para>
        See set_range() for more details.
        </para>
        $*/

      float page_increment () const { return gtk_adjustment ()->page_increment; }

      /*$ doc method page_size
        $short Get the page size of the adjustment
        $long

        <para>
        See set_range() for more details.
        </para>
        $*/

      float page_size () const { return gtk_adjustment ()->page_size; }

      /*$ doc method clamp_page
        $short Assuming the adjustment is used by a #Scrollbar, move
        a given area onscreen

        @lower lower bound of range to move onscreen
        @upper upper bound of range to move onscreen

        $long

        <para>
        Sets the value of the adjustment in such a way that the
        range from @lower to @upper is visible onscreen, if you're
        using the #Adjustment with a #Scrollbar.  If the value is
        changed, the \\value_changed signal will be emitted.
        </para>

        $*/

      void clamp_page (float lower, float upper);

    protected:
      typedef WrapSignal0<void> ValueChangedSignalType;
      static const ValueChangedSignalType value_changed_signal;

    public:
      typedef SignalProxy<Object,ValueChangedSignalType> ValueChangedProxyType;
      const ValueChangedProxyType sig_value_changed ()
      {
        return ValueChangedProxyType (this, &value_changed_signal);
      }
    protected:
      typedef WrapSignal0<void> ChangedSignalType;
      static const ChangedSignalType changed_signal;

    public:
      typedef SignalProxy<Object,ChangedSignalType> ChangedProxyType;
      const ChangedProxyType sig_changed ()
      {
        return ChangedProxyType (this, &changed_signal);
      }

    protected:
      friend class Private::AdjustmentClass;

      explicit Adjustment (GtkAdjustment *src,
                           GtkAdjustmentClass * orig);
      virtual ~Adjustment ();

      virtual void changed_impl ();
      virtual void value_changed_impl ();

      virtual void on_changed ();
      virtual void on_value_changed ();

    private:
      Adjustment(const Adjustment&);
      Adjustment& operator=(const Adjustment&);

      virtual void sink_impl ();
      virtual bool floating () const;
      
      static void adjustment_changed_proxy (GtkAdjustment *obj);
      static void adjustment_value_changed_proxy (GtkAdjustment *obj);

    }; // class Adjustment

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_ADJUSTMENT_H_
