// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_CHECKBUTTON_H_
#define _INTI_GTK_CHECKBUTTON_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/togglebutton.h>
#include <gtk/gtkcheckbutton.h>

/*$ doc header
  $short The #Inti::Gtk::CheckButton widget
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class CheckButtonClass;
    };
    
    class CheckButton : public ToggleButton
    {
    public:
      /*$ doc class CheckButton
        $short widget for labelling a UI element, such as a #Button or a #Frame

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkCheckButton * gtk_check_button () const
      {
        return (GtkCheckButton*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new check button
        $long

        <para>

        </para>
        
        $*/
      CheckButton ();

      /*$ doc constructor
        $short Construct a new #CheckButton containing a #Label with the given @text
        @text text the label should display
        $long

        <para>

        </para>
        
        $*/
      CheckButton (const string & text);
      CheckButton (const char * text);
      
      
    protected:
      friend class Private::CheckButtonClass;
      
      explicit CheckButton (GtkCheckButton *src, GtkCheckButtonClass* orig);
      virtual ~CheckButton ();
      
    private:
      CheckButton(const CheckButton&);
      CheckButton& operator=(const CheckButton&);
      
    }; // class CheckButton

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_CHECKBUTTON_H_
