// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "container.h"
#include "container-class.h"
#include "adjustment.h"
#include "gtkbase.h"
#include "marshal.h"
#include <inti/private-util.h>

/////////// Object

Inti::Gtk::Container::Container ()
  : Widget ((GtkWidget*)Private::ContainerClass::make_proxy(),
            (GtkWidgetClass*)Private::ContainerClass::original_class())
{

}

Inti::Gtk::Container::Container (GtkContainer *obj,
                                    GtkContainerClass *orig)
  : Widget ((GtkWidget*)obj,
            (GtkWidgetClass*)orig)
{

}

Inti::Gtk::Container::~Container ()
{

}

void
Inti::Gtk::Container::for_each (Slot1<void,Widget*> * slot)
{
  slot->ref ();
  slot->sink ();

  gtk_container_foreach (gtk_container (),
                         for_all_callback_proxy,
                         (void*) slot);

  slot->unref ();
}

bool
Inti::Gtk::Container::focus (DirectionType direction)
{
  return gtk_container_focus (gtk_container (), (GtkDirectionType) direction);
}

vector<Inti::Gtk::Widget*>
Inti::Gtk::Container::children () const
{
  GList * children;
  GList * iter;
  vector<Widget*> retval;

  children = gtk_container_children (gtk_container ());

  iter = children;
  while (iter != 0)
    {
      Widget * child = dynamic_cast<Widget*>(Object::wrap ((GObject*)iter->data));
      retval.push_back (child);

      iter = g_list_next (iter);
    }

  g_list_free (children);

  return retval;
}

void
Inti::Gtk::Container::for_all_callback_proxy (GtkWidget * child,
                                                 gpointer user_data)
{
  Slot * s_ = static_cast<Slot*>(user_data);
  Slot1<void,Widget *> * s = dynamic_cast<Slot1<void,Widget*> *> (s_);
  Widget * w = dynamic_cast<Widget*>(Object::wrap ((GObject*)child));

  s->invoke (w);
}

void
Inti::Gtk::Container::for_all_proxy (GtkContainer * container,
                                        gboolean include_internals,
                                        GtkCallback callback,
                                        gpointer user_data)
{
  const Slot1<void,Widget *> * s = get_forall_passthru_slot (callback, user_data);

  Container * c = dynamic_cast<Container*>(Object::wrap((GObject*)container));

  c->for_all_impl (include_internals, s);
}

class Inti::Gtk::Container::ForallSlot
  : public Inti::Slot1<void,Inti::Gtk::Widget*>
{
public:
  void invoke (Inti::Gtk::Widget * w) const
  {
    (* callback_) (w->gtk_widget (), user_data_);
  }

  GtkCallback callback_;
  gpointer user_data_;
};

void
Inti::Gtk::Container::for_all_impl (bool include_internals,
                                       const Slot1<void,Widget*> * slot)
{
  GtkContainerClass * orig =
    (GtkContainerClass *) original_class();

  if (orig->forall)
    {
      const ForallSlot * fs = dynamic_cast<const ForallSlot*>(slot);
      if (fs != 0)
        {
          (* orig->forall) (gtk_container (),
                            include_internals,
                            fs->callback_,
                            fs->user_data_);
        }
      else
        {
          (* orig->forall) (gtk_container (),
                            include_internals,
                            for_all_callback_proxy,
                            (void*)slot);
        }
    }
}

Inti::Gtk::Container::ForallSlot *
Inti::Gtk::Container::forall_passthru_slot = 0;

Inti::Slot1<void,Inti::Gtk::Widget*> *
Inti::Gtk::Container::get_forall_passthru_slot (GtkCallback callback,
                                                   gpointer user_data)
{
  if (callback == for_all_callback_proxy)
    {
      Slot * s_ = static_cast<Slot*>(user_data);
      Slot1<void,Widget *> * s = dynamic_cast<Slot1<void,Widget*> *> (s_);
      return s;
    }
  else
    {
      if (forall_passthru_slot == 0)
        {
          forall_passthru_slot = new ForallSlot;
          forall_passthru_slot->ref ();
          forall_passthru_slot->sink ();
        }

      forall_passthru_slot->callback_ = callback;
      forall_passthru_slot->user_data_ = user_data;

      return forall_passthru_slot;
    }
}


gint
Inti::Gtk::Container::focus_proxy (GtkContainer * container,
                                      GtkDirectionType direction)
{
  Container * c = dynamic_cast<Container*>(Object::wrap((GObject*)container));

  return c->focus_impl ((DirectionType) direction);
}

bool
Inti::Gtk::Container::focus_impl (DirectionType direction)
{
  GtkContainerClass * orig =
    (GtkContainerClass *) original_class();

  if (orig->focus)
    return (* orig->focus) (gtk_container (), (GtkDirectionType) direction);
  else
    return false;
}



void
Inti::Gtk::Container::add_proxy (GtkContainer * container,
                                    GtkWidget * child)
{
  Container * c = dynamic_cast<Container*>(Object::wrap((GObject*)container));
  Widget * w = dynamic_cast<Widget*>(Object::wrap((GObject*)child));

  c->add_impl (w);
  c->on_add (w);
}

void
Inti::Gtk::Container::remove_proxy (GtkContainer * container,
                                       GtkWidget * child)
{
  Container * c = dynamic_cast<Container*>(Object::wrap((GObject*)container));
  Widget * w = dynamic_cast<Widget*>(Object::wrap((GObject*)child));

  c->remove_impl (w);
  c->on_remove (w);
}

void
Inti::Gtk::Container::add_impl (Widget * child)
{
  GtkContainerClass * orig =
    (GtkContainerClass *) original_class();

  if (orig->add)
    return (* orig->add) (gtk_container (), child->gtk_widget ());
}

void
Inti::Gtk::Container::remove_impl (Widget * child)
{
  GtkContainerClass * orig =
    (GtkContainerClass *) original_class();

  if (orig->remove)
    return (* orig->remove) (gtk_container (), child->gtk_widget ());
}

void
Inti::Gtk::Container::on_add (Widget * child)
{
  // nothing
}

void
Inti::Gtk::Container::on_remove (Widget * child)
{
  // nothing
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Container::add (Inti::Gtk::Widget* widget)
{
   gtk_container_add (gtk_container (), widget->gtk_widget ());
}
void
Inti::Gtk::Container::remove (Inti::Gtk::Widget* widget)
{
   gtk_container_remove (gtk_container (), widget->gtk_widget ());
}
const Inti::Gtk::Container::AddSignalType
Inti::Gtk::Container::add_signal ("add", (Private::SignalFunc)Private::slot1_void_widget_callback);

const Inti::Gtk::Container::RemoveSignalType
Inti::Gtk::Container::remove_signal ("remove", (Private::SignalFunc)Private::slot1_void_widget_callback);

void
Inti::Gtk::Container::set_border_width (unsigned int border_width)
{
   gtk_container_set_border_width (gtk_container (), border_width);
}
void
Inti::Gtk::Container::set_reallocate_redraws (bool needs_redraws)
{
   gtk_container_set_reallocate_redraws (gtk_container (), needs_redraws);
}
void
Inti::Gtk::Container::set_focus_child (Inti::Gtk::Widget* child)
{
   gtk_container_set_focus_child (gtk_container (), child->gtk_widget ());
}
void
Inti::Gtk::Container::set_focus_vadjustment (Inti::Gtk::Adjustment* adjustment)
{
   gtk_container_set_focus_vadjustment (gtk_container (), adjustment->gtk_adjustment ());
}
void
Inti::Gtk::Container::set_focus_hadjustment (Inti::Gtk::Adjustment* adjustment)
{
   gtk_container_set_focus_hadjustment (gtk_container (), adjustment->gtk_adjustment ());
}
void
Inti::Gtk::Container::resize_children ()
{
   gtk_container_resize_children (gtk_container ());
}
