// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_CONTAINER_H_
#define _INTI_GTK_CONTAINER_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkcontainer.h>
#include <vector>

/*$ doc header
  $short The #Inti::Gtk::Container abstract base class
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class ContainerClass;
    };

    class Adjustment;

    class Container : public Widget
    {
    public:
      /*$ doc class Container
        $short abstract base class for widgets that contain child widgets

        $copy none
        $memory floating

        $long

        <para>

        Container widgets are the glue that holds a GTK user interface
        together. They are simply widgets that contain
        sub-widgets. For example, a #Button may contain a
        #Label. Containers can be broadly divided into two classes:
        <firstterm>decorator</firstterm> containers such as #Button or
        #Frame add some functionality or visual effect, and invisible
        <firstterm>layout</firstterm> containers such as #HBox or
        #Table that coordinate the size and position of their child
        widgets.

        </para>

        <para>

        </para>

        $*/

      GtkContainer * gtk_container () const
      {
        return (GtkContainer*)g_object ();
      }

      void add (Inti::Gtk::Widget* widget);
      void remove (Inti::Gtk::Widget* widget);

    protected:
      typedef WrapSignal1<void,Widget * > AddSignalType;
      static const AddSignalType add_signal;

    public:
      typedef SignalProxy<Object,AddSignalType> AddProxyType;
      const AddProxyType sig_add ()
      {
        return AddProxyType (this, &add_signal);
      }
    protected:
      typedef WrapSignal1<void,Widget * > RemoveSignalType;
      static const RemoveSignalType remove_signal;

    public:
      typedef SignalProxy<Object,RemoveSignalType> RemoveProxyType;
      const RemoveProxyType sig_remove ()
      {
        return RemoveProxyType (this, &remove_signal);
      }

      void for_each (Slot1<void,Widget*> * slot);

      bool focus (DirectionType direction);

      // FIXME do we want to wrap set_focus_child ?

      int border_width () const { return gtk_container ()->border_width; }
      void set_border_width (unsigned int border_width);

      vector<Widget*> children () const;

    protected:
      friend class Private::ContainerClass;

      explicit Container (GtkContainer *src, GtkContainerClass* orig);
      virtual ~Container () = 0; // abstract base class


      /*$ doc constructor
        $short Construct a new container
        $long

        <para>

        </para>

        $*/
      Container ();

      void set_reallocate_redraws (bool needs_redraws);
      void set_focus_child (Inti::Gtk::Widget* child);
      void set_focus_vadjustment (Inti::Gtk::Adjustment* adjustment);
      void set_focus_hadjustment (Inti::Gtk::Adjustment* adjustment);
      void resize_children ();

      // non-signal virtual functions
      virtual void for_all_impl (bool include_internals,
                               const Slot1<void,Widget*> * slot);

      virtual bool focus_impl (DirectionType direction);

      // Signals
      virtual void add_impl (Widget * child);
      virtual void remove_impl (Widget * child);

      virtual void on_add (Widget * child);
      virtual void on_remove (Widget * child);

    private:
      Container(const Container&);
      Container& operator=(const Container&);

      static void for_all_callback_proxy (GtkWidget * child,
                                          gpointer user_data);

      class ForallSlot;
      static ForallSlot * forall_passthru_slot;
      static Slot1<void,Widget*> * get_forall_passthru_slot (GtkCallback callback,
                                                             gpointer user_data);

      static void for_all_proxy (GtkContainer * container,
                                 gboolean include_internals,
                                 GtkCallback callback,
                                 gpointer user_data);

      static gint focus_proxy (GtkContainer * container,
                               GtkDirectionType direction);


      static void add_proxy (GtkContainer * container, GtkWidget * child);
      static void remove_proxy (GtkContainer * container, GtkWidget * child);

    }; // class Container

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_CONTAINER_H_
