// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_ITEM_H_
#define _INTI_GTK_ITEM_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/bin.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkitem.h>

/*$ doc header
  $short FIXME
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class ItemClass;
    };
    
    class Item : public Bin
    {
    public:
      /*$ doc class Item
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkItem * gtk_item () const
      {
        return (GtkItem*)g_object ();
      }

    protected:
      typedef WrapSignal0<void> SelectSignalType;
      static const SelectSignalType select_signal;

    public:
      typedef SignalProxy<Object,SelectSignalType> SelectProxyType;
      const SelectProxyType sig_select ()
      {
        return SelectProxyType (this, &select_signal);
      }
    protected:
      typedef WrapSignal0<void> DeselectSignalType;
      static const DeselectSignalType deselect_signal;

    public:
      typedef SignalProxy<Object,DeselectSignalType> DeselectProxyType;
      const DeselectProxyType sig_deselect ()
      {
        return DeselectProxyType (this, &deselect_signal);
      }
    protected:
      typedef WrapSignal0<void> ToggleSignalType;
      static const ToggleSignalType toggle_signal;

    public:
      typedef SignalProxy<Object,ToggleSignalType> ToggleProxyType;
      const ToggleProxyType sig_toggle ()
      {
        return ToggleProxyType (this, &toggle_signal);
      }

      void select ();
      void deselect ();
      void toggle ();
      
    protected:
      friend class Private::ItemClass;
      
      explicit Item (GtkItem *src, GtkItemClass *orig);
      virtual ~Item () = 0; // abstract
      Item ();

      virtual void select_impl ();
      virtual void deselect_impl ();
      virtual void toggle_impl ();

      virtual void on_select ();
      virtual void on_deselect ();
      virtual void on_toggle ();
      
    private:
      Item(const Item&);
      Item& operator=(const Item&);

      static void select_proxy (GtkItem * item);
      static void deselect_proxy (GtkItem * item);
      static void toggle_proxy (GtkItem * item);
      
    }; // class Item

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_ITEM_H_
