// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "optionmenu.h"
#include "optionmenu-class.h"
#include "menu.h"
#include "menuitem.h"
#include <inti/private-util.h>

Inti::Gtk::OptionMenu::OptionMenu ()
  : Button ((GtkButton*)Private::OptionMenuClass::make_proxy (),
            (GtkButtonClass*) Private::OptionMenuClass::original_class ())
{

}

Inti::Gtk::OptionMenu::OptionMenu (Menu * menu)
  : Button ((GtkButton*)Private::OptionMenuClass::make_proxy (),
            (GtkButtonClass*) Private::OptionMenuClass::original_class ())
{
  set_menu (menu);
}

Inti::Gtk::OptionMenu::OptionMenu (GtkOptionMenu *obj, GtkOptionMenuClass * orig)
  : Button ((GtkButton*)obj,
            (GtkButtonClass*)orig)
{
  
}

Inti::Gtk::OptionMenu::~OptionMenu ()
{

}

Inti::Gtk::Menu *
Inti::Gtk::OptionMenu::menu () const
{
  GtkWidget * w;

  w = gtk_option_menu_get_menu (gtk_option_menu ());

  return dynamic_cast<Menu*>(Object::wrap ((GObject*)w));
}

void
Inti::Gtk::OptionMenu::set_menu (Menu * menu)
{
  gtk_option_menu_set_menu (gtk_option_menu (),
                            menu ? menu->gtk_widget () : 0);
}

void
Inti::Gtk::OptionMenu::remove_menu ()
{
  gtk_option_menu_remove_menu (gtk_option_menu ());
}

int
Inti::Gtk::OptionMenu::history () const
{
  return gtk_option_menu_get_history (gtk_option_menu ());
}

void
Inti::Gtk::OptionMenu::set_history (int history)
{
  return gtk_option_menu_set_history (gtk_option_menu (),
                                      history);
}

Inti::Gtk::MenuItem *
Inti::Gtk::OptionMenu::active () const
{
  if (menu () == 0)
    return 0;
  
  GtkWidget * w = gtk_menu_get_active (menu ()->gtk_menu ());

  return dynamic_cast<MenuItem*>(Object::wrap ((GObject*)w));
}

void
Inti::Gtk::OptionMenu::set_active (MenuItem * menu_item)
{
  Menu * m = menu ();
  if (m == 0)
    {
      g_warning ("No menu in the option menu, can't call %s", __FUNCTION__);
      return;
    }

  g_return_if_fail (menu_item != 0);
  
  GList * children;
  children = m->gtk_menu_shell ()->children;

  int i = 0;
  while (children)
    {
      GtkMenuItem * child;
      
      child = (GtkMenuItem*) children->data;
      
      if (GTK_BIN (child)->child) // if not a separator
        {
          if (child == menu_item->gtk_menu_item ())
            {
              set_history (i);
              return;
            }
            
          ++i;
        }

      children = children->next;
    }

  g_warning ("MenuItem not found in option menu; %s failed", __FUNCTION__);
}



/////////// Everything below here is machine-generated
