// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_RC_H_
#define _INTI_GTK_RC_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <gtk/gtkrc.h>
#include <inti/gtk/gtkbase.h>
#include <inti/utf-string.h>

namespace Inti
{
  namespace Pango
  {
    class FontDescription;
  };
  
  namespace Gdk
  {
    class Color;
    class GC;
    class Window;
    class Pixmap;
    class Drawable;
    class Rectangle;
    class Point;
  }; // namespace Gdk
  
  namespace Gtk
  {
    namespace Private
    {
      class RcStyleClass;
    }; // namespace Private
    
    class RcStyle : public Object
    {
    public:

      GtkRcStyle * gtk_rc_style () const
      {
        return (GtkRcStyle*)g_object ();
      }

      RcStyle ();

      ustring name () const;
      void set_name (const string & name);
      void set_name (const char * name);

      bool name_set () const;
      void unset_name ();

      ustring bg_pixmap_name (StateType state) const;
      void set_bg_pixmap_name (StateType state,
                               const string & name);
      void set_bg_pixmap_name (StateType state,
                               const char * name);

      bool bg_pixmap_set (StateType state) const;
      void unset_bg_pixmap (StateType state);
      
      const Pango::FontDescription & font_description () const;
      void set_font_description (const Pango::FontDescription & desc);

      bool font_description_set () const;
      void unset_font_description ();

      const Gdk::Color & fg (StateType state) const;
      const Gdk::Color & bg (StateType state) const;
      const Gdk::Color & text (StateType state) const;
      const Gdk::Color & base (StateType state) const;
      void set_fg (StateType state, const Gdk::Color & color);
      void set_bg (StateType state, const Gdk::Color & color);
      void set_text (StateType state, const Gdk::Color & color);
      void set_base (StateType state, const Gdk::Color & color);

      bool fg_set (StateType state) const;
      bool bg_set (StateType state) const;
      bool text_set (StateType state) const;
      bool base_set (StateType state) const;

      void unset_fg (StateType state);
      void unset_bg (StateType state);
      void unset_text (StateType state);
      void unset_base (StateType state);
      
    protected:
      friend class Private::RcStyleClass;
      
      RcStyle (GtkRcStyle *src,
               GtkRcStyleClass * orig);
      virtual ~RcStyle ();
      
    private:
      RcStyle(const RcStyle&);
      RcStyle& operator=(const RcStyle&);

      mutable Pango::FontDescription * font_desc_;

    }; // class Style

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_RC_H_
