// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_SELECTION_H_
#define _INTI_GTK_SELECTION_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkwidget.h>
#include <gtk/gtkselection.h>
#include <gtk/gtkdnd.h>
#include <inti/gdk/gdkbase.h>
#include <string>

namespace Inti
{  
  namespace Gtk
  {
    class DragTargetEntry;
    
    typedef enum
    {
      TARGET_SAME_APP = GTK_TARGET_SAME_APP,
      TARGET_SAME_WIDGET = GTK_TARGET_SAME_WIDGET
    } TargetFlags;
    typedef unsigned int TargetFlagsField;
    
    class TargetEntry
    {
    public:
      TargetEntry (const string & target,
                   unsigned int info);

      TargetEntry (const char * target,
                   unsigned int info);

      // default copy/assignment used.
      
      unsigned int info () const;
      const string & target () const; 

      void set_info (unsigned int info);
      void set_target (const string & target);
      void set_target (const char * target);

      GtkTargetEntry * gtk_target_entry () const;
      
    private:

      friend class DragTargetEntry;
      
      string target_;
      GtkTargetEntry entry_;
    };

    class DragTargetEntry : public TargetEntry
    {
    public:
      DragTargetEntry (const string & target,
                       unsigned int info,
                       TargetFlagsField flags);

      DragTargetEntry (const char * target,
                       unsigned int info,
                       TargetFlagsField flags);

      TargetFlagsField flags () const;
      void set_flags (TargetFlagsField flags);

    };
    
    class SelectionData : private GtkSelectionData
    {
    private:
      typedef GtkSelectionData Base;
    public:
      Gdk::Atom selection () const { return Base::selection; }
      Gdk::Atom target () const { return Base::target; }
      Gdk::Atom type () const { return Base::type; }
      int format () const { return Base::format; }
      int length () const { return Base::length; }
      const void * data () const { return (const void*)Base::data; }

      bool valid () const;
      
      void set (Gdk::Atom type,
                int format, 
                const void * data,
                int data_length_in_bytes);

      GtkSelectionData * gtk_selection_data () const
      {
        return (GtkSelectionData*) this;
      }
      
    private:
      friend class GeeLookICanCallThePrivateConstructor;

      // copying is forbidden, as is default construction
      SelectionData ();
      SelectionData (const SelectionData&);
      SelectionData& operator=(const SelectionData&);
      
    }; // class SelectionData

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_SELECTION_H_
