// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "style.h"
#include "style-class.h"
#include "widget.h"
#include <inti/private-util.h>
#include <inti/gdk/color.h>
#include <inti/gdk/gc.h>
#include <inti/gdk/pixmap.h>
#include <inti/gdk/window.h>
#include <inti/pango/font.h>

Inti::Gtk::Style::Style ()
  : Object (Private::StyleClass::make_proxy (),
            Private::StyleClass::original_class ())
{
  
}

Inti::Gtk::Style::Style (GtkStyle *obj,
                            GtkStyleClass * orig)
  : Object ((GObject*)obj,
            (GObjectClass*)orig)
{

}

Inti::Gtk::Style::~Style ()
{

}

Inti::Gtk::Style *
Inti::Gtk::Style::copy () const
{
  return copy_impl ();
}

const Inti::Gdk::Color &
Inti::Gtk::Style::fg (StateType state) const
{
  return get_color (gtk_style ()->fg, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::bg (StateType state) const
{
  return get_color (gtk_style ()->bg, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::light (StateType state) const
{
  return get_color (gtk_style ()->light, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::dark (StateType state) const
{
  return get_color (gtk_style ()->dark, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::mid (StateType state) const
{
  return get_color (gtk_style ()->mid, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::text (StateType state) const
{
  return get_color (gtk_style ()->text, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::base (StateType state) const
{
  return get_color (gtk_style ()->base, state);
}

const Inti::Gdk::Color &
Inti::Gtk::Style::black () const
{
  return * (Gdk::Color*) &gtk_style ()->black;
}

const Inti::Gdk::Color &
Inti::Gtk::Style::white () const
{
  return * (Gdk::Color*) &gtk_style ()->white;
}

const Inti::Gdk::Color &
Inti::Gtk::Style::get_color (GdkColor * array, StateType state) const
{
  return ((Gdk::Color*) array)[int (state)];
}

static void
delete_font_desc (gpointer data)
{
  Inti::Pango::FontDescription * desc =
    static_cast<Inti::Pango::FontDescription*>(data);

  delete desc;
}

static GQuark font_desc_quark = 0;

const Inti::Pango::FontDescription &
Inti::Gtk::Style::font_description () const
{
  if (font_desc_quark == 0)
    font_desc_quark = g_quark_from_static_string ("__inti_font_desc_quark");

  Pango::FontDescription * old_desc =
    static_cast<Pango::FontDescription*> (g_object_get_qdata (g_object (),
                                                              font_desc_quark));
                                          
  if (old_desc)
    {
      * old_desc = Pango::FontDescription (gtk_style ()->font_desc);

      return *old_desc;
    }
  else
    {
      Pango::FontDescription * desc =
        new Pango::FontDescription (gtk_style ()->font_desc);

      g_object_set_qdata_full (g_object (),
                               font_desc_quark,
                               (void*)desc,
                               delete_font_desc);

      return *desc;
    }
}

void
Inti::Gtk::Style::set_font_description (const Pango::FontDescription & desc)
{
  pango_font_description_free (gtk_style ()->font_desc);

  gtk_style ()->font_desc = pango_font_description_copy (desc.pango_font_description ());
}

Inti::Gdk::GC *
Inti::Gtk::Style::fg_gc (StateType state) const
{
  return get_gc (gtk_style ()->fg_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::bg_gc (StateType state) const
{
  return get_gc (gtk_style ()->bg_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::light_gc (StateType state) const
{
  return get_gc (gtk_style ()->light_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::dark_gc (StateType state) const
{
  return get_gc (gtk_style ()->dark_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::mid_gc (StateType state) const
{
  return get_gc (gtk_style ()->mid_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::text_gc (StateType state) const
{
  return get_gc (gtk_style ()->text_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::base_gc (StateType state) const
{
  return get_gc (gtk_style ()->base_gc, state);
}

Inti::Gdk::GC *
Inti::Gtk::Style::black_gc () const
{
  return (Gdk::GC*) Object::_private_wrap ((GObject*) gtk_style ()->black_gc, false);
}

Inti::Gdk::GC *
Inti::Gtk::Style::white_gc () const
{
  return (Gdk::GC*) Object::_private_wrap ((GObject*) gtk_style ()->white_gc, false);
}

Inti::Gdk::GC *
Inti::Gtk::Style::get_gc (GdkGC ** array, StateType state) const
{
  return (Gdk::GC*) Object::_private_wrap ((GObject*)array[int(state)],
                                           false);
}

Inti::Gdk::Pixmap *
Inti::Gtk::Style::bg_pixmap (StateType state) const
{
  return (Gdk::Pixmap*) Object::_private_wrap ((GObject*)gtk_style ()->bg_pixmap[int(state)],
                                               false);
}
      
void
Inti::Gtk::Style::set_fg (StateType state, const Gdk::Color & color)
{
  gtk_style ()->fg[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_bg (StateType state, const Gdk::Color & color)
{
  gtk_style ()->bg[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_light (StateType state, const Gdk::Color & color)
{
  gtk_style ()->light[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_dark (StateType state, const Gdk::Color & color)
{
  gtk_style ()->dark[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_mid (StateType state, const Gdk::Color & color)
{
  gtk_style ()->mid[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_text (StateType state, const Gdk::Color & color)
{
  gtk_style ()->text[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_base (StateType state, const Gdk::Color & color)
{
  gtk_style ()->base[int (state)] = * color.gdk_color ();
}

void
Inti::Gtk::Style::set_xthickness (int size)
{
  gtk_style ()->xthickness = size;
}

void
Inti::Gtk::Style::set_ythickness (int size)
{
  gtk_style ()->ythickness = size;
}

void
Inti::Gtk::Style::install_window_background (Gdk::Window * window,
                                             StateType state)
{
  gtk_style_set_background (gtk_style (),
                            window->gdk_window (),
                            (GtkStateType) state);
}

///////////////////////////////////////////////

Inti::Gtk::Style *
Inti::Gtk::Style::copy_impl () const
{
  // leave it floating
  return (Style*) Object::wrap ((GObject*) gtk_style_copy (gtk_style ()));
}
      
void
Inti::Gtk::Style::draw_hline_impl (Gdk::Drawable *drawable,
                                   StateType state_type,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   int x1,
                                   int x2,
                                   int y)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();

  if (orig->draw_hline)
    (* orig->draw_hline) (gtk_style (), drawable->gdk_drawable (),
                          (GtkStateType) state_type,
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          x1, x2, y);
}

void
Inti::Gtk::Style::draw_vline_impl (Gdk::Drawable *drawable,
                                   StateType state_type,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   int y1,
                                   int y2,
                                   int x)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_vline)
    (* orig->draw_vline) (gtk_style (), drawable->gdk_drawable (),
                          (GtkStateType) state_type,
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          y1, y2, x);
}

void
Inti::Gtk::Style::draw_shadow_impl (Gdk::Drawable *drawable,
                                    StateType state_type,
                                    ShadowType shadow_type,
                                    const Gdk::Rectangle *area,
                                    Gtk::Widget *widget,
                                    const string &detail,
                                    int x,
                                    int y,
                                    int width,
                                    int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_shadow)
    (* orig->draw_shadow) (gtk_style (), drawable->gdk_drawable (),
                           (GtkStateType) state_type,
                           (GtkShadowType) shadow_type,
                           area ? area->gdk_rectangle () : 0,
                           widget ? widget->gtk_widget () : 0,
                           detail.c_str (),
                           x, y, width, height);
}

void
Inti::Gtk::Style::draw_polygon_impl (Gdk::Drawable *drawable,
                                     StateType state_type,
                                     ShadowType shadow_type,
                                     const Gdk::Rectangle *area,
                                     Gtk::Widget *widget,
                                     const string &detail,
                                     const Gdk::Point * points,
                                     int npoints,
                                     bool fill)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_polygon)
    (* orig->draw_polygon) (gtk_style (), drawable->gdk_drawable (),
                            (GtkStateType) state_type,
                            (GtkShadowType) shadow_type,
                            area ? area->gdk_rectangle () : 0,
                            widget ? widget->gtk_widget () : 0,
                            detail.c_str (),
                            (GdkPoint*) points, npoints, fill);
}

void
Inti::Gtk::Style::draw_arrow_impl (Gdk::Drawable *drawable,
                                   StateType state_type,
                                   ShadowType shadow_type,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   ArrowType arrow_type,
                                   bool fill,
                                   int x,
                                   int y,
                                   int width,
                                   int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_arrow)
    (* orig->draw_arrow) (gtk_style (), drawable->gdk_drawable (),
                          (GtkStateType) state_type,
                          (GtkShadowType) shadow_type,
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          (GtkArrowType) arrow_type,
                          fill, x, y, width, height);
}

void
Inti::Gtk::Style::draw_diamond_impl (Gdk::Drawable *drawable,
                                     StateType state_type,
                                     ShadowType shadow_type,
                                     const Gdk::Rectangle *area,
                                     Gtk::Widget *widget,
                                     const string &detail,
                                     int x,
                                     int y,
                                     int width,
                                     int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_diamond)
    (* orig->draw_diamond) (gtk_style (), drawable->gdk_drawable (),
                            (GtkStateType) state_type,
                            (GtkShadowType) shadow_type,
                            area ? area->gdk_rectangle () : 0,
                            widget ? widget->gtk_widget () : 0,
                            detail.c_str (),
                            x, y, width, height);
}

void
Inti::Gtk::Style::draw_oval_impl (Gdk::Drawable *drawable,
                                  StateType state_type,
                                  ShadowType shadow_type,
                                  const Gdk::Rectangle *area,
                                  Gtk::Widget *widget,
                                  const string &detail,
                                  int x,
                                  int y,
                                  int width,
                                  int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_oval)
    (* orig->draw_oval) (gtk_style (), drawable->gdk_drawable (),
                         (GtkStateType) state_type,
                         (GtkShadowType) shadow_type,
                         area ? area->gdk_rectangle () : 0,
                         widget ? widget->gtk_widget () : 0,
                         detail.c_str (),
                         x, y, width, height);
}

void
Inti::Gtk::Style::draw_string_impl (Gdk::Drawable *drawable,
                                    StateType state_type,
                                    const Gdk::Rectangle *area,
                                    Gtk::Widget *widget,
                                    const string &detail,
                                    int x,
                                    int y,
                                    const string &str)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_string)
    (* orig->draw_string) (gtk_style (), drawable->gdk_drawable (),
                           (GtkStateType) state_type,
                           area ? area->gdk_rectangle () : 0,
                           widget ? widget->gtk_widget () : 0,
                           detail.c_str (),
                           x, y, 
                           str.c_str ());
}

void
Inti::Gtk::Style::draw_box_impl (Gdk::Drawable *drawable,
                                 StateType state_type,
                                 ShadowType shadow_type,
                                 const Gdk::Rectangle *area,
                                 Gtk::Widget *widget,
                                 const string &detail,
                                 int x,
                                 int y,
                                 int width,
                                 int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_box)
    (* orig->draw_box) (gtk_style (), drawable->gdk_drawable (),
                        (GtkStateType) state_type,
                        (GtkShadowType) shadow_type,
                        area ? area->gdk_rectangle () : 0,
                        widget ? widget->gtk_widget () : 0,
                        detail.c_str (),
                        x, y, width, height);
}

void
Inti::Gtk::Style::draw_flat_box_impl (Gdk::Drawable *drawable,
                                      StateType state_type,
                                      ShadowType shadow_type,
                                      const Gdk::Rectangle *area,
                                      Gtk::Widget *widget,
                                      const string &detail,
                                      int x,
                                      int y,
                                      int width,
                                      int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_flat_box)
    (* orig->draw_flat_box) (gtk_style (), drawable->gdk_drawable (),
                             (GtkStateType) state_type,
                             (GtkShadowType) shadow_type,
                             area ? area->gdk_rectangle () : 0,
                             widget ? widget->gtk_widget () : 0,
                             detail.c_str (),
                             x, y, width, height);
}

void
Inti::Gtk::Style::draw_check_impl (Gdk::Drawable *drawable,
                                   StateType state_type,
                                   ShadowType shadow_type,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   int x,
                                   int y,
                                   int width,
                                   int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_check)
    (* orig->draw_check) (gtk_style (), drawable->gdk_drawable (),
                          (GtkStateType) state_type,
                          (GtkShadowType) shadow_type,
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          x, y, width, height);
}

void
Inti::Gtk::Style::draw_option_impl (Gdk::Drawable *drawable,
                                    StateType state_type,
                                    ShadowType shadow_type,
                                    const Gdk::Rectangle *area,
                                    Gtk::Widget *widget,
                                    const string &detail,
                                    int x,
                                    int y,
                                    int width,
                                    int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_option)
    (* orig->draw_option) (gtk_style (), drawable->gdk_drawable (),
                           (GtkStateType) state_type,
                           (GtkShadowType) shadow_type,
                     area ? area->gdk_rectangle () : 0,
                           widget ? widget->gtk_widget () : 0,
                           detail.c_str (),
                           x, y, width, height);
}

void
Inti::Gtk::Style::draw_cross_impl (Gdk::Drawable *drawable,
                                   StateType state_type,
                                   ShadowType shadow_type,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   int x,
                                   int y,
                                   int width,
                                   int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_cross)
    (* orig->draw_cross) (gtk_style (), drawable->gdk_drawable (),
                          (GtkStateType) state_type,
                          (GtkShadowType) shadow_type,
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          x, y, width, height);
}

void
Inti::Gtk::Style::draw_ramp_impl (Gdk::Drawable *drawable,
                                  StateType state_type,
                                  ShadowType shadow_type,
                                  const Gdk::Rectangle *area,
                                  Gtk::Widget *widget,
                                  const string &detail,
                                  ArrowType arrow_type,
                                  int x,
                                  int y,
                                  int width,
                                  int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_ramp)
    (* orig->draw_ramp) (gtk_style (), drawable->gdk_drawable (),
                         (GtkStateType) state_type,
                         (GtkShadowType) shadow_type,
                         area ? area->gdk_rectangle () : 0,
                         widget ? widget->gtk_widget () : 0,
                         detail.c_str (),
                         (GtkArrowType) arrow_type,
                         x, y, width, height);
}

void
Inti::Gtk::Style::draw_tab_impl (Gdk::Drawable *drawable,
                                 StateType state_type,
                                 ShadowType shadow_type,
                                 const Gdk::Rectangle *area,
                                 Gtk::Widget *widget,
                                 const string &detail,
                                 int x,
                                 int y,
                                 int width,
                                 int height)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_tab)
    (* orig->draw_tab) (gtk_style (), drawable->gdk_drawable (),
                        (GtkStateType) state_type,
                        (GtkShadowType) shadow_type,
                        area ? area->gdk_rectangle () : 0,
                        widget ? widget->gtk_widget () : 0,
                        detail.c_str (),
                        x, y, width, height);
} 

void
Inti::Gtk::Style::draw_shadow_gap_impl (Gdk::Drawable *drawable,
                                        StateType state_type,
                                        ShadowType shadow_type,
                                        const Gdk::Rectangle *area,
                                        Gtk::Widget *widget,
                                        const string &detail,
                                        int x,
                                        int y,
                                        int width,
                                        int height,
                                        PositionType gap_side,
                                        int gap_x,
                                        int gap_width)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_shadow_gap)
    (* orig->draw_shadow_gap) (gtk_style (), drawable->gdk_drawable (),
                               (GtkStateType) state_type,
                               (GtkShadowType) shadow_type,
                               area ? area->gdk_rectangle () : 0,
                               widget ? widget->gtk_widget () : 0,
                               detail.c_str (),
                               x, y, width, height,
                               (GtkPositionType) gap_side,
                               gap_x, gap_width);
}

void
Inti::Gtk::Style::draw_box_gap_impl (Gdk::Drawable *drawable,
                                     StateType state_type,
                                     ShadowType shadow_type,
                                     const Gdk::Rectangle *area,
                                     Gtk::Widget *widget,
                                     const string &detail,
                                     int x,
                                     int y,
                                     int width,
                                     int height,
                                     PositionType gap_side,
                                     int gap_x,
                                     int gap_width)
{
    GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_box_gap)
    (* orig->draw_box_gap) (gtk_style (), drawable->gdk_drawable (),
                            (GtkStateType) state_type,
                            (GtkShadowType) shadow_type,
                            area ? area->gdk_rectangle () : 0,
                            widget ? widget->gtk_widget () : 0,
                            detail.c_str (),
                            x, y, width, height,
                            (GtkPositionType) gap_side,
                            gap_x, gap_width);
}

void
Inti::Gtk::Style::draw_extension_impl (Gdk::Drawable *drawable,
                                       StateType state_type,
                                       ShadowType shadow_type,
                                       const Gdk::Rectangle *area,
                                       Gtk::Widget *widget,
                                       const string &detail,
                                       int x,
                                       int y,
                                       int width,
                                       int height,
                                       PositionType gap_side)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_extension)
    (* orig->draw_extension) (gtk_style (), drawable->gdk_drawable (),
                              (GtkStateType) state_type,
                              (GtkShadowType) shadow_type,
                              area ? area->gdk_rectangle () : 0,
                              widget ? widget->gtk_widget () : 0,
                              detail.c_str (),
                              x, y, width, height,
                              (GtkPositionType) gap_side);
}

void
Inti::Gtk::Style::draw_focus_impl (Gdk::Drawable *drawable,
                                   const Gdk::Rectangle *area,
                                   Gtk::Widget *widget,
                                   const string &detail,
                                   int x,
                                   int y,
                                   int width,
                                   int height)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_focus)
    (* orig->draw_focus) (gtk_style (), drawable->gdk_drawable (),
                          area ? area->gdk_rectangle () : 0,
                          widget ? widget->gtk_widget () : 0,
                          detail.c_str (),
                          x, y, width, height);
}

void
Inti::Gtk::Style::draw_slider_impl (Gdk::Drawable *drawable,
                                    StateType state_type,
                                    ShadowType shadow_type,
                                    const Gdk::Rectangle *area,
                                    Gtk::Widget *widget,
                                    const string &detail,
                                    int x,
                                    int y,
                                    int width,
                                    int height,
                                    Orientation orientation)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
    if (orig->draw_slider)
      (* orig->draw_slider) (gtk_style (), drawable->gdk_drawable (),
                             (GtkStateType) state_type,
                             (GtkShadowType) shadow_type,
                             area ? area->gdk_rectangle () : 0,
                             widget ? widget->gtk_widget () : 0,
                             detail.c_str (),
                             x, y, width, height,
                             (GtkOrientation) orientation);
}

void
Inti::Gtk::Style::draw_handle_impl (Gdk::Drawable *drawable,
                                    StateType state_type,
                                    ShadowType shadow_type,
                                    const Gdk::Rectangle *area,
                                    Gtk::Widget *widget,
                                    const string &detail,
                                    int x,
                                    int y,
                                    int width,
                                    int height,
                                    Orientation orientation)
{
  GtkStyleClass * orig =
    (GtkStyleClass*) original_class ();
  
  if (orig->draw_handle)
    (* orig->draw_handle) (gtk_style (), drawable->gdk_drawable (),
                           (GtkStateType) state_type,
                           (GtkShadowType) shadow_type,
                           area ? area->gdk_rectangle () : 0,
                           widget ? widget->gtk_widget () : 0,
                           detail.c_str (),
                           x, y, width, height,
                           (GtkOrientation) orientation);
}

////////////////////////////////////////////

      
void
Inti::Gtk::Style::draw_hline_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x1,
                                    gint x2,
                                    gint y)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_hline_impl (drawable,
                      (StateType) state_type,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      x1, x2, y);
}

void
Inti::Gtk::Style::draw_vline_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint y1,
                                    gint y2,
                                    gint x)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_vline_impl (drawable,
                      (StateType) state_type,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      y1, y2, x);
}

void
Inti::Gtk::Style::draw_shadow_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_shadow_impl (drawable,
                       (StateType) state_type,
                       (ShadowType) shadow_type,
                       Gdk::Rectangle::wrap (area),
                       o_w,
                       detail ? string (detail) : string (""),
                       x, y, width, height);  
}

void
Inti::Gtk::Style::draw_polygon_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      GdkPoint *point,
                                      gint npoints,
                                      gboolean fill)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_polygon_impl (drawable,
                        (StateType) state_type,
                        (ShadowType) shadow_type,
                        Gdk::Rectangle::wrap (area),
                        o_w,
                        detail ? string (detail) : string (""),
                        (const Gdk::Point*) point,
                        npoints, fill);
}

void
Inti::Gtk::Style::draw_arrow_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    GtkArrowType arrow_type,
                                    gboolean fill,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_arrow_impl (drawable,
                      (StateType) state_type,
                      (ShadowType) shadow_type,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      (ArrowType) arrow_type,
                      fill, x, y, width, height);
}

void
Inti::Gtk::Style::draw_diamond_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      gint x,
                                      gint y,
                                      gint width,
                                      gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_diamond_impl (drawable,
                        (StateType) state_type,
                        (ShadowType) shadow_type,
                        Gdk::Rectangle::wrap (area),
                        o_w,
                        detail ? string (detail) : string (""),
                        x, y, width, height);
}

void
Inti::Gtk::Style::draw_oval_proxy (GtkStyle *style,
                                   GdkWindow *window,
                                   GtkStateType state_type,
                                   GtkShadowType shadow_type,
                                   GdkRectangle *area,
                                   GtkWidget *widget,
                                   const gchar *detail,
                                   gint x,
                                   gint y,
                                   gint width,
                                   gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_oval_impl (drawable,
                     (StateType) state_type,
                     (ShadowType) shadow_type,
                     Gdk::Rectangle::wrap (area),
                     o_w,
                     detail ? string (detail) : string (""),
                     x, y, width, height);
}

void
Inti::Gtk::Style::draw_string_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     const gchar *str)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_string_impl (drawable,
                       (StateType) state_type,
                       Gdk::Rectangle::wrap (area),
                       o_w,
                       detail ? string (detail) : string (""),
                       x, y, str ? string (str) : string (""));
}

void
Inti::Gtk::Style::draw_box_proxy (GtkStyle *style,
                                  GdkWindow *window,
                                  GtkStateType state_type,
                                  GtkShadowType shadow_type,
                                  GdkRectangle *area,
                                  GtkWidget *widget,
                                  const gchar *detail,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_box_impl (drawable,
                    (StateType) state_type,
                    (ShadowType) shadow_type,
                    Gdk::Rectangle::wrap (area),
                    o_w,
                    detail ? string (detail) : string (""),
                    x, y, width, height);
}

void
Inti::Gtk::Style::draw_flat_box_proxy (GtkStyle *style,
                                       GdkWindow *window,
                                       GtkStateType state_type,
                                       GtkShadowType shadow_type,
                                       GdkRectangle *area,
                                       GtkWidget *widget,
                                       const gchar *detail,
                                       gint x,
                                       gint y,
                                       gint width,
                                       gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_flat_box_impl (drawable,
                         (StateType) state_type,
                         (ShadowType) shadow_type,
                         Gdk::Rectangle::wrap (area),
                         o_w,
                         detail ? string (detail) : string (""),
                         x, y, width, height);
}

void
Inti::Gtk::Style::draw_check_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_check_impl (drawable,
                      (StateType) state_type,
                      (ShadowType) shadow_type,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      x, y, width, height);
}

void
Inti::Gtk::Style::draw_option_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_option_impl (drawable,
                       (StateType) state_type,
                       (ShadowType) shadow_type,
                       Gdk::Rectangle::wrap (area),
                       o_w,
                       detail ? string (detail) : string (""),
                       x, y, width, height);
}

void
Inti::Gtk::Style::draw_cross_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_cross_impl (drawable,
                      (StateType) state_type,
                      (ShadowType) shadow_type,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      x, y, width, height);
}

void
Inti::Gtk::Style::draw_ramp_proxy (GtkStyle *style,
                                   GdkWindow *window,
                                   GtkStateType state_type,
                                   GtkShadowType shadow_type,
                                   GdkRectangle *area,
                                   GtkWidget *widget,
                                   const gchar *detail,
                                   GtkArrowType arrow_type,
                                   gint x,
                                   gint y,
                                   gint width,
                                   gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_ramp_impl (drawable,
                     (StateType) state_type,
                     (ShadowType) shadow_type,
                     Gdk::Rectangle::wrap (area),
                     o_w,
                     detail ? string (detail) : string (""),
                     (ArrowType) arrow_type,
                     x, y, width, height);
}

void
Inti::Gtk::Style::draw_tab_proxy (GtkStyle *style,
                                  GdkWindow *window,
                                  GtkStateType state_type,
                                  GtkShadowType shadow_type,
                                  GdkRectangle *area,
                                  GtkWidget *widget,
                                  const gchar *detail,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_tab_impl (drawable,
                    (StateType) state_type,
                    (ShadowType) shadow_type,
                    Gdk::Rectangle::wrap (area),
                    o_w,
                    detail ? string (detail) : string (""),
                    x, y, width, height);
}

void
Inti::Gtk::Style::draw_shadow_gap_proxy (GtkStyle *style,
                                         GdkWindow *window,
                                         GtkStateType state_type,
                                         GtkShadowType shadow_type,
                                         GdkRectangle *area,
                                         GtkWidget *widget,
                                         const gchar *detail,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height,
                                         GtkPositionType gap_side,
                                         gint gap_x,
                                         gint gap_width)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_shadow_gap_impl (drawable,
                           (StateType) state_type,
                           (ShadowType) shadow_type,
                           Gdk::Rectangle::wrap (area),
                           o_w,
                           detail ? string (detail) : string (""),
                           x, y, width, height,
                           (PositionType) gap_side, gap_x, gap_width);
}

void
Inti::Gtk::Style::draw_box_gap_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      gint x,
                                      gint y,
                                      gint width,
                                      gint height,
                                      GtkPositionType gap_side,
                                      gint gap_x,
                                      gint gap_width)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_box_gap_impl (drawable,
                        (StateType) state_type,
                        (ShadowType) shadow_type,
                        Gdk::Rectangle::wrap (area),
                        o_w,
                        detail ? string (detail) : string (""),
                        x, y, width, height,
                        (PositionType) gap_side,
                        gap_x, gap_width);
}

void
Inti::Gtk::Style::draw_extension_proxy (GtkStyle *style,
                                        GdkWindow *window,
                                        GtkStateType state_type,
                                        GtkShadowType shadow_type,
                                        GdkRectangle *area,
                                        GtkWidget *widget,
                                        const gchar *detail,
                                        gint x,
                                        gint y,
                                        gint width,
                                        gint height,
                                        GtkPositionType gap_side)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_extension_impl (drawable,
                          (StateType) state_type,
                          (ShadowType) shadow_type,
                          Gdk::Rectangle::wrap (area),
                          o_w,
                          detail ? string (detail) : string (""),
                          x, y, width, height,
                          (PositionType) gap_side);
}

void
Inti::Gtk::Style::draw_focus_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_focus_impl (drawable,
                      Gdk::Rectangle::wrap (area),
                      o_w,
                      detail ? string (detail) : string (""),
                      x, y, width, height);
}

void
Inti::Gtk::Style::draw_slider_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height,
                                     GtkOrientation orientation)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_slider_impl (drawable,
                       (StateType) state_type,
                       (ShadowType) shadow_type,
                       Gdk::Rectangle::wrap (area),
                       o_w,
                       detail ? string (detail) : string (""),
                       x, y, width, height,
                       (Orientation) orientation);
}

void
Inti::Gtk::Style::draw_handle_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height,
                                     GtkOrientation orientation)
{
  Gtk::Style * o =
    (Gtk::Style*) Object::_private_wrap ((GObject*) style, false);
  
  Gdk::Drawable * drawable =
    (Gdk::Drawable*) Object::_private_wrap ((GObject*) window, false);

  Gtk::Widget * o_w =
    (Gtk::Widget*) Object::wrap ((GObject*) widget);

  o->draw_handle_impl (drawable,
                       (StateType) state_type,
                       (ShadowType) shadow_type,
                       Gdk::Rectangle::wrap (area),
                       o_w,
                       detail ? string (detail) : string (""),
                       x, y, width, height,
                       (Orientation) orientation);
}

/////////// Everything below here is machine-generated
