// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_TOGGLEBUTTON_H_
#define _INTI_GTK_TOGGLEBUTTON_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/button.h>
#include <gtk/gtktogglebutton.h>

/*$ doc header
  $short The #Inti::Gtk::ToggleButton widget
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class ToggleButtonClass;
    };

    class ToggleButton : public Button
    {
    public:
      /*$ doc class ToggleButton
        $short widget for labelling a UI element, such as a #Button or a #Frame

        $copy none
        $memory floating

        $long

        <para>

        </para>

        $*/

      GtkToggleButton * gtk_toggle_button () const
      {
        return (GtkToggleButton*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new toggle button
        $long

        <para>

        </para>

        $*/
      ToggleButton ();

      /*$ doc constructor
        $short Construct a new #ToggleButton containing a #Label with the given @text
        @text text the label should display
        $long

        <para>

        </para>

        $*/
      ToggleButton (const string & text);
      ToggleButton (const char * text);

    protected:
      typedef WrapSignal0<void> ToggledSignalType;
      static const ToggledSignalType toggled_signal;

    public:
      typedef SignalProxy<Object,ToggledSignalType> ToggledProxyType;
      const ToggledProxyType sig_toggled ()
      {
        return ToggledProxyType (this, &toggled_signal);
      }

      void set_active (bool is_active);

      bool active () const { return gtk_toggle_button ()->active; }

    protected:
      friend class Private::ToggleButtonClass;

      explicit ToggleButton (GtkToggleButton *src, GtkToggleButtonClass* orig);
      virtual ~ToggleButton ();

      virtual void toggled_impl ();
      virtual void on_toggled ();

    private:
      ToggleButton(const ToggleButton&);
      ToggleButton& operator=(const ToggleButton&);

      static void toggled_proxy (GtkToggleButton * tb);

    }; // class ToggleButton

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_TOGGLEBUTTON_H_
