// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_PANGO_FONT_H_
#define _INTI_PANGO_FONT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>
#include <pango/pango-font.h>

namespace Inti
{
  namespace Pango
  {
    typedef enum
    {
      STYLE_NORMAL = PANGO_STYLE_NORMAL,
      STYLE_OBLIQUE = PANGO_STYLE_OBLIQUE,
      STYLE_ITALIC = PANGO_STYLE_ITALIC
    } Style;

    typedef enum
    {
      VARIANT_NORMAL = PANGO_VARIANT_NORMAL,
      VARIANT_SMALL_CAPS = PANGO_VARIANT_SMALL_CAPS
    } Variant;

    extern const int WEIGHT_MINIMUM;
    extern const int WEIGHT_NORMAL;
    extern const int WEIGHT_BOLD;
    extern const int WEIGHT_MAXIMUM;

    typedef enum
    {
      STRETCH_ULTRA_CONDENSED = PANGO_STRETCH_ULTRA_CONDENSED,
      STRETCH_EXTRA_CONDENSED = PANGO_STRETCH_EXTRA_CONDENSED,
      STRETCH_CONDENSED = PANGO_STRETCH_CONDENSED,
      STRETCH_SEMI_CONDENSED = PANGO_STRETCH_SEMI_CONDENSED,
      STRETCH_NORMAL = PANGO_STRETCH_NORMAL,
      STRETCH_SEMI_EXPANDED = PANGO_STRETCH_SEMI_EXPANDED,
      STRETCH_EXPANDED = PANGO_STRETCH_EXPANDED,
      STRETCH_EXTRA_EXPANDED = PANGO_STRETCH_EXTRA_EXPANDED,
      STRETCH_ULTRA_EXPANDED = PANGO_STRETCH_ULTRA_EXPANDED
    } Stretch;
    
    class FontDescription
    {
    public:
      FontDescription ();
      explicit FontDescription (const string & description);
      explicit FontDescription (const char * description);
      FontDescription (const string & family, Style style, int weight);
      FontDescription (const char * family, Style style, int weight);
      FontDescription (const PangoFontDescription * pango_font_desc);
      FontDescription (const FontDescription & src);
      FontDescription & operator=(const FontDescription & src);
      bool operator==(const FontDescription & rhs) const;
      
      void set_family (const string & family);
      void set_family (const char * family);
      const ustring & family () const;

      void set_style (Style style);
      Style style () const;

      void set_variant (Variant variant);
      Variant variant () const;

      void set_weight (int weight);
      int weight () const;

      void set_stretch (Stretch str);
      Stretch stretch () const;

      void set_size (int size);
      int size () const;

      void set (const string & description);
      void set (const char * description);
      void set (const string & family, Style style, int weight);
      void set (const char * family, Style style, int weight);

      ustring to_string () const;
      
      const PangoFontDescription * pango_font_description () const;
      void set (const PangoFontDescription * desc);
      
    private:
      ustring family_;
      PangoFontDescription desc_;

      void init ();
      void init (const PangoFontDescription * src);

    }; // class FontDescription
    
  }; // namespace Pango
  
}; // namespace Inti

#endif // _INTI_PANGO_FONT_H_
