// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_PRIVATE_UTIL_H_
#define _INTI_BASE_PRIVATE_UTIL_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>

/*$ doc header
  $short Private header file, don't use
  $*/

namespace Inti
{
  namespace Private
  {
    // Quark used for storing object data
    GQuark quark ();
    
    // Share a value between multiple owners
    template <class T>
    class SharedValue
    {
    public:
      SharedValue (T t)
        : body_(new SharedValueBody(t))
      {
      }

      ~SharedValue ()
      {
        body_->unref ();
      }
      
      SharedValue (const SharedValue& src)
        : body_(src.body_)
      {
        body_->ref ();
      }

      SharedValue& operator=(const SharedValue& src)
      {
        if (body_ == src.body_)
          return;

        body_->unref ();
        body_ = src.body_;
        body_->ref ();

        return *this;
      }

      void set (T t)
      {
        body_->get() = t;
      }

      T& get ()
      {
        return body_->get ();
      }

      const T& get () const
      {
        return body_->get ();
      }
      
    private:
      SharedValue();
      
      class SharedValueBody
      {
      public:
        SharedValueBody (T t)
          : ref_count_(1), val_(t)
        {

        }

        T& get ()
        {
          return val_;
        }

        const T& get() const
        {
          return val_;
        }
        
        void ref ()
        {
          ref_count_ += 1;
        }
        
        void unref ()
        {
          ref_count_ -= 1;
          if (ref_count_ == 0)
            delete this;
        }

      protected:
        ~SharedValueBody ()
        {
        }
        
      private:
        unsigned int ref_count_;
        T val_;

        SharedValueBody (const SharedValueBody&);
        SharedValueBody& operator= (const SharedValueBody&);
        
      };

      SharedValueBody *body_;      
    };
  };
};


#endif // _INTI_BASE_PRIVATE_UTIL_H_
