// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_TEXT_H_
#define _INTI_BASE_TEXT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>
#include <glib.h>

/*$ doc header
  $short Text processing and strings
  $*/

namespace Inti
{
  /// Some text-processing utility functions

  namespace Text
  {
    // there's some evil overloading-on-int-and-pointer here, but you
    // never want to pass the literal "0" for either the int or the
    // pointer, so there should not be any ambiguous cases.

    int to_int (const string & s, int base = 0);
    int to_int (const char * s, int base = 0);
    int to_int (const string & s, int * length_used, int base = 0);
    int to_int (const char * s, int * length_used, int base = 0);

    unsigned int to_uint (const string & s, int base = 0);
    unsigned int to_uint (const char * s, int base = 0);
    unsigned int to_uint (const string & s, int * length_used, int base = 0);
    unsigned int to_uint (const char * s, int * length_used, int base = 0);
    
    long to_long (const string & s, int base = 0);
    long to_long (const char * s, int base = 0);
    long to_long (const string & s, int * length_used, int base = 0);
    long to_long (const char * s, int * length_used, int base = 0);
    
    unsigned long to_ulong (const string & s, int base = 0);
    unsigned long to_ulong (const char * s, int base = 0);
    unsigned long to_ulong (const string & s, int * length_used, int base = 0);
    unsigned long to_ulong (const char * s, int * length_used, int base = 0);
    
    float to_float (const string & s);
    float to_float (const char * s);
    float to_float (const string & s, int * length_used);
    float to_float (const char * s, int * length_used);
    
    double to_double (const string & s);
    double to_double (const char * s);
    double to_double (const string & s, int * length_used);
    double to_double (const char * s, int * length_used);

    ustring to_string (int i);
    ustring to_string (unsigned int i);
    ustring to_string (long i);
    ustring to_string (unsigned long i);
    ustring to_string (float f);
    ustring to_string (double d);    

    ustring lstrip (const string & s);
    ustring lstrip (const char * s);
    ustring rstrip (const string & s);
    ustring rstrip (const char * s);
    ustring strip (const string & s);
    ustring strip (const char * s);
    
    ustring printf_format (const char * printf_format, ...) G_GNUC_PRINTF (1, 2);
    
  }; // namespace Text
  
}; // namespace Inti

#endif // _INTI_BASE_TEXT_H_
