// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_UTF_STRING_H_
#define _INTI_BASE_UTF_STRING_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <string>

/*$ doc header
  $short Text processing and strings
  $*/

namespace Inti
{
  typedef int unicode_char;
  
  // A key design point about ustring is that it only adds methods to
  // string, it doesn't change the behavior of string or add member
  // variables.  Because string isn't virtualized this is important.

  // See Stroustrup Chapter 20 for std::string; gcc STL doesn't
  // support the allocator stuff though, so we don't either.
  
  // For now we're waiting on unicode support in glib, so there's
  // not much to look at in this class
  class ustring : public string
  {
  public:
    
    //// Mirror all string constructors
    
    explicit ustring ()
    {
    }

    ustring (const string & s)
      : string (s)
    {
    }
    
    ustring (const string & s,
             size_type pos,
             size_type n = npos)
      : string (s, pos, n)
    {
    }

    ustring (const value_type * p,
             size_type n)
      : string (p, n)
    {
    }

    ustring (const value_type * p)
      : string (p)
    {
    }

    ustring (size_type n,
             value_type c)
      : string (n, c)
    {
    }

    template <class IterType>
    ustring (IterType first,
             IterType last)
      : string (first, last)
    {
    }

#if 0
    // we want to mirror the byte-based string interface with
    // character-based stuff

    class char_iterator
    {
    public:
      class _char_proxy
      {
      public:

      };
      
      typedef unicode_char value_type;
      typedef unicode_char * pointer;
      typedef unicode_char & reference;
      typedef string::size_type size_type;
      typedef string::difference_type difference_type;

      char_iterator () {}
      char_iterator (const iterator & i) : i_(i) {}
      char_iterator (const char_iterator & i) : i_(i.i_) {}

      bool operator== (const iterator & i) const { return i_ == i.i_; }
      bool operator!= (const iterator & i) const { return i_ != i.i_; }
      _char_proxy operator* () const;

      char_iterator& operator++ () { ++i_; return *this; }
      char_iterator& operator++ (int)
      {
        char_iterator tmp (*this);
        ++*this;
        return tmp;
      }

      char_iterator& operator-- ();
      char_iterator& operator-- (int)
      {
        char_iterator tmp (*this);
        --*this;
        return tmp;
      }

      char_iterator & operator+= (difference_type i);
      char_iterator & operator+ (difference_type i) const;

      char_iterator & operator-= (difference_type i);
      char_iterator & operator- (difference_type i) const;

      difference_type operator- (const char_iterator& i) const;
      
      // FIXME conversion operator to iterator
    private:
      iterator i_;
      
    };

    class const_char_iterator : public const_iterator
    {
      const unicode_char & operator* ();


    };

    typedef std::reverse_iterator<char_iterator> reverse_char_iterator;
    typedef std::reverse_iterator<const_char_iterator> const_reverse_char_iterator;

    size_type char_size () const;
    size_type char_length () const { return char_size (); }
    ustring char_substr (size_type i = 0, size_type n = npos);
    unicode_char & char_at (size_type i);
    const unicode_char & char_at (size_type i) const;
    
    size_type char_find (const ustring & substr, size_type i = 0) const;
    size_type char_find (const char * substr, size_type i = 0) const;
    size_type char_find (const char * substr, size_type i, size_type n) const;
    size_type char_find (unicode_char c, size_type i = 0) const;

    size_type char_rfind (const ustring & substr, size_type i = npos) const;
    size_type char_rfind (const char * substr, size_type i = npos) const;
    size_type char_rfind (const char * substr, size_type i, size_type n) const;
    size_type char_rfind (unicode_char c, size_type i = npos) const;

    size_type char_find_first_of (const ustring & chars, size_type i = 0) const;
    size_type char_find_first_of (const char * chars, size_type i = 0) const;
    size_type char_find_first_of (const char * chars, size_type i, size_type n) const;
    size_type char_find_first_of (unicode_char c, size_type i = 0) const;

    size_type char_find_last_of (const ustring & chars, size_type i = npos) const;
    size_type char_find_last_of (const char * chars, size_type i = npos) const;
    size_type char_find_last_of (const char * chars, size_type i, size_type n) const;
    size_type char_find_last_of (unicode_char c, size_type i = npos) const;
    
    size_type char_find_first_not_of (const ustring & chars, size_type i = 0) const;
    size_type char_find_first_not_of (const char * chars, size_type i = 0) const;
    size_type char_find_first_not_of (const char * chars, size_type i, size_type n) const;
    size_type char_find_first_not_of (unicode_char c, size_type i = 0) const;

    size_type char_find_last_not_of (const ustring & chars, size_type i = npos) const;
    size_type char_find_last_not_of (const char * chars, size_type i = npos) const;
    size_type char_find_last_not_of (const char * chars, size_type i, size_type n) const;
    size_type char_find_last_not_of (unicode_char c, size_type i = npos) const;    

#endif
  };
  
}; // namespace Inti

#endif // _INTI_BASE_UTF_STRING_H_
