#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

from string import *
import sys
import os
import re
import exceptions

code_key = re.compile ("%%% ([a-zA-Z_0-9]+)")
impl_start = re.compile ("!!! implementation")

class CodeRepository:
    def __init__(self, files):
        self.code = {}
        
        for f in files:
            self.add_file (f)


    def add_file (self, filename):
        try:
            f = open (filename)
        except IOError:
            sys.stderr.write ("Failed to open code file: %s\n" % filename)
            return
        
        lines = f.readlines ()

        current_key = None
        current_decl = None
        current_def = None
        in_def = 0

        for line in lines:            
            match = code_key.match (line)
            if match:

                ## store
                if current_key:
                    strip (current_key)
                    self.code[current_key] = (current_decl, current_def)

                ## reset
                current_key = match.group(1)
                current_decl = None
                current_def = None
                in_def = 0
                
                continue

            match = impl_start.match (line)
            if match:
                in_def = 1

                continue

                
            if in_def:
                if current_def:
                    current_def = current_def + line
                else:
                    current_def = line

            else:
                if current_decl:
                    current_decl = current_decl + line
                else:
                    current_decl = line

        if current_key:
            strip (current_key)
            self.code[current_key] = (current_decl, current_def)
            
    def get (self, key):
        return self.code.get (key)


