// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include <inti/object.h>
#include <gdk/gdkwindow.h>
#include "gdkbase.h"
#include "drawable-class.h"
#include "window-class.h"
#include "pixmap-class.h"
#include "dnd-class.h"
#include "colormap-class.h"
#include "image-class.h"
#include "gc-class.h"
#include "window.h"
#include "cursor.h"
#include <stdio.h>
#include <gdk/gdk.h>

Inti::Gdk::Rectangle::Rectangle ()
{
  Base::x = Base::y = Base::width = Base::height = 0;
}

Inti::Gdk::Rectangle::Rectangle (int x, int y, int width, int height)
{
  Base::x = x;
  Base::y = y;
  Base::width = width;
  Base::height = height;
}

Inti::Gdk::Rectangle::Rectangle (const Pango::Rectangle & src)
{
  Base::x = src.x ();
  Base::y = src.y ();
  Base::width = src.width ();
  Base::height = src.height ();
}

void
Inti::Gdk::Rectangle::set (int x, int y, int width, int height)
{
  Base::x = x;
  Base::y = y;
  Base::width = width;
  Base::height = height;
}

void
Inti::Gdk::Rectangle::set_position (int x, int y)
{
  Base::x = x;
  Base::y = y;
}


void
Inti::Gdk::Rectangle::set_position (const Point & point)
{
  Base::x = point.x ();
  Base::y = point.y ();
}

void
Inti::Gdk::Rectangle::set_size (int width, int height)
{
  Base::width = width;
  Base::height = height;
}

void
Inti::Gdk::Rectangle::translate (int x_delta, int y_delta)
{
  Base::x += x_delta;
  Base::y += y_delta;
}

bool
Inti::Gdk::Rectangle::intersects (const Rectangle & rect) const
{
  GdkRectangle ignored;
  
  return gdk_rectangle_intersect ((GdkRectangle*)this,
                                  rect.gdk_rectangle (),
                                  &ignored) != FALSE;
}
      
bool
Inti::Gdk::Rectangle::intersection_with (const Rectangle & rect)
{
  return gdk_rectangle_intersect ((GdkRectangle*)this,
                                  rect.gdk_rectangle (),
                                  (GdkRectangle*)this) != FALSE;
}
                                        
void
Inti::Gdk::Rectangle::union_with (const Rectangle & rect)
{
  gdk_rectangle_union ((GdkRectangle*)this,
                       rect.gdk_rectangle (),
                       (GdkRectangle*)this);
}

bool
Inti::Gdk::Rectangle::operator== (const Rectangle & rhs) const
{
  return
    rhs.x () == x () &&
    rhs.y () == y () &&
    rhs.width () == width () &&
    rhs.height () == height ();
}

bool
Inti::Gdk::Rectangle::operator!= (const Rectangle & rhs) const
{
  return !(*this == rhs);
}

Inti::Gdk::Point::Point ()
{
  Base::x = 0;
  Base::y = 0;
}

Inti::Gdk::Point::Point (int x, int y)
{
  Base::x = x;
  Base::y = y;
}

bool
Inti::Gdk::Point::operator== (const Point & rhs) const
{
  return
    rhs.x () == x () &&
    rhs.y () == y ();
}

bool
Inti::Gdk::Point::operator!= (const Point & rhs) const
{
  return !(*this == rhs);
}

Inti::Gdk::Segment::Segment ()
{
  Base::x1 = Base::y1 = Base::x2 = Base::y2 = 0;
}

Inti::Gdk::Segment::Segment (int x1, int y1, int x2, int y2)
{
  Base::x1 = x1;
  Base::y1 = y1;
  Base::x2 = x2;
  Base::y2 = y2;
}

Inti::Gdk::Segment::Segment (const Point & point1, const Point & point2)
{
  Base::x1 = point1.x ();
  Base::y1 = point1.y ();
  Base::x2 = point2.x ();
  Base::y2 = point2.y ();
}

void
Inti::Gdk::Segment::set_start (int x, int y)
{
  Base::x1 = x;
  Base::y1 = y;
}

void
Inti::Gdk::Segment::set_start (const Point & point)
{
  Base::x1 = point.x ();
  Base::y1 = point.y ();
}

void
Inti::Gdk::Segment::set_end (int x, int y)
{
  Base::x2 = x;
  Base::y2 = y;
}

void
Inti::Gdk::Segment::set_end (const Point & point)
{
  Base::x2 = point.x ();
  Base::y2 = point.y ();
}

void
Inti::Gdk::Segment::set (int x1, int y1, int x2, int y2)
{
  Base::x1 = x1;
  Base::y1 = y1;
  Base::x2 = x2;
  Base::y2 = y2;
}

void
Inti::Gdk::Segment::set (const Point & point1, const Point & point2)
{
  Base::x1 = point1.x ();
  Base::y1 = point1.y ();
  Base::x2 = point2.x ();
  Base::y2 = point2.y ();
}

bool
Inti::Gdk::Segment::operator== (const Segment & rhs) const
{
  return
    Base::x1 == rhs.x1 () &&
    Base::y1 == rhs.y1 () &&
    Base::x2 == rhs.x2 () &&
    Base::y2 == rhs.y2 ();
}

bool
Inti::Gdk::Segment::operator!= (const Segment & rhs) const
{
  return !(*this == rhs);
}

void
Inti::Gdk::beep ()
{
  gdk_beep ();
}

Inti::Gdk::Atom
Inti::Gdk::atom_intern (const ustring & str, bool only_if_exists)
{
  return atom_intern (str.c_str (), only_if_exists);
}

Inti::Gdk::Atom
Inti::Gdk::atom_intern (const char * str, bool only_if_exists)
{
  return gdk_atom_intern (str, only_if_exists);
}

void
Inti::Gdk::Private::internal_init ()
{
  using namespace Private;
  
  // Please keep these alphabetized
  Object::register_wrapper ("GdkColormap", ColormapClass::get_wrapper);
  Object::register_wrapper ("GdkDragContext", DragContextClass::get_wrapper);
  Object::register_wrapper ("GdkDrawable", DrawableClass::get_wrapper);
  Object::register_wrapper ("GdkGC", GCClass::get_wrapper);
  Object::register_wrapper ("GdkImage", ImageClass::get_wrapper);
  Object::register_wrapper ("GdkPixmap", PixmapClass::get_wrapper);
  Object::register_wrapper ("GdkWindow", WindowClass::get_wrapper);
}

bool
Inti::Gdk::init (int * argc, char *** argv, bool fatal_errors)
{
  Private::internal_init ();
  
  if (!gdk_init_check (argc, argv))
    {
      if (fatal_errors)
        {
          fprintf (stderr, "Unable to open a connection to the X display.\n");
          exit (1);
          return false; // compiler warnings
        }
      else
        return false;
    }
  else
    return true;  
}

void
Inti::Gdk::set_sm_client_id (const ustring & str)
{
  set_sm_client_id (str.c_str ());
}

void
Inti::Gdk::set_sm_client_id (const char * str)
{
  gdk_set_sm_client_id (str);
}

Inti::ustring
Inti::Gdk::set_locale ()  
{
  return ustring (gdk_set_locale ());
}

void
Inti::Gdk::error_trap_push ()
{
  gdk_error_trap_push ();
}

int
Inti::Gdk::error_trap_pop ()
{
  return gdk_error_trap_pop ();
}

void
Inti::Gdk::set_use_xshm (bool setting)
{
  gdk_set_use_xshm (setting);
}
bool
Inti::Gdk::use_xshm ()
{
  return gdk_get_use_xshm ();
}

Inti::ustring
Inti::Gdk::display ()
{
  return ustring (gdk_get_display ());
}

bool
Inti::Gdk::pointer_grab (Window * window,
                         bool owner_events,
                         EventMaskField event_mask,
                         Window * confine_to,
                         const Cursor & cursor,
                         guint32 time)
{
  return gdk_pointer_grab (window->gdk_window (),
                           owner_events,
                           (GdkEventMask)event_mask,
                           confine_to ? confine_to->gdk_window () : 0,
                           cursor.gdk_cursor (),
                           time);
}

void
Inti::Gdk::pointer_ungrab (guint32 time)
{
  gdk_pointer_ungrab (time);
}

bool
Inti::Gdk::keyboard_grab (Window * window,
                          bool owner_events,
                          guint32 time)
{
  return gdk_keyboard_grab (window->gdk_window (),
                            owner_events,
                            time);
}

void
Inti::Gdk::keyboard_ungrab (guint32 time)
{
  gdk_keyboard_ungrab (time);
}

bool
Inti::Gdk::pointer_grabbed ()
{
  return gdk_pointer_is_grabbed ();
}

int
Inti::Gdk::screen_width ()
{
  return gdk_screen_width ();
}

int
Inti::Gdk::screen_height ()
{
  return gdk_screen_height ();
}

int
Inti::Gdk::screen_width_mm ()
{
  return gdk_screen_width_mm ();
}

int
Inti::Gdk::screen_height_mm ()
{
  return gdk_screen_height_mm ();
}
    
void
Inti::Gdk::flush ()
{
  gdk_flush ();
}

void
Inti::Gdk::key_repeat_disable ()
{
  gdk_key_repeat_disable ();
}

void
Inti::Gdk::key_repeat_restore ()
{
  gdk_key_repeat_restore ();
}

Inti::ustring
Inti::Gdk::keyval_name (unsigned int keyval)
{
  const char * name = gdk_keyval_name (keyval);
  if (name)
    return ustring (name);
  else
    return ustring ("");
}

unsigned int
Inti::Gdk::keyval_from_name (const ustring & name)
{
  return keyval_from_name (name.c_str ());
}

unsigned int
Inti::Gdk::keyval_from_name (const char * name)
{
  return gdk_keyval_from_name (name);
}

void
Inti::Gdk::keyval_convert_case (unsigned int keyval,
                                unsigned int * upper,
                                unsigned int * lower)
{
  gdk_keyval_convert_case (keyval, upper, lower);
}

unsigned int
Inti::Gdk::keyval_to_upper (unsigned int keyval)
{
  return gdk_keyval_to_upper (keyval);
}

unsigned int
Inti::Gdk::keyval_to_lower (unsigned int keyval)
{
  return gdk_keyval_to_lower (keyval);
}

bool
Inti::Gdk::keyval_is_upper (unsigned int keyval)
{
  return gdk_keyval_is_upper (keyval);
}

bool
Inti::Gdk::keyval_is_lower (unsigned int keyval)
{
  return gdk_keyval_is_lower (keyval);
}

/////////// Everything below here is machine-generated
