// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "window.h"
#include "visual.h"
#include "cursor.h"
#include "pixmap.h"
#include "bitmap.h"
#include "color.h"
#include "region.h"

Inti::Gdk::Window::Window (GdkWindowObject * src, GdkWindowObjectClass * orig)
  : Drawable ((GdkDrawable*)src, (GdkDrawableClass*)orig)
{
  // We own ourselves
  ref ();
  sink ();
}

Inti::Gdk::Window::Window (Window * parent,
                              const Attributes & attributes)
  : Drawable (0, 0)
{
  GdkWindow * win;

  win = gdk_window_new (parent->gdk_window (),
                        attributes.gdk_window_attr (),
                        attributes.gdk_window_attributes_type ());

  init_from_g_object (G_OBJECT (win), G_OBJECT_CLASS (G_OBJECT_GET_CLASS (win)));

  // We own ourselves
  ref ();
  sink ();
}

Inti::Gdk::Window::~Window ()
{
  
}

void
Inti::Gdk::Window::destroy ()
{
  gdk_window_destroy (gdk_window ());
}

Inti::Gdk::Window::Type
Inti::Gdk::Window::type ()
{
  return (Type) gdk_window_get_window_type (gdk_window ());
}
      
void
Inti::Gdk::Window::show ()
{
  gdk_window_show (gdk_window ());
}

void
Inti::Gdk::Window::hide ()
{
  gdk_window_hide (gdk_window ());
}

void
Inti::Gdk::Window::withdraw ()
{
  gdk_window_withdraw (gdk_window ());
}

void
Inti::Gdk::Window::move (int x, int y)
{
  gdk_window_move (gdk_window (), x, y);
}

void
Inti::Gdk::Window::resize (int width, int height)
{
  gdk_window_resize (gdk_window (), width, height);
}

void
Inti::Gdk::Window::move_resize (int x, int y, int width, int height)
{
  gdk_window_move_resize (gdk_window (), x, y, width, height);
}

void
Inti::Gdk::Window::reparent (Window * parent,
                                int x, int y)
{
  gdk_window_reparent (gdk_window (), parent->gdk_window (), x, y);
}

void
Inti::Gdk::Window::clear ()
{
  gdk_window_clear (gdk_window ());
}

void
Inti::Gdk::Window::clear (int x, int y, int width, int height)
{
  gdk_window_clear_area (gdk_window (), x, y, width, height);
}

void
Inti::Gdk::Window::raise ()
{
  gdk_window_raise (gdk_window ());
}

void
Inti::Gdk::Window::lower ()
{
  gdk_window_lower (gdk_window ());
}

void
Inti::Gdk::Window::set_override_redirect (bool setting)
{
  gdk_window_set_override_redirect (gdk_window (), setting);
}

void
Inti::Gdk::Window::shape_combine_mask (Bitmap * shape_mask,
                                          int x_offset,
                                          int y_offset)
{
  gdk_window_shape_combine_mask (gdk_window (),
                                 shape_mask ? shape_mask->gdk_pixmap () : 0,
                                 x_offset,
                                 y_offset);
}

bool
Inti::Gdk::Window::is_visible () const
{
  return gdk_window_is_visible (gdk_window ());
}

bool
Inti::Gdk::Window::is_viewable () const
{
  return gdk_window_is_viewable (gdk_window ());
}

bool
Inti::Gdk::Window::set_static_gravities (bool setting)
{
  return gdk_window_set_static_gravities (gdk_window (), setting);
}


void
Inti::Gdk::Window::set_geometry_hints (const Geometry & geometry)
{
  gdk_window_set_geometry_hints (gdk_window (),
                                 geometry.gdk_geometry (),
                                 geometry.gdk_window_hints ());
}

void
Inti::Gdk::Window::begin_paint (const Rectangle & rect)
{
  gdk_window_begin_paint_rect (gdk_window (), rect.gdk_rectangle ());
}

void
Inti::Gdk::Window::begin_paint (const Region & region)
{
  gdk_window_begin_paint_region (gdk_window (), region.gdk_region ());
}

void
Inti::Gdk::Window::end_paint ()
{
  gdk_window_end_paint (gdk_window ());
}

void
Inti::Gdk::Window::set_title (const ustring & str)
{
  set_title (str.c_str ());
}

void
Inti::Gdk::Window::set_title (const char * str)
{
  gdk_window_set_title (gdk_window (), str);
}

void
Inti::Gdk::Window::set_role (const ustring & str)
{
  set_role (str.c_str ());
}

void
Inti::Gdk::Window::set_role (const char * str)
{
  gdk_window_set_role (gdk_window (), str);
}

void
Inti::Gdk::Window::set_transient_for (Window * transient_parent)
{
  gdk_window_set_transient_for (gdk_window (),
                                transient_parent ? transient_parent->gdk_window () : 0);
}

void
Inti::Gdk::Window::set_background (const Color & color)
{
  gdk_window_set_background (gdk_window (), color.gdk_color ());
}

void
Inti::Gdk::Window::unset_background ()
{
  gdk_window_set_background (gdk_window (), NULL);
}

void
Inti::Gdk::Window::set_background_pixmap (Pixmap * pixmap,
                                             bool parent_relative)
{
  gdk_window_set_back_pixmap (gdk_window (),
                              pixmap ? pixmap->gdk_pixmap () : 0,
                              parent_relative);
}

void
Inti::Gdk::Window::set_cursor (const Cursor & cursor)
{
  gdk_window_set_cursor (gdk_window (), cursor.gdk_cursor ());
}

void
Inti::Gdk::Window::unset_cursor ()
{
  gdk_window_set_cursor (gdk_window (), 0);
}

void
Inti::Gdk::Window::get_geometry (int * x, int * y,
                                    int * width, int * height, int * depth = 0) const
{
  gdk_window_get_geometry (gdk_window (),
                           x, y, width, height, depth);
}

void
Inti::Gdk::Window::get_position (int * x, int * y) const
{
  gdk_window_get_position (gdk_window (),
                           x, y);
}


Inti::Gdk::Window *
Inti::Gdk::Window::get_pointer (int * x, int * y, ModifierTypeField * modifiers) const
{
  GdkWindow * win =
    gdk_window_get_pointer (gdk_window (), x, y, (GdkModifierType*)modifiers);

  return dynamic_cast<Window*>(Object::_private_wrap ((GObject*)win, false));
}

Inti::Gdk::Window *
Inti::Gdk::Window::parent () const
{
  GdkWindow * win = gdk_window_get_parent (gdk_window ());

  return dynamic_cast<Window*>(Object::_private_wrap ((GObject*)win, false));
}

Inti::Gdk::Window *
Inti::Gdk::Window::toplevel () const
{
  GdkWindow * win = gdk_window_get_toplevel (gdk_window ());

  return dynamic_cast<Window*>(Object::_private_wrap ((GObject*)win, false));
}

vector<Inti::Gdk::Window*>
Inti::Gdk::Window::children () const
{
  GList * children = gdk_window_get_children (gdk_window ());

  vector<Window*> retval;
  
  GList * tmp = children;
  while (tmp != NULL)
    {
      retval.push_back (dynamic_cast<Window*>(Object::_private_wrap ((GObject*)tmp->data, false)));
                        
      tmp = g_list_next (tmp);
    }

  return retval;
}

Inti::Gdk::EventMaskField
Inti::Gdk::Window::events () const
{
  return (EventMaskField) gdk_window_get_events (gdk_window ());
}

void
Inti::Gdk::Window::set_events (EventMaskField event_mask)
{
  gdk_window_set_events (gdk_window (),
                         (GdkEventMask) event_mask);
}

void
Inti::Gdk::Window::set_icon (Window * window)
{
  gdk_window_set_icon (gdk_window (),
                       window ? window->gdk_window () : 0,
                       0, 0);
}

void
Inti::Gdk::Window::set_icon (Bitmap * icon, Bitmap * mask)
{
  gdk_window_set_icon (gdk_window (),
                       0,
                       icon ? icon->gdk_pixmap () : 0,
                       mask ? mask->gdk_pixmap () : 0);                       
}

void
Inti::Gdk::Window::set_icon_name (const ustring & str)
{
  set_icon_name (str.c_str ());
}

void
Inti::Gdk::Window::set_icon_name (const char * str)
{
  gdk_window_set_icon_name (gdk_window (), str);
}

void
Inti::Gdk::Window::set_group (Window * group_leader)
{
  gdk_window_set_group (gdk_window (),
                        group_leader ? group_leader->gdk_window () : 0);
}

void
Inti::Gdk::Window::set_decorations (WMDecorationField decorations)
{
  gdk_window_set_decorations (gdk_window (),
                              (GdkWMDecoration) decorations);
}

void
Inti::Gdk::Window::set_functions (WMFunctionField functions)
{
  gdk_window_set_functions (gdk_window (),
                            (GdkWMFunction) functions);
}

void
Inti::Gdk::Window::register_dnd ()
{
  gdk_window_register_dnd (gdk_window ());
}

void
Inti::Gdk::Window::invalidate (const Rectangle & rect, bool invalidate_children)
{
  gdk_window_invalidate_rect (gdk_window (),
                              rect.gdk_rectangle (),
                              invalidate_children);
}

void
Inti::Gdk::Window::invalidate (const Region & region, bool invalidate_children)
{
  gdk_window_invalidate_region (gdk_window (),
                                region.gdk_region (),
                                invalidate_children);
}

Inti::Gdk::Region *
Inti::Gdk::Window::get_update_area () const
{
  GdkRegion * region =
    gdk_window_get_update_area (gdk_window ());

  if (region)
    return new Region (region, false);
  else
    return 0;
}

void
Inti::Gdk::Window::freeze_updates ()
{
  gdk_window_freeze_updates (gdk_window ());
}

void
Inti::Gdk::Window::thaw_updates ()
{
  gdk_window_thaw_updates (gdk_window ());
}
      
void
Inti::Gdk::Window::process_updates (bool update_children)
{
  gdk_window_process_updates (gdk_window (), update_children);
}

void
Inti::Gdk::Window::process_all_updates ()
{
  gdk_window_process_all_updates ();
}

vector<Inti::Gdk::Window*>
Inti::Gdk::Window::list_toplevels ()
{
  GList * tops = gdk_window_get_toplevels ();

  vector<Window*> retval;
  
  GList * tmp = tops;
  while (tmp != NULL)
    {
      retval.push_back (dynamic_cast<Window*>(Object::_private_wrap ((GObject*)tmp->data, false)));
                        
      tmp = g_list_next (tmp);
    }

  return retval;  
}

Inti::Gdk::Window *
Inti::Gdk::window_at_pointer (int * x, int * y)
{
  GdkWindow * win =
    gdk_window_at_pointer (x, y);

  return dynamic_cast<Window*>(Object::_private_wrap ((GObject*)win, false));
}

/*
 * Geometry
 */

Inti::Gdk::Geometry::Geometry ()
{
  geometry_.min_width = geometry_.min_height = 0;
  geometry_.max_width = geometry_.max_height = 0;
  geometry_.base_width = geometry_.base_height = 0;
  geometry_.width_inc = geometry_.height_inc = 0;
  geometry_.min_aspect = geometry_.max_aspect = 0.0;
  
  hints_ = 0;
}

void
Inti::Gdk::Geometry::set_min_size (int width, int height)
{
  geometry_.min_width = width;
  geometry_.min_height = height;
  hints_ |= GDK_HINT_MIN_SIZE;
}

void
Inti::Gdk::Geometry::set_max_size (int width, int height)
{
  geometry_.max_width = width;
  geometry_.max_height = height;
  hints_ |= GDK_HINT_MAX_SIZE;
}

void
Inti::Gdk::Geometry::set_base_size (int width, int height)
{
  geometry_.base_width = width;
  geometry_.base_height = height;
  hints_ |= GDK_HINT_BASE_SIZE;
}

void
Inti::Gdk::Geometry::set_resize_increments (int width_inc, int height_inc)
{
  geometry_.width_inc = width_inc;
  geometry_.height_inc = height_inc;
  hints_ |= GDK_HINT_RESIZE_INC;
}

void
Inti::Gdk::Geometry::set_aspect_range (double min_aspect_ratio,
                                                  double max_aspect_ratio)
{
  geometry_.min_aspect = min_aspect_ratio;
  geometry_.max_aspect = max_aspect_ratio;
  hints_ |= GDK_HINT_ASPECT;
}

void
Inti::Gdk::Geometry::unset_min_size ()
{
  hints_ &= ~GDK_HINT_MIN_SIZE;
}

void
Inti::Gdk::Geometry::unset_max_size ()
{
  hints_ &= ~GDK_HINT_MAX_SIZE;
}

void
Inti::Gdk::Geometry::unset_base_size ()
{
  hints_ &= ~GDK_HINT_BASE_SIZE;
}

void
Inti::Gdk::Geometry::unset_resize_increments ()
{
  hints_ &= ~GDK_HINT_RESIZE_INC;
}

void
Inti::Gdk::Geometry::unset_aspect_range ()
{
  hints_ &= ~GDK_HINT_ASPECT;
}

///////////////////////////////


Inti::Gdk::Window::Attributes::Attributes (Type t,
                                              Class c,
                                              EventMaskField mask,
                                              int width,
                                              int height)
  : attr_mask_ (0),
    // initialize these just so they're always set to something
    // we can return by reference.
    cursor_ (new Cursor (Cursor::STANDARD_ARROW)),
    visual_ (Visual::system ())   
{
  attr_.window_type = (GdkWindowType) t;
  attr_.wclass = (GdkWindowClass) c;
  attr_.event_mask = mask;
  attr_.width = width;
  attr_.height = height;

  attr_.title = 0;
  attr_.x = 0;
  attr_.y = 0;
  attr_.visual = 0;
  attr_.colormap = 0;
  attr_.cursor = 0;
  attr_.wmclass_name = 0;
  attr_.wmclass_class = 0;
  attr_.override_redirect = false;
}

Inti::Gdk::Window::Attributes::Attributes (const Attributes & src)
  : attr_(src.attr_),
    attr_mask_ (src.attr_mask_),
    cursor_ (0),
    visual_ (src.visual_),
    title_ (src.title_),
    wm_name_ (src.wm_name_),
    wm_class_ (src.wm_class_)
{
  *cursor_ = *src.cursor_;
}

Inti::Gdk::Window::Attributes::Attributes &
Inti::Gdk::Window::Attributes::operator=(const Attributes & src)
{
  *cursor_ = *src.cursor_;

  attr_ = src.attr_;
  attr_mask_ = src.attr_mask_;
  visual_ = src.visual_;
  title_ = src.title_;
  wm_name_ = src.wm_name_;
  wm_class_ = src.wm_class_;

  return *this;
}


Inti::Gdk::Window::Attributes::~Attributes ()
{
  delete cursor_;
}

void
Inti::Gdk::Window::Attributes::set_title (const ustring & title)
{
  title_ = title;
  attr_mask_ |= GDK_WA_TITLE;
}

void
Inti::Gdk::Window::Attributes::set_title (const char * title)
{
  title_ = title;
  attr_mask_ |= GDK_WA_TITLE;
}

void
Inti::Gdk::Window::Attributes::set_event_mask (EventMaskField mask)
{
  attr_.event_mask = mask;
}

void
Inti::Gdk::Window::Attributes::set_position (int x, int y)
{
  attr_.x = x;
  attr_.y = y;
  attr_mask_ |= GDK_WA_X | GDK_WA_Y;
}

void
Inti::Gdk::Window::Attributes::set_position (const Point & point)
{
  set_position (point.x (), point.y ());
}

void
Inti::Gdk::Window::Attributes::set_size (int width, int height)
{
  attr_.width = width;
  attr_.height = height;
}

void
Inti::Gdk::Window::Attributes::set_visual (const Visual & visual)
{
  visual_ = &visual;
  attr_mask_ |= GDK_WA_VISUAL;
}

void
Inti::Gdk::Window::Attributes::set_cursor (const Cursor & cursor)
{
  *cursor_ = cursor;
}

void
Inti::Gdk::Window::Attributes::set_wm_class (const ustring & wm_class,
                                                const ustring & wm_name)
{
  wm_class_ = wm_class;
  wm_name_ = wm_name;
  attr_mask_ |= GDK_WA_WMCLASS;
}

void
Inti::Gdk::Window::Attributes::set_wm_class (const char * wm_class,
                                                const char * wm_name)
{
  wm_class_ = wm_class;
  wm_name_ = wm_name;
  attr_mask_ |= GDK_WA_WMCLASS;
}

void
Inti::Gdk::Window::Attributes::set_override_redirect (bool setting)
{
  attr_.override_redirect = setting;
  attr_mask_ |= GDK_WA_NOREDIR;
}

void
Inti::Gdk::Window::Attributes::unset_title ()
{
  attr_mask_ &= ~GDK_WA_TITLE;
}

void
Inti::Gdk::Window::Attributes::unset_visual ()
{
  attr_mask_ &= ~GDK_WA_VISUAL;
}

void
Inti::Gdk::Window::Attributes::unset_colormap ()
{
  attr_mask_ &= ~GDK_WA_COLORMAP;
}

void
Inti::Gdk::Window::Attributes::unset_cursor ()
{
  attr_mask_ &= ~GDK_WA_CURSOR;
}

void
Inti::Gdk::Window::Attributes::unset_wm_class ()
{
  attr_mask_ &= ~GDK_WA_WMCLASS;
}

void
Inti::Gdk::Window::Attributes::unset_override_redirect ()
{
  attr_mask_ &= ~GDK_WA_NOREDIR;
}

GdkWindowAttr *
Inti::Gdk::Window::Attributes::gdk_window_attr () const
{
  // We have to sync the attr_ to the current state

  attr_.title = const_cast<char*>(title_.c_str ());
  attr_.wmclass_class = const_cast<char*>(wm_class_.c_str ());
  attr_.wmclass_name = const_cast<char*>(wm_name_.c_str ());
  attr_.visual = visual_->gdk_visual ();
  attr_.cursor = cursor_->gdk_cursor ();
  
  return const_cast<GdkWindowAttr*>(&attr_);
}

GdkWindowAttributesType
Inti::Gdk::Window::Attributes::gdk_window_attributes_type () const
{
  return (GdkWindowAttributesType) attr_mask_;
}

/////////// Everything below here is machine-generated
