// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_PANED_H_
#define _INTI_GTK_PANED_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/container.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkhpaned.h>
#include <gtk/gtkvpaned.h>

/*$ doc header
  $short FIXME
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class PanedClass;
      class HPanedClass;
      class VPanedClass;
    };
    
    class Paned : public Container
    {
    public:
      /*$ doc class Paned
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkPaned * gtk_paned () const
      {
        return (GtkPaned*)g_object ();
      }

      void add1 (Inti::Gtk::Widget* child);
      void add2 (Inti::Gtk::Widget* child);
      void pack1 (Inti::Gtk::Widget* child, bool resize, bool shrink);
      void pack2 (Inti::Gtk::Widget* child, bool resize, bool shrink);

      void set_position (int position);
      int position () const;

      void set_handle_size (int size);
      int handle_size () const;

      Widget * child1 () const;
      Widget * child2 () const;
      
    protected:
      friend class Private::PanedClass;
      
      explicit Paned (GtkPaned *src, GtkPanedClass *orig);
      Paned ();
      virtual ~Paned () = 0; // abstract
      
    private:
      Paned(const Paned&);
      Paned& operator=(const Paned&);
      
    }; // class Paned

    
    class HPaned : public Paned
    {
    public:
      /*$ doc class HPaned
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkHPaned * gtk_hpaned () const
      {
        return (GtkHPaned*)g_object ();
      }

      HPaned ();
      
    protected:
      friend class Private::HPanedClass;
      
      explicit HPaned (GtkHPaned *src, GtkHPanedClass *orig);
      virtual ~HPaned ();
      
    private:
      HPaned(const HPaned&);
      HPaned& operator=(const HPaned&);
      
    }; // class HPaned

    
    class VPaned : public Paned
    {
    public:
      /*$ doc class VPaned
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkVPaned * gtk_vpaned () const
      {
        return (GtkVPaned*)g_object ();
      }

      VPaned ();
      
    protected:
      friend class Private::VPanedClass;
      
      explicit VPaned (GtkVPaned *src, GtkVPanedClass *orig);
      virtual ~VPaned ();
      
    private:
      VPaned(const VPaned&);
      VPaned& operator=(const VPaned&);
      
    }; // class VPaned
    
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_PANED_H_
