// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_TOOLTIPS_H_
#define _INTI_GTK_TOOLTIPS_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtktooltips.h>
#include <inti/utf-string.h>

/*$ doc header
  $short The #Inti::Gtk::Tooltips class
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class TooltipsClass;
    };

    class Widget;
    
    class Tooltips : public Object
    {
    public:
      /*$ doc class Tooltips
        $short A group of tooltips that can be switched on or off together

        $copy none
        $memory floating
        
        $long

        <para>
        FIXME
        </para>

        <para>

        </para>
        
        $*/
        
      GtkTooltips * gtk_tooltips () const
      {
        return (GtkTooltips*)g_object ();
      }
      
      /*$ doc constructor
        $short Construct a new #Tooltips
        $long

        <para>
        Creates a new #Tooltips object; you can use a single
        tooltips object to apply tooltips to multiple widgets.
        </para>
        
        $*/
      Tooltips ();
      
      void set_tip (Widget * widget,
                    const ustring & tip);
      
      void set_tip (Widget * widget,
                    const char * tip);
      
      void unset_tip (Widget * widget);

      ustring tip (Widget * widget) const;
      void set_enabled (bool setting);
      bool enabled () const { return gtk_tooltips ()->enabled; }
      
    protected:
      friend class Private::TooltipsClass;
      
      explicit Tooltips (GtkTooltips *src,
                         GtkTooltipsClass * orig);
      virtual ~Tooltips ();
      
    private:
      Tooltips(const Tooltips&);
      Tooltips& operator=(const Tooltips&);

      virtual void sink_impl ();
      virtual bool floating () const;
      
    }; // class Tooltips

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_TOOLTIPS_H_
