// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_PANGO_ATTRIBUTES_H_
#define _INTI_PANGO_ATTRIBUTES_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>
#include <inti/pango/font.h>
#include <pango/pango-attributes.h>
#include <vector>

namespace Inti
{
  namespace Pango
  {
    typedef enum
    {
      UNDERLINE_NONE = PANGO_UNDERLINE_NONE,
      UNDERLINE_SINGLE = PANGO_UNDERLINE_SINGLE,
      UNDERLINE_DOUBLE = PANGO_UNDERLINE_DOUBLE,
      UNDERLINE_LOW = PANGO_UNDERLINE_LOW
    } Underline;

    class Attribute
    {
    public:      
      int type_id () const;

      unsigned int start () const;
      unsigned int end () const;
      void set_start (unsigned int start);
      void set_end (unsigned int end);
      void set (unsigned int start, unsigned int end);
      
      static Attribute * wrap (PangoAttribute * src, bool copy);
      PangoAttribute * pango_attribute (bool create_new_copy) const;

      Attribute (const Attribute & src);
      Attribute & operator= (const Attribute & src);

      ~Attribute ();
      
    protected:
      Attribute (PangoAttribute * attr);

      PangoAttrString * pango_attribute_string () const
      {
        return (PangoAttrString*) attr_;
      }

      PangoAttrColor * pango_attribute_color () const
      {
        return (PangoAttrColor*) attr_;
      }
      
      PangoAttrInt * pango_attribute_int () const
      {
        return (PangoAttrInt*) attr_;
      }

      PangoAttrFontDesc * pango_attribute_font_desc () const
      {
        return (PangoAttrFontDesc*) attr_;
      }
      
    private:
      PangoAttribute * attr_;
      
    }; // class Attribute

    class LanguageAttribute : public Attribute
    {
    public:
      explicit LanguageAttribute (const ustring & language);
      explicit LanguageAttribute (const char * language);

      ustring language () const;
      void set_language (const ustring & language);
      void set_language (const char * language);

      static const int TYPE_ID;

    protected:
      friend class Attribute;
      LanguageAttribute (PangoAttribute * attr);
      
    };

    class FontFamilyAttribute : public Attribute
    {
    public:
      explicit FontFamilyAttribute (const ustring & font_family);
      explicit FontFamilyAttribute (const char * font_family);

      ustring font_family () const;
      void set_font_family (const ustring & font_family);
      void set_font_family (const char * font_family);

      static const int TYPE_ID;

    protected:
      friend class Attribute;
      FontFamilyAttribute (PangoAttribute * attr);
      
    };

    class StyleAttribute : public Attribute
    {
    public:
      explicit StyleAttribute (Style style);

      Style style () const;
      void set_style (Style style);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      StyleAttribute (PangoAttribute * attr);
    };

    class WeightAttribute : public Attribute
    {
    public:
      explicit WeightAttribute (int weight);

      int weight () const;
      void set_weight (int weight);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      WeightAttribute (PangoAttribute * attr);
    };
    
    class VariantAttribute : public Attribute
    {
    public:
      explicit VariantAttribute (Variant v);

      Variant variant () const;
      void set_variant (Variant v);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      VariantAttribute (PangoAttribute * attr);
    };

    class StretchAttribute : public Attribute
    {
    public:
      explicit StretchAttribute (Stretch str);

      Stretch stretch () const;
      void set_stretch (Stretch s);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      StretchAttribute (PangoAttribute * attr);
    };

    class SizeAttribute : public Attribute
    {
    public:
      explicit SizeAttribute (int size);

      int size () const;
      void set_size (int s);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      SizeAttribute (PangoAttribute * attr);
    };

    class FontDescriptionAttribute : public Attribute
    {
    public:
      explicit FontDescriptionAttribute (const FontDescription & description);

      FontDescription font_description () const;
      void set_font_description (const FontDescription & description);

      static const int TYPE_ID;

    protected:
      friend class Attribute;
      FontDescriptionAttribute (PangoAttribute * attr);
    };

    class ForegroundAttribute : public Attribute
    {
    public:
      explicit ForegroundAttribute (guint16 red,
                                    guint16 green,
                                    guint16 blue);

      guint16 red () const;
      guint16 green () const;
      guint16 blue () const;

      void set (guint16 red,
                guint16 green,
                guint16 blue);

      void set_red (guint16 red);
      void set_blue (guint16 blue);
      void set_green (guint16 green);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      ForegroundAttribute (PangoAttribute * attr);
    };

    class BackgroundAttribute : public Attribute
    {
    public:
      explicit BackgroundAttribute (guint16 red,
                                    guint16 green,
                                    guint16 blue);

      guint16 red () const;
      guint16 green () const;
      guint16 blue () const;

      void set (guint16 red,
                guint16 green,
                guint16 blue);

      void set_red (guint16 red);
      void set_blue (guint16 blue);
      void set_green (guint16 green);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      BackgroundAttribute (PangoAttribute * attr);
    };
    
    class UnderlineAttribute : public Attribute
    {
    public:
      explicit UnderlineAttribute (Underline uline = UNDERLINE_SINGLE);

      Underline underline () const;
      void set_underline (Underline uline);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      UnderlineAttribute (PangoAttribute * attr);
    };

    class StrikethroughAttribute : public Attribute
    {
    public:
      explicit StrikethroughAttribute (bool is_stricken = true);
      
      bool strikethrough () const;
      void set_strikethrough (bool is_stricken);

      static const int TYPE_ID;
      
    protected:
      friend class Attribute;
      StrikethroughAttribute (PangoAttribute * attr);
    };

    class RiseAttribute : public Attribute
    {
    public:
      explicit RiseAttribute (int rise);

      int rise () const;
      void set_rise (int rise);

      static const int TYPE_ID;

    protected:
      friend class Attribute;
      RiseAttribute (PangoAttribute * attr);
    };

    class AttributeList
    {
    public:
      class Range
      {
      public:
        Range ();
        ~Range ();
        
        bool next ();
        unsigned int start () const;
        unsigned int end () const;
        Attribute *get (int type_id) const;
        void get_all (const FontDescription & default_font,
                      FontDescription * current_font,
                      vector<Attribute*> * nonfont_attributes) const;

        Range (const Range& src);
        Range & operator= (const Range& src);

      private:
        PangoAttrIterator *iter_;

        friend class AttributeList;
        Range (PangoAttrIterator * iter);
      };

      AttributeList ();
      ~AttributeList ();

      AttributeList (const AttributeList & src);
      AttributeList & operator= (const AttributeList & src);      
      
      void insert (const Attribute & attr);
      void change (const Attribute & attr);
      Range first_range () const;

      PangoAttrList *pango_attr_list () const;
      
    private:
      PangoAttrList *list_;
    };
    
  }; // namespace Pango

}; // namespace Inti

#endif // _INTI_PANGO_ATTRIBUTES_H_
