#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

import string
import re
import exceptions
import errno
import sys
import os

fd = os.popen ("nm --size-sort --demangle %s" % sys.argv[1], 'r')
lines = fd.readlines ()

symbol_line = re.compile ('([0-9a-f]+) (.) (.*)')

symbols = []

for line in lines:
    name = None
    type = None
    size = None
    match = symbol_line.match (line)
    if match:
        size = string.atol (match.group (1), 16)
        type = match.group (2)
        name = match.group (3)

    symbols.append ((size, type, name))

symbols.reverse () # nm outputs things in ascending order, I want descending

type_totals = {}
total = 0
translations = {
    'A' : 'global absolute',
    'B' : 'global bss',
    'C' : 'global common',
    'D' : 'global initialized data',
    'G' : 'global initialized data for small objects',
    'I' : 'global indirect reference',
    'N' : 'global debugging',
    'R' : 'global read-only',
    'S' : 'global bss for small objects',
    'T' : 'global text',
    'U' : 'global undefined',
    'V' : 'global virtual table',
    'W' : 'global weak',
    'a' : 'absolute',
    'b' : 'bss',
    'c' : 'common',
    'd' : 'initialized data',
    'g' : 'initialized data for small objects',
    'i' : 'indirect reference',
    'n' : 'debugging',
    'r' : 'read-only',
    's' : 'bss for small objects',
    't' : 'text',
    'u' : 'undefined',
    'v' : 'virtual table',
    'w' : 'weak',
    '-' : 'stabs (debugging)',
    '?' : 'unknown (mostly exception-handling overhead?)'
    }

def inc_type (typename, sym):
    if translations.has_key (typename):
        typename = translations[typename]
    
    if type_totals.has_key (typename):
        type_totals[typename] = type_totals[typename] + s[0]
    else:
        type_totals[typename] = s[0]

for s in symbols:
    inc_type (s[1], s)

    if string.find (s[2], 'type_info node') >= 0:
        inc_type ('type_info node', s)

    if string.find (s[2], 'type_info function') >= 0:
        inc_type ('type_info function', s)

    if string.find (s[2], '::on_') >= 0:
        inc_type ('on_blah funcs', s)

    if string.find (s[2], '_impl(') >= 0:
        inc_type ('blah_impl funcs', s)

    if string.find (s[2], '_proxy(') >= 0:
        inc_type ('proxy funcs', s)

    if string.find (s[2], 'Inti::Slot') >= 0:
        inc_type ('slot-related instantiations', s)

    total = total + s[0]

print "Total size %d" % total
for key in type_totals.keys ():
    print "Total of '%s': %d" % (key, type_totals[key])

for s in symbols:
    print "%d %s %s" % s

sys.exit (0) # exit before the old version below

fd = os.popen ("objdump --demangle -d %s" % sys.argv[1], 'r')
lines = fd.readlines ()

all_items = []
current_item = []
for line in lines:
    if line[0] != ' ':
        all_items.append (current_item)
        current_item = []

    if (string.strip (line) != ''):
        current_item.append (line)

def lencmp (a, b):
    return cmp (len (a), len (b))

all_items.sort (lencmp)
all_items.reverse ()

header = re.compile ('([0-9a-f]+) *<(.*)> *:')
instruction = re.compile (' +([0-9a-f]+):')

sizes = []

for item in all_items:
    if (len (item) > 0):
        start_addr = None
        name = None
        match = header.match (item[0])
        if match:
            start_addr = match.group (1)
            name = match.group (2)
        else:
            continue # some junk we want to ignore

        last_addr = None
        match = instruction.match (item[-1])
        if match:
            last_addr = match.group (1)
        else:
            continue # weird stuff

        start = string.atol (start_addr, 16)
        end = string.atol (last_addr, 16)
        bytes = end - start

        sizes.append ((bytes, name))


def sizecmp (a, b):
    return cmp (a[0], b[0])

sizes.sort (sizecmp)
sizes.reverse ()

total = 0
for s in sizes:
    total = total + s[0]

print "Total: %d bytes" % total

for s in sizes:
    print "%d: %s" % (s[0], s[1])











