/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.util.ChainingRuntimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public final class Environment {
    private static final String DELIMETER = "|";
    private static final PatternCompiler REGEXP_COMPILER = new Perl5Compiler();
    private static Pattern _variablesPattern;
    private static final Environment INSTANCE;
    private final PatternMatcher _matcher = new Perl5Matcher();
    private Map _variables;

    private Environment(boolean initial) {
        if (initial) {
            this._variables = new HashMap(25);
            this._variables.putAll(System.getProperties());
            Convention settings = Convention.getInstance();
            String variables = settings.get(ConventionKeys.ENVIRONMENT, ConventionDefaults.ENVIRONMENT);
            if (!"".equals(variables)) {
                StringTokenizer tokens = new StringTokenizer(variables, DELIMETER);
                while (tokens.hasMoreElements()) {
                    String pair = tokens.nextToken();
                    int delimOffset = pair.indexOf(94);
                    String key = pair.substring(0, delimOffset);
                    String value = pair.substring(delimOffset + 1);
                    this._variables.put(key, value);
                }
            }
        }
    }

    public static Environment getInstance() {
        return INSTANCE;
    }

    public Environment copy() {
        Environment environment = new Environment(false);
        environment._variables = new HashMap(Environment.INSTANCE._variables);
        return environment;
    }

    public String interpolate(String str) {
        PatternMatcherInput input = new PatternMatcherInput(str);
        HashMap<String, String> keys = new HashMap<String, String>(10);
        while (this._matcher.contains(input, _variablesPattern)) {
            MatchResult result = this._matcher.getMatch();
            String value = (String)this._variables.get(result.group(1));
            if (value == null || value.length() <= 0) continue;
            keys.put(result.group(0), value);
        }
        Iterator i = keys.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringSubstitution substitution = new StringSubstitution(value);
            Pattern pattern = null;
            try {
                pattern = REGEXP_COMPILER.compile(Perl5Compiler.quotemeta((String)key));
            }
            catch (MalformedPatternException ex) {
                continue;
            }
            str = Util.substitute((PatternMatcher)this._matcher, (Pattern)pattern, (Substitution)substitution, (String)str, (int)-1);
        }
        return str;
    }

    public void set(String variable, String value) {
        this._variables.put(variable, value);
    }

    public String toString() {
        return this._variables.toString();
    }

    public void unset(String variable) {
        this._variables.remove(variable);
    }

    static {
        try {
            _variablesPattern = REGEXP_COMPILER.compile("\\$([a-zA-Z_][a-zA-Z0-9_.]+)\\$", 32768);
        }
        catch (MalformedPatternException ex) {
            throw new ChainingRuntimeException(ex);
        }
        INSTANCE = new Environment(true);
    }

    public static final class Variable {
        public static final Variable FILE = new Variable("file");
        public static final Variable FILE_NAME = new Variable("fileName");
        public static final Variable FILE_FORMAT = new Variable("fileFormat");
        public static final Variable TAB_SIZE = new Variable("tabSize");
        public static final Variable CONVENTION = new Variable("convention");
        public static final Variable PACKAGE = new Variable("package");
        public static final Variable TYPE_PARAM = new Variable("paramType");
        public static final Variable TYPE_EXCEPTION = new Variable("exceptionType");
        public static final Variable TYPE_OBJECT = new Variable("objectType");
        String name;
        int hashCode;

        private Variable(String name) {
            this.name = name.intern();
            this.hashCode = this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Variable) {
                return this.name == ((Variable)o).name;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

