/*
 * Copyright (C) 2001  Sistina Software
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LVM; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#include "tools.h"

static int vgimport_single(const char *vg_name);

int vgimport(int argc, char **argv)
{
        if (!argc && !arg_count(all_ARG)) {
                log_error("Please supply volume groups or use -a for all.");
                return ECMD_FAILED;
        }

        if (argc && arg_count(all_ARG)) {
                log_error("No arguments permitted when using -a for all.");
                return ECMD_FAILED;
        }

	return process_each_vg(argc, argv, &vgimport_single);
}

static int vgimport_single(const char *vg_name)
{
	struct volume_group *vg;

	if (!(vg = fid->ops->vg_read(fid, vg_name))) {
		log_error("Unable to find exported volume group \"%s\"",
			  vg_name);
		return ECMD_FAILED;
	}

	if (!(vg->status & EXPORTED_VG)) {
		log_error("Volume group \"%s\" is not exported", vg_name);
		return ECMD_FAILED;
	}

	if (vg->status & PARTIAL_VG) {
		log_error("Volume group \"%s\" is partially missing", vg_name);
		return ECMD_FAILED;
	}

	if (!archive(vg))
		return ECMD_FAILED;

	vg->status &= ~EXPORTED_VG;

	if (!fid->ops->vg_write(fid,vg))
		return ECMD_FAILED;

	backup(vg);

	log_print("Volume group \"%s\" successfully imported", vg->name);
	
	return 0;
}
