#include "../lib/of1275.h"

const char hex[] = "0123456789abcdef";


main()
{
  /* write 8 blocks then read them back */
  int i;
  char buf[512];
  int j;
  int disk_ihandle;
  int status;

  /* find the boot args */
  char bootargs[128];
  of_find_string_property("/chosen", "bootargs", bootargs, sizeof(bootargs));
  write_string("args: ");
  write_string(bootargs);
  write_line();

  /* find the chosen disk */
  if (of1275_open(bootargs, &disk_ihandle) < 0) {
    write_string("Open of cdrom:1 failed");
    write_line();
    exit(1);
  }

  of1275_read(disk_ihandle, buf, sizeof(buf), &status);
  if (status != sizeof(buf)) {
    write_string("read failed");
    write_line();
    exit(1);
  }

  /* verify that the block is correct */
  for (j = 0; j < sizeof(buf); j++) {
    if (j % 32 == 0) {
      write_hex(j);
    }
    if (j % 4 == 0)
      write_string(" ");
    write_char(hex[(buf[j] >> 4) & 0xf]);
    write_char(hex[(buf[j]) & 0xf]);
    if (j % 32 == 31)
      write_line();
  }
  exit (0);
}
