#include "../lib/of1275.h"

typedef struct _eeprom_args {
  volatile unsigned char *memory;
  int nr_sectors;
  int sector_size;
  int byte_write_delay;
  int sector_start_delay;
  int erase_delay;
  int man_code;
  int dev_code;
  int argp;
  char path[128];
} eeprom_args;

extern void eeprom_parse_args(eeprom_args *eeprom);

extern void erase_eeprom(eeprom_args *eeprom);

typedef enum {
  erase_sector_ok,
  erase_sector_window_closed,
  erase_sector_window_already_closed,
} erase_sector_status;
extern erase_sector_status erase_sector(eeprom_args *eeprom, int check, unsigned sector);

extern void program_byte(eeprom_args *eeprom, unsigned address, unsigned char byte);
