/* erase the entire eeprom */

#include "eeprom.h"

static int addresses[] = {
  0, 3, 7, -1,
};


int
main()
{
  int i;
  eeprom_args eeprom;
  parse_eeprom_args(&eeprom);

  /* start off erased */
  erase_eeprom(&eeprom);
  while ((eeprom.memory[0] & 0x80) != 0x80);

  /* program a sequence of bytes with ~addresses */
  for (i = 0; addresses[i] >= 0; i++) {
    int iteration;
    unsigned char address = addresses[i];
    program_byte(&eeprom, address, ~address);
    for (iteration = 0; iteration < eeprom.byte_write_delay; iteration++) {
      if ((eeprom.memory[address] & 0x80) == (~address & 0x80))
	break;
    }
    if (iteration >= eeprom.byte_write_delay) {
      write_string("eeprom timed out");
      write_line();
      exit(1);
    }
    if ((eeprom.memory[address] & 0xff) != (~address & 0xff)) {
      write_string("Bad programing 0x");
      write_hex(eeprom.memory[address]);
      write_string(" != 0x");
      write_hex(~address);
      write_line();
      exit(1);
    }
    write_string("address 0x");
    write_hex(address);
    write_string(", iterations ");
    write_int(iteration);
    write_line();
  }
  exit(0);
}
