/* Print out the current value of the NVRAM */


void
catch()
{
  write_string("Caught interrupt\n");
  write_line();
  exit(1);
}


void
do_something(char *nvram,
	     char *clock)
{
  memset(nvram, 0xaf, (clock - nvram));
}

char *day_of_week[] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

typedef struct _nvclock {
  char control;
  char second;
  char minute;
  char hour;
  char day;
  char date;
  char month;
  char year;
} nvclock;

const char *const quaters[] = { "twelve", "three", "six", "nine", "twelve" };
const char *const hours[] = { "twelve", "one", "two", "three", "four", "five",
				"six", "seven", "eight", "nine", "ten", "eleven",
				"twelve" };

void
write_big_ben_time(volatile nvclock *clock)
{
  int hour = bcd2int(clock->hour) % 12;
  int quater = (((bcd2int(clock->minute) * 60 + clock->second + 60*60/8)
		 / 60) / 15);
  write_string("Ben's big hand is on the ");
  write_string(quaters[quater]);

  write_string(" while his little hand is ");
  switch (quater) {
  case 0: /*0*/
    write_string("on the ");
    write_string(hours[hour]);
    break;
  case 1: /*15*/
    write_string("just after the ");
    write_string(hours[hour]);
    break;
  case 2: /*30*/
    write_string("half way between the ");
    write_string(hours[hour]);
    write_string(" and the ");
    write_string(hours[hour+1]);
    break;
  case 3: /*45*/
    write_string("just before the ");
    write_string(hours[hour+1]);
    break;
  case 4: /*60 */
    write_string("on the ");
    write_string(hours[hour + 1]);
    break;
  default:
    write_int(quater);
    write_string("?");
    write_line();
    exit(1);
    break;
  }
  write_string(".");
}

void
write_the_time(volatile nvclock *clock)
{
  /* day of week */
  if (clock->day >= 1 && clock->day <= 7)
    write_string(day_of_week[clock->day - 1]);
  else
    write_int(clock->day);
  write_string(" ");

  /* date */
  write_bcd(clock->date);
  write_string("/");
  write_bcd(clock->month);
  write_string("/");
  write_bcd(clock->year);
  write_string(" ");

  /* time */
  write_bcd(clock->hour);
  write_string(":");
  write_bcd(clock->minute);
  write_string(":");
  write_bcd(clock->second);
}


int
main(int argc, char **argv)
{
  volatile nvclock *clock;
  int delay = 0;
  
  if (argc != 3) {
    write_string("Usage: nvram-addr nvram-size");
    write_line();
    exit(1);
  }

  clock = (volatile nvclock*)(strtoul(argv[1], 0, 0) + strtoul(argv[2], 0, 0) - 8);

  /* write out the time according to how it should be done */
  clock->control = 0x40;
  write_string("The time is: ");
  write_the_time(clock);
  write_line();
  clock->control = 0x00;
  
  /* check that the second hand is ticking over */
  {
    int seconds = clock->second;
    while (seconds == clock->second);
    delay = 0;
    seconds = clock->second;
    while (seconds == clock->second)
      delay++;
    write_string("Delay is: ");
    write_int(delay);
    write_line();
  }
  
  /* again write out the time but this time check that the second hand
     doesn't change */
  {
    int seconds;
    int count;
    clock->control = 0x40;
    seconds = clock->second;
    count = delay * 2;
    while (seconds == clock->second && count > 0)
      count--;
    if (seconds != clock->second) {
      write_string("Time is not standing still\n");
      exit (1);
    }
    write_string("The time now is: ");
    write_the_time(clock);
    write_line();
    clock->control = 0x00;
  }
  
  clock->control = 0x40;
  write_line();
  write_big_ben_time(clock);
  write_line();
  
  exit (0);
}
