#include "../lib/of1275.h"
#include "opic.h"

void
timeout(int count,
	unsigned *target,
	unsigned value)
{
  while (count > 0 && *target == value)
    count --;
  if (count <= 0) {
    write_string("timeout");
    write_line();
    exit(1);
  }
}


int
main()
{
  
  int i;
  opic_descriptor opic;

  opic_parse_args(&opic, 0);

  /* set the IPI registers */
  for (i = 0; i < nr_ipi; i++) {
    opic.global->ipi_vector_priority[i].reg =
      htovl(((i + 1) << 16)
	    | (i + 1));
  }


  /* enable delivery */
  for (i = 0; i < opic.nr_outputs; i++) {
    opic.per_processor[i].current_task_priority.reg = htovl(0);
  }


  /* interrupt and ack individual processors */

  for (i = 0; i < nr_ipi && 0; i++) {

    int cpu;

    for (cpu = 0; cpu < opic.nr_outputs; cpu++) {

      int j;

      /* interrupt just this cpu */
      opic.per_processor[cpu].interprocessor_interrupt_dispatch[i].reg = htovl(1 << cpu);

      /* check that just this cpu received an interrupt */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (opic.output[j] == 0) {
	    LINE;
	    write_string("interrupt not pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	}
	else {
	  if (opic.output[j] != 0) {
	    LINE;
	    write_string("interrupt should not be pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	}
      }

      /* clear this interrupt, checking that others haven't seen it */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != i + 1) {
	    LINE;
	    write_string("bad ack for cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
	else {
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	    LINE;
	    write_string("bad nonspurous ack for other cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
      }

      /* check no longer pending */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (opic.output[j] != 0) {
	    LINE;
	    write_string("interrupt not cleared for cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	}
	else {
	  if (opic.output[j] != 0) {
	    LINE;
	    write_string("interrupt cleared but pending to other cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	}
      }

      /* confirm that all processors have no ack */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	    LINE;
	    write_string("wanted spurious ack for cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
	else {
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	    LINE;
	    write_string("wanted spurious ack for other cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
      }
    }
  }


  /* interrupt and ack all processors */

  for (i = 0; i < nr_ipi; i++) {
    
    int cpu;

    for (cpu = 0; cpu < opic.nr_outputs; cpu++) {
      
      int j;

      /* interrupt all processors */
      opic.per_processor[cpu].interprocessor_interrupt_dispatch[i].reg = htovl(-1);

      /* check that all cpu's have this interrupt pending */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (opic.output[j] == 0) {
	  LINE;
	  write_string("interrupt not pending to cpu ");
	  write_int(j);
	  write_line();
	  exit(1);
	}
      }
      
      /* ack all cpu's */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != i + 1) {
	  LINE;
	  write_string("bad ack for cpu ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }

      /* check all interrupts cleared */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (opic.output[j] != 0) {
	  LINE;
	  write_string("interrupt still pending to cpu ");
	  write_int(j);
	  write_line();
	  exit(1);
	}
      }
      

      /* re-interrupt just this cpu */
      opic.per_processor[cpu].interprocessor_interrupt_dispatch[i].reg = htovl(1 << cpu);


      /* check this delivered to just this cpu */
      opic.per_processor[cpu].end_of_interrupt.reg = 0;
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (opic.output[j] == 0) {
	    LINE;
	    write_string("interrupt not pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != i + 1) {
	    LINE;
	    write_string("bad ack for cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
	else {
	  if (opic.output[j] != 0) {
	    LINE;
	    write_string("interrupt should not be pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	    LINE;
	    write_string("bad nonspurous ack for other cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
      }


      /* re-interrupt all other cpu's */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j != cpu)
	  opic.per_processor[j].end_of_interrupt.reg = 0;
      }
      opic.per_processor[cpu].interprocessor_interrupt_dispatch[i].reg =
	htovl(-1 & ~(1 << cpu));

      /* check this delivered to all others only */
      for (j = 0; j < opic.nr_outputs; j++) {
	if (j == cpu) {
	  if (opic.output[j] != 0) {
	    LINE;
	    write_string("interrupt should not be pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	    LINE;
	    write_string("interrupt ack should be spurious for cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
	else {
	  if (opic.output[j] == 0) {
	    LINE;
	    write_string("interrupt should be pending to cpu ");
	    write_int(j);
	    write_line();
	    exit(1);
	  }
	  if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != i + 1) {
	    LINE;
	    write_string("bad spurous ack for other cpu ");
	    write_int(j);
	    write_line();
	    exit (1);
	  }
	}
      }


      /* end all cpu's */
      for (j = 0; j < opic.nr_outputs; j++) {
	opic.per_processor[j].end_of_interrupt.reg = 0;
      }

    }

  }


  exit (0);
}
